/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	access.c (Access Control)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940303	created
//////////////////////////////////////////////////////////////////////#*/
#include "hostlist.h"
#include "delegate.h"
#include <ctype.h>

extern char *strdup();
extern char *getClientUserC();
#define Ident()	getClientUserC(Conn)

/*
 *	Reliable hosts for services with limited access.
 *	Normally this will be checked if the DeleGate server is on a FIREWALL.
 */
/* RELIABLE is obsoleted by PERMIT */

static HostList RelHostList   = { "RELIABLE",  16 };
static HostList ReachableList = { "REACHABLE", 16 };
static HostList IdentHostList = { "USERIDENT", 16 };

extern addHostList1();

static char authority[1024];
scan_AUTH(Conn,auth)
	char *auth;
{
	if( authority[0] != 0 )
		strcat(authority,",");
	strcat(authority,auth);
	/*fprintf(stderr,">>>>>>> %s [%s]\n",authority,auth);*/
}
static auth_match(cauth,tauth)
	char *cauth,*tauth;
{
	return strcmp(cauth,tauth) == 0;
}
static findAuth(what,proto,auth)
	char *what,*proto,*auth;
{	char xauth[1024];

	if( strcasecmp(proto,"smtp-vrfy") != 0 )
		proto = "*";

	sprintf(xauth,"%s:%s:%s",what,proto,auth);
	if( scan_List(authority,',',0,auth_match,xauth) )
		return 1;

	sprintf(xauth,"%s:%s:*",what,proto);
	if( scan_List(authority,',',0,auth_match,xauth) )
		return 1;

	return 0;
}
auth_manager(what,proto,host,user)
	char *what,*proto,*host,*user;
{	char userhost[256];

	sprintf(userhost,"%s@%s",user,host);
	return findAuth("manager",proto,userhost);
}
with_auth_anonftp()
{
	if( strstr(authority,"anonftp:") != 0 )
		return 1;
	else	return 0;
}
auth_anonftp(proto,user,pass)
	char *proto,*user,*pass;
{	char auth[256];

	if( strstr(authority,"anonftp:") == 0 )
		return 1;

	if( is_anonymous(user) || user[0] == 0 )
		return 0;
	if( strchr(user,'@') == 0 )
		return 0;
	sprintf(auth,"%s",pass);
	return findAuth("anonftp",proto,auth);
}
auth_proxy_auth()
{
	if( strstr(authority,"proxy:auth") )
		return 1;
	else	return 0;
}
auth_proxy_pauth()
{
	if( strstr(authority,"proxy:pauth") )
		return 1;
	else	return 0;
}

extern char *NOTIFY_PLATFORM;
static nplat;
NotifyPlatform(Conn,isreq)
	Connection *Conn;
{	char *host,hostb[256],*user;
	int port,match;

	if( nplat == 0 )
		nplat = makePathList("NotifyPlatform",NOTIFY_PLATFORM);

	if( isreq ){
		host = DST_HOST;
		port = DST_PORT;
		user = "-";
	}else{
		host = hostb;
		port = getClientHostPort(Conn,hostb);
		user = "-";
	}
	match = matchPath1(nplat,user,host,port);
	return match;
}
makeVia(Conn,received)
	Connection *Conn;
	char *received;
{
	if( strstr(authority,"forward") )
		ClientIF_HP(Conn,received);
	else	strcpy(received,"-");
}
makeForwarded(Conn,forwarded)
	Connection *Conn;
	char *forwarded;
{	char myuri[256],client[256];
	char myhp[256];

	if( strstr(authority,"forward") ){
		ClientIF_HP(Conn,myhp);
		sprintf(myuri,"http://%s/",myhp);
		getClientHostPort(Conn,client);
	}else{
		return 0;
		/*
		strcpy(myuri,"-");
		strcpy(client,"-");
		*/
	}
	sprintf(forwarded,"by %s (DeleGate/%s) for %s",
		myuri,(char*)DELEGATE_ver(),client);

	return 1;
}

makeAuthorization(Conn,genauth)
	Connection *Conn;
	char *genauth;
{	char *fmt,atype[128],afmt[128];
	char gauth[256],eauth[256],host[128];
	int port;
	char *dp;

	if( (fmt = strstr(authority,"authgen:")) == NULL )
		return 0;
	fmt += strlen("authgen:");
	atype[0] = afmt[0] = 0;
	sscanf(fmt,"%[^:,]:%[^,]",atype,afmt);
	atype[0] = toupper(atype[0]);

	strfConn(Conn,afmt,gauth);
	if( gauth[0] == 0 )
		return 0;

	gethostname(host,sizeof(host));
	strcat(gauth,"/");
	strcat(gauth,host);

	str_to64(gauth,strlen(gauth),eauth,512,1);
	if( dp = strpbrk(eauth,"\r\n") )
		*dp = 0;

	sprintf(genauth,"%s %s",atype,eauth);
	return 1;
}

makeFrom(Conn,genfrom)
	Connection *Conn;
	char *genfrom;
{	char *fmt,gfmt[128];

	genfrom[0] = 0;
	if( (fmt = strstr(authority,"fromgen")) == NULL )
		return 0;
	fmt += strlen("fromgen");

	strcpy(gfmt,"%u@%h");
	sscanf(fmt+1,":%[^,]",gfmt);
	strfConn(Conn,gfmt,genfrom);
	return 1;
}

makeClientLog(Conn,clientlog)
	Connection *Conn;
	char *clientlog;
{	char host[256],iuser[256],auser[256];
	char hfmt[128],ifmt[128],afmt[128];
	char *fmt;

	strcpy(hfmt,"%h");
	strcpy(ifmt,"%u");
	strcpy(afmt,"%U");
	if( fmt = strstr(authority,"log:") ){
		fmt += strlen("log:");
		sscanf(fmt,"%[^:,]:%[^:,]:%[^,]",hfmt,ifmt,afmt);
	}

	strfConn(Conn,hfmt,host);  if(host[0] ==0) strcpy(host,"-");
	strfConn(Conn,ifmt,iuser); if(iuser[0]==0) strcpy(iuser,"-");
	strfConn(Conn,afmt,auser); if(auser[0]==0) strcpy(auser,"-");

	sprintf(clientlog,"%s %s %s",host,iuser,auser);
}

/*
 *
 */
scan_RELIABLE(Conn,rels)
	Connection *Conn;
	char *rels;
{
	scan_commaList(rels,1,addHostList1,&RelHostList);
}
scan_REACHABLE(Conn,list)
	Connection *Conn;
	char *list;
{
	ReachableList.hl_noIdent = 1;
	scan_commaList(list,1,addHostList1,&ReachableList);
}

/*
 *	If no RELIABLE host is specified explicitly, then suppose that any
 *	hosts is relaible.  Typical case is that the DeleGate is running
 *	on the host which belongs to a secure network within a firewall.
 */
static RELIABLE_HOST(Conn,hostlist,srchost,srcport)
	Connection *Conn;
	HostList *hostlist;
	char *srchost;
{	char *suser;

	if( hostlist->hl_cnt == 0 )
		return 1;
/*
{
char ohost[128];
getOriginator(ohost);
printf("ROUTE: %s [%s]\n",get_PATH(),ohost);
}
*/
	if( Conn->cl_auth_user[0] ){
		srchost = Conn->cl_auth_host;
		srcport = 0;
		suser = Conn->cl_auth_user;
	}else{
		suser = Ident();
/*
		if( suser == NULL ){
			char qhost[128],quser[128];
			if( get_equiv_user(srchost,srcport,qhost,quser) ){
				suser = quser;
				srchost = qhost;
				srcport = 0;
			}
		}
*/
	}
	return hostIsinList_byname(hostlist,DFLT_PROTO,srchost,srcport,suser);
}
static REACHABLE_HOST(Conn,hostlist,proto,hostname,dstport)
	Connection *Conn;
	HostList *hostlist;
	char *proto;
	char *hostname;
{	char *duser = Conn ? DST_USER : NULL;

	if( hostlist->hl_cnt == 0 )
		return 1;
	if( Conn != NULL && Conn->no_dstcheck )
		return 1;

	return hostIsinList_byname(hostlist,proto,hostname,dstport,duser);
}
source_permitted(Conn)
	Connection *Conn;
{	int ok;

	Conn->no_dstcheck = 1;
	ok = service_permitted2(Conn,DST_PROTO,1);
	Conn->no_dstcheck = 0;
	return ok;
}
service_permitted0(clhost,clport,svproto,svhost,svport)
	char *clhost,*svproto,*svhost;
{	Connection ConnBuf, *Conn = &ConnBuf;
	int ok;

	ConnInit(Conn);
	_ClientAddr = clhost;
	_ClientHost = clhost;
	_ClientPort = clport;
	set_realsite(Conn,svproto,svhost,svport);
	ok = service_permitted2(Conn,svproto,1);
	if( !ok ){
		daemonlog("E","No permission: %s:%d > %s://%s:%d\n",
			clhost,clport,svproto,svhost,svport);
	}
	return ok;
}
method_permitted0()
{
	return 1;
}

/*
 *	Not implemented yet
 *	(This is done in RELIABLE_HOST() ?)
 */
static PERMITTED_USER(Conn,hostlist,hostname,lport,stdport)
	Connection *Conn;
	HostList *hostlist;
	char *hostname;
{
	if( hostlist->hl_cnt == 0 )
		return 1;
	return 1;
}

static PERMITTED_PORT(Conn,proto,host,port)
	Connection *Conn;
	char *proto,*host;
{	int stdport;

	if( streq(proto,"telnet") ){
	    stdport = serviceport("telnet");

if( getenv("ANYPORT") == 0 )
	    if( port != 0 && port != stdport ){
		if( ImProxy )
			sv1log("Proxy telnet follows PERMIT parameter\n");
		else
		if( streq(iSERVER_PROTO,"telnet") && port==iSERVER_PORT )
			sv1log("TELNET to non-standard port: %d %d/%d\n",
				port,DFLT_PORT,iSERVER_PORT);
		else{
			Verbose("cannot TELNET to non-standard port %d\n",
				DFLT_PORT);
			return 0;
		}
	    }
	}
	if( port == 19 ){
		if( streq(proto,"http") || streq(proto,"gopher") ){
			sv1log("HTTP,Gopher to 19(chargen) is inhibited.\n");
			return 0;
		}
	}
	return 1;
}
static PERMITTED_PAIR(Conn,proto,dhost,dport,shost,sport)
	Connection *Conn;
	char *proto,*dhost,*shost;
{
	return DELEGATE_permit(Conn,proto,dhost,dport,shost,sport);
}

PERMITTED_ACCESS(Conn,shost,sport,stdport)
	Connection *Conn;
	char *shost;
{	int permitted = 0;

	if(!RELIABLE_HOST(Conn,&RelHostList,shost,sport))
		Verbose("not RELIABLE\n");
	else
	if(!PERMITTED_USER(Conn,&RelHostList,shost,sport,stdport))
		Verbose("not PERMITTED_USER\n");
	else
	if(!REACHABLE_HOST(Conn,&ReachableList,DST_PROTO,DST_HOST,DST_PORT))
		Verbose("not REACHABLE\n");
	else
	if(!PERMITTED_PORT(Conn,DST_PROTO,DST_HOST,DST_PORT))
		Verbose("not PERMITTED_PORT\n");
	else
	if(!PERMITTED_PAIR(Conn,DST_PROTO,DST_HOST,DST_PORT,shost,sport))
		Verbose("not PERMITTED_PAIR\n");
	else
		permitted = 1;

if(!permitted)
if(LOG_GENERIC){
char *user;
if( (user = getClientUserC(Conn)) == NULL )
	user = "-";
fputLog(Conn,"Reject","%s@%s:%d; to=%s://%s:%d\n",
user,shost,sport,
DST_PROTO,DST_HOST,DST_PORT);
}

	return permitted;
}

char *scanIdent(iresp,sys,user)
	char *iresp,*sys,*user;
{	char buf[1024],*dp;

	strcpy(buf,iresp);
	if( dp = strpbrk(buf,"\r\n") )
		*dp = 0;
	user[0] = 0;
	sscanf(buf,"%*d%*[ ,]%*d%*[ :]USERID%*[ :]%[^ :]%*[ :]%s\n",sys,user);

	if( user[0] ){
		Verbose("-- ident: %s : %s\n",sys,user);
		return user;
	}else{
		Verbose("-- ident: %s",iresp);
		return 0;
	}
}

getClientHostPortAddr(Conn,rhost,raddr)
	Connection *Conn;
	char *rhost,*raddr;
{	char addrhostport[256],addr[256],host[256];
	int port;

	if( _ClientHost == NULL ){
		if( getpeerName(Conn->cl_sock,addrhostport,PN_ADDRHOSTPORT) )
		if( sscanf(addrhostport,"%s %s %d",addr,host,&port) == 3 ){
			_ClientAddr = strdup(addr);
			_ClientHost = strdup(host);
			_ClientPort = port;
		}
	}
	if( _ClientHost == NULL )
		return 0;

	if( rhost != NULL ) strcpy(rhost,_ClientHost);
	if( raddr != NULL ) strcpy(raddr,_ClientAddr);
	return _ClientPort;
}
getClientHostPort(Conn,rhost)
	Connection *Conn;
	char *rhost;
{
	return getClientHostPortAddr(Conn,rhost,NULL);
}

double IDENT_TIMEOUT = 10;

char *getClientUser0(Conn,hostname,porti,userbuf)
	Connection *Conn;
	char *hostname;
	char *userbuf;
{	int idsv;
	FILE *ti,*fi;
	char resp[1024],sys[128],*user;
	char *myhost;
	int myport;
	int timeout;

	Verbose("-- ident: %s\n",hostname);
	myhost = Conn->cl_sockHOSTaddr;
	idsv = Socket1("IDENT",-1,NULL,NULL,NULL, myhost,0,NULL,0, 0,NULL,0);
	if( 0 <= idsv ){
		timeout = IDENT_TIMEOUT * 1000;
		if( IDENT_TIMEOUT != 0 && timeout == 0 )
			timeout = 1;
		if( connectTimeout(idsv,hostname,113,timeout) != 0 ){
			sv1log("### IDENT CONNECT TIMOEUT (%dms)\n",timeout);
			close(idsv);
			idsv = -1;
		}
	}
	Verbose("-- ident: %d\n",idsv);

	user = NULL;
	if( 0 <= idsv ){
		ti = fdopen(idsv,"w");
		fi = fdopen(idsv,"r");
		sockHostport(Conn->cl_sock,&myport);
		fprintf(ti,"%d, %d\r\n",porti,myport);
		Verbose("-- ident: %d, %d\n",porti,myport);
		fflush(ti);
		if( fgetsTIMEOUT(resp,sizeof(resp),fi) == NULL )
			Verbose("-- ident: EOF from the server.\n");
		else{
			if( scanIdent(resp,sys,userbuf) )
				user = userbuf;
		}
		fclose(ti);
		fclose(fi);
	}
	return user;
}
static char *getPortUser(Conn,hostport,userbuf)
	Connection *Conn;
	char *hostport,*userbuf;
{	char host[1024];
	int port;

	if( sscanf(hostport,"%[^:]:%d",host,&port) == 2 )
		return getClientUser0(Conn,host,port,userbuf);
	return NULL;
}

enableClientIdent(host)
	char *host;
{
	Verbose("-- ident: ENABLE{%s}\n",host);
	scan_commaList(host,1,addHostList1,&IdentHostList);
}

#define DONT_TRY	(char*)-1
#define CANT_CONN	(char*)-2

char *getClientUserH0(Conn,hostname,hosti,porti,force)
	Connection *Conn;
	char *hostname;
{	char user[128];
	int isin;

	if( _ClientUser != NULL )
	if( !(force && _ClientUser == DONT_TRY) )
		goto EXIT;

	if( force )
		isin = 1;
	else
	if( hosti )
		isin = hostIsinList(&IdentHostList,ANYP,hostname,hosti,0,NULL);
	else	isin = hostIsinList_byname(&IdentHostList,ANYP,hostname,0,NULL);

	if( !isin )
		_ClientUser = DONT_TRY;
	else
	if( getClientUser0(Conn,hostname,porti,user) )
		_ClientUser = strdup(user);
	else	_ClientUser = CANT_CONN;

EXIT:
	if( _ClientUser == DONT_TRY || _ClientUser == CANT_CONN )
		return NULL;
	else	return _ClientUser;
}
char *getClientUserH(Conn,hostname,hosti,porti)
	Connection *Conn;
	char *hostname;
{
	return getClientUserH0(Conn,hostname,hosti,porti,0);
}

char *getClientUser(Conn)
	Connection *Conn;
{	char host[256];
	int port;

	if( port = getClientHostPort(Conn,host) )
		return getClientUserH0(Conn,host,0,port,1);
	return NULL;
}
char *getClientUserC(Conn)
	Connection *Conn;
{	char host[256];
	int port;

	if( port = getClientHostPort(Conn,host) )
		return getClientUserH(Conn,host,0,port);
	return NULL;
}
char *getClientUserMbox(Conn,mbox)
	Connection *Conn;
	char *mbox;
{	char host[256],user[256];
	int port;

	strcpy(mbox,"?");
	if( port = getClientHostPort(Conn,host) ){
		if( getClientUser0(Conn,host,port,user) ){
			getFQDN(host,host);
			sprintf(mbox,"%s@%s",user,host);
			return mbox;
		}
	}
	return NULL;
}


/*
 *	PERMIT about RELAY function
 *	control accessibility of relay function
 */
scan_RELAY1(relay1,Conn)
	char *relay1;
	Connection *Conn;
{
	scan_CMAP2(Conn,"relay",relay1);
	return 0;
}
scan_RELAY(Conn,relay)
	Connection *Conn;
	char *relay;
{
	scan_List(relay,';',0,scan_RELAY1,Conn);
}
do_RELAY(Conn,what)
	Connection *Conn;
{	char realm[128];
	int found;

	/* this function should be unified with service_permitted() ... */
	if( Conn->from_myself )
		return 1;

	pushClientInfo(Conn);
	found = find_CMAP(Conn,"relay",realm);
	popClientInfo();
	if( 0 <= found ){
		if( strstr(realm,"proxy") && (what & RELAY_PROXY) )
			return 1;
		if( strstr(realm,"delegate") && (what & RELAY_DELEGATE) )
			return 1;
	}
	return 0;
}

Connection *FORCE_REWRITE = (Connection*)-1;
/*
it's too heavy to be checked for each embedded URL in HTML...

isRELAYABLE(Conn,proto,hostport)
	Connection *Conn;
	char *proto,*hostport;
{
	if( Conn == FORCE_REWRITE )
		return 1;
	return do_RELAY(Conn,RELAY_DELEGATE);
}
*/

isREACHABLE(proto,hostport)
	char *proto,*hostport;
{	char host[128];
	int port;
	int svf,yes;

	port = scan_hostport(proto,hostport,host);
	svf = RES_CACHEONLY(1);
	yes = REACHABLE_HOST(NULL,&ReachableList,ANYP,host,port);
	RES_CACHEONLY(svf);
	return yes;
}

NotREACHABLE(Conn,proto,host,port)
	Connection *Conn;
	char*proto,*host;
{	int reach;

	if( Conn != NULL
	 && Conn->no_dstcheck_proto
	 && Conn->no_dstcheck_proto == serviceport(proto) )
		return 0;

	if( notREMITTABLE(proto,port) )
		return 1;

	pushClientInfo(Conn);
	reach = REACHABLE_HOST(NULL,&ReachableList,proto,host,port);
	popClientInfo();
	if( !reach )
		return 1;

	return 0;
}
char *getClientHostPortUser(Conn,host,portp)
	Connection *Conn;
	char *host;
	int *portp;
{	int port;

	port = getClientHostPort(Conn,host);
	if( portp ) *portp = port;
	if( port )
		return getClientUserH0(Conn,host,0,port,1);
	else	return NULL;
}

addRejectList(Conn,what,dpath,referer,auser,apass,reason)
	Connection *Conn;
	char *what,*dpath,*referer,*auser,*apass,*reason;
{	char src_host[256],*src_user;
	int src_port;

	src_user = getClientHostPortUser(Conn,src_host,&src_port);
	if( src_user == NULL )
		src_user = "-";

	if( *apass != 0 )
	if( !strcaseeq(auser,"anonymous") )
	if( !strcaseeq(auser,"ftp") || !strcaseeq(DST_PROTO,"ftp") )
		apass = "*";

	if( *referer == 0 )
		referer = "-";

	putRejectList(what,
		DST_PROTO, DST_HOST,DST_PORT, dpath, referer,
		DFLT_PROTO,src_host,src_port, src_user,
		auser,apass,reason);
}

auth_cache(store,expire,proto,user,pass,host,port)
	char *proto,*user,*pass,*host;
{	char uh[128],uh_md5[128],pw_md5[128],rpath[1024],apath[1024],cpass[128];
	FILE *afp;

	sprintf(uh,"%s://%s@%s:%d",proto,user,host,port);
	Verbose("AUTH_CACHE %d %s\n",store,uh);

	toMD5(uh,uh_md5);
	toMD5(pass,pw_md5);
	sprintf(rpath,"%d/%s",SERVER_PORT(),uh_md5);
	cache_path("delegate","auth",9999,rpath,apath);

	if( store ){
		if( afp = dirfopen("AUTH",apath,"w") ){
			fprintf(afp,"%s\n",pw_md5);
			fclose(afp);
			return 0;
		}else	return -1;
	}else{
		if( afp = expfopen("AUTH",expire,apath,"r",NULL) ){
			fscanf(afp,"%s",cpass);
			fclose(afp);
			if( strcmp(pw_md5,cpass) == 0 ){
				Verbose("cached auth OK: %s@%s\n",user,host);
				return 1;
			}
		}
		return 0;
	}
}

#define IDENTIFY_MAP	"Identifier"
#define AUTHORIZE_MAP	"Authorizer"
#define AUTHSERV_MAP	"AuthServer"

#define I_IDENT		"?"
#define I_FTP		"&"
#define I_ANY		"*"
#define AUTH_VDOM	"-AUTH"

scan_AUTHORIZER(Conn,authserv)
	Connection *Conn;
	char *authserv;
{	char vauthserv[256],aserv[256],proto[256],dhost[256];

/*
	if( !streq(authserv,I_IDENT) && !streq(authserv,I_FTP) ){
		if( num_ListElems(authserv,':') == 1 ){
			sprintf(vauthserv,"%s.%s",authserv,AUTH_VDOM);
			scan_RELIABLE(Conn,vauthserv);
		}else{
			scan_ListList(authserv,':',aserv,proto,dhost);
			if( aserv[0] == 0 ) strcpy(aserv,"*");
			if( proto[0] == 0 ) strcpy(proto,"*");
			if( dhost[0] == 0 ) strcpy(dhost,"*");
			sprintf(vauthserv,"%s:%s:%s.%s",
				proto,dhost,aserv,AUTH_VDOM);
			scan_PERMIT(Conn,vauthserv);
		}
	}
*/
	scan_CMAP2(Conn,AUTHSERV_MAP,authserv);
}
static Identify(Conn,identonly,fc,tc,authserv,user,host,phost,func,arg)
	Connection *Conn;
	FILE *fc,*tc;
	char *authserv,*user,*host,*phost;
	int (*func)();
	char *arg;
{	int ci;
	char userhost[1024],pass[256];
	char aproto[64],ahost[256];
	int aport;
	char clhost[256];
	char *iuser;

	*user = *host = *pass = 0;
	getpeerNAME(FromC,clhost,NULL,NULL);

	if( wordIsinList(authserv,I_IDENT) )
	if( iuser = getClientHostPortUser(Conn,clhost,NULL) ){
		strcpy(user,iuser);
		strcpy(host,clhost);
		strcpy(phost,host);
		goto EXIT;
	}
	if( strcmp(authserv,"&") == 0 )
	fprintf(tc,">>>>>>>> login with your account at <%s>\r\n",clhost);

	fprintf(tc,">>>>>>>> Username: ");
	fflush(tc);
	ci = (*func)(1,fc,tc,userhost,arg);
	if( ci == EOF )
		return 0;

	sscanf(userhost,"%[^@]@%s",user,host);
	strcpy(phost,"******");

	if( host[0] ){
		if( wordIsinList(authserv,host) ){ 
			/* authorized */
		}else
		if( wordIsinList(authserv,I_FTP) && hostcmp(host,clhost) == 0 ){
			/* not authorized */
		}else
		if( wordIsinList(authserv,I_ANY) ){
			/* not authorized */
		}else{
			fprintf(tc,"!!!!!!!! %s: not authentiation server\r\n",
				host);
			fflush(tc);
			return 0;
		}
		strcpy(phost,host);
	}else{
		if( wordIsinList(authserv,I_FTP) ){
			/* authorized */
			strcpy(host,clhost);
			strcpy(phost,host);
		}else{
			/* authorized */
			sscanf(authserv,"%[^,]",host);
		}
	}
	if( streq(host,I_ANY) ){
		fprintf(tc,"!!!!!!!! enter user@yourAuthHost\r\n");
		fflush(tc);
		return 0;
	}
/*
	if( !identonly && !service_authorized(Conn,user,host) ){
		fprintf(tc,"<<<<<<<< No, <%s@%s> is not an authorized user\r\n",
			user,phost);
		fflush(tc);
		return 0;
	}
*/

	fprintf(tc,">>>>>>>> Password: ");
	ci = (*func)(0,fc,tc,pass,arg);
	if( ci == EOF )
		return 0;
	fflush(tc);

	if( Authenticate(Conn,host,user,pass,"/") < 0 ){
		if( user[0] || pass[0] )
		fprintf(tc,
		"!!!!!!!! USER <%s@%s> authentication failed\r\n",user,phost);
		fflush(tc);
		return 0;
	}

EXIT:
	return 1;
}

service_authorized(Conn,user,host)
	Connection *Conn;
	char *user,*host;
{	int ok;
	char suser[256],shost[256],ahost[256];

	strcpy(shost,Conn->cl_auth_host);
	strcpy(suser,Conn->cl_auth_user);

	sprintf(ahost,"%s.%s",host,AUTH_VDOM);
	strcpy(Conn->cl_auth_host,ahost);
	strcpy(Conn->cl_auth_user,user);

	Conn->auth_check = 1;
	ok = service_permitted2(Conn,DST_PROTO,1);
	Conn->auth_check = 0;

	strcpy(Conn->cl_auth_host,shost);
	strcpy(Conn->cl_auth_user,suser);
	return ok;
}

doAUTH(Conn,fc,tc,dstproto,dsthost,dstport,auser,ahost,func,arg)
	Connection *Conn;
	FILE *fc,*tc;
	char *dstproto,*dsthost,*auser,*ahost;
	int (*func)();
	char *arg;
{	char authserv[1024],phost[256];
	int identonly;
	int authorized;

	*auser = *ahost = 0;
/*
	if( Conn->cl_auth_user[0] != 0 )
	if( source_permitted(Conn) )
*/
	if( streq(DST_PROTO,dstproto) )
	if( streq(DST_HOST,dsthost) )
	if( DST_PORT == dstport )
	{
		sv1log("#### already authorized\n");
		return 0;
	}
	set_SERVER(Conn,dstproto,dsthost,dstport);

	if( 0 <= find_CMAP(Conn,IDENTIFY_MAP,authserv) ){
		identonly = 1;
	}else
	if( 0 <= find_CMAP(Conn,AUTHSERV_MAP,authserv) ){
		identonly = 0;
	}else{
		sv1log("#### no authorization required\n");
		return 0;
	}

	fprintf(tc,
		"<<<<<<<< Authorization for this proxy required.\r\n");

	for(;;){
		if( Identify(Conn,identonly,fc,tc,authserv,auser,ahost,phost,func,arg) )
			break;
		if( auser[0] == 0 )
			return EOF;
	}

	if( identonly ){
		fprintf(tc,
		"<<<<<<<< Ok, You are identified as <%s@%s>\r\n",auser,phost);
		authorized = service_authorized(Conn,auser,ahost);
	}else	authorized = 1;

	if( authorized ){
		fprintf(tc,
		"<<<<<<<< Ok, you <%s@%s> are an authorized user :-)\r\n",
			auser,phost);
		return 0;
	}else{
		fprintf(tc,
		"!!!!!!!! USER <%s@%s> not permitted by DeleGate.\r\n",
			auser,phost);
		fflush(tc);
		return EOF;
	}
}

static connect_auth(proto,host,port,user,pass,path,svfp)
	char *proto,*host,*user,*pass,*path;
	FILE *svfp[];
{	int svsock,io[2];
	Connection ConnBuf,*Conn = &ConnBuf;

	if( auth_cache(0,180,proto,user,pass,host,port) )
		return 1;

	ConnInit(Conn);
	Conn->from_myself = 1;
	Conn->co_mask |= CONN_NOPROXY;

	set_realserver(Conn,proto,host,port);
	Socketpair(io);

	svsock = connect_to_serv(Conn,io[0],io[1],0);
	close(io[0]);
	close(io[1]);
	if( svsock < 0 ){
		sv1tlog("cannot connect: %s://%s@%s/\n",proto,user,host);
		return -1;
	}

	svfp[0] = fdopen(svsock,"r");
	svfp[1] = fdopen(svsock,"w");
	return 0;
}

authenticate_by_FTP(Conn,host,user,pass,path)
	Connection *Conn;
	char *host,*user,*pass,*path;
{	FILE *svfp[2];
	char resp[1024];
	int rcode;

	if( rcode = connect_auth("ftp", host,21,user,pass,path,svfp) )
		return rcode;

	rcode = ftp_auth(svfp[1],svfp[0],resp,sizeof(resp),user,pass);
	fclose(svfp[0]);
	fclose(svfp[1]);

	if( rcode == EOF )
		return -1;
	else{
		auth_cache(1,180,"ftp",user,pass,host,21);
		return 0;
	}
}

char *http_authbase = "/delegate-auth";

authenticate_by_HTTP(Conn,host,user,pass,path)
	Connection *Conn;
	char *host,*user,*pass,*path;
{	FILE *svfp[2];
	int rcode;
	char buff[1024],authBASIC[1024],authMD5[1024],resp[1024],*dp;
	char me[256];
	int scode;
	char authpath[1024];

	sprintf(buff,"%s:%s",user,pass);
	toMD5(buff,authMD5);
	str_to64(buff,strlen(buff),authBASIC,sizeof(authBASIC),1);
	if( dp = strpbrk(authBASIC,"\r\n") )
		*dp = 0;
	ClientIF_name(Conn,ClientSock,me);

	if( rcode = connect_auth("http",host,80,user,pass,path,svfp) )
		return rcode;
sprintf(authpath,"%s/%s/%s",http_authbase,me,authMD5);
	fprintf(svfp[1],"HEAD %s HTTP/1.0\r\n",authpath);
	fprintf(svfp[1],"\r\n");
	fflush(svfp[1]);
	sv1log("HTTP-AUTH << path=%s user=%s\n",authpath,user);
	rcode = -1;
	if( fgets(resp,sizeof(resp),svfp[0]) != NULL ){
		sv1log("HTTP-AUTH >> %s",resp);
		if( sscanf(resp,"HTTP/%*s %d",&scode) )
			if( scode == 200 ){
				rcode = 0;
				goto EXIT;
			}
	}

	fclose(svfp[0]);
	fclose(svfp[1]);
	if( rcode = connect_auth("http",host,80,user,pass,path,svfp) )
		return rcode;

sprintf(authpath,"%s/%s/%s",http_authbase,me,user);
	fprintf(svfp[1],"HEAD %s HTTP/1.0\r\n",authpath);
	fprintf(svfp[1],"Authorization: Basic %s\r\n",authBASIC);
	fprintf(svfp[1],"\r\n");
	fflush(svfp[1]);
	sv1log("HTTP-AUTH << path=%s user=%s\n",authpath,user);
	rcode = -1;
	if( fgets(resp,sizeof(resp),svfp[0]) != NULL ){
		sv1log("HTTP-AUTH >> %s",resp);
		if( sscanf(resp,"HTTP/%*s %d",&scode) )
			if( scode == 200 ){
				rcode = 0;
				goto EXIT;
			}
	}

EXIT:
	fclose(svfp[0]);
	fclose(svfp[1]);
	return rcode;
}

typedef int (*IFUNC)();
typedef struct {
	char	*a_name;
	IFUNC	 a_func;
} AuthServ;
static AuthServ authenticators[] = {
	{"FTP",  authenticate_by_FTP	},
	/*{"HTTP", authenticate_by_HTTP	},*/
	0
};

Authenticate(Conn,host,user,pass,path)
	Connection *Conn;
	char *host,*user,*pass,*path;
{	int rcode;
	int ai;
	int (*afunc)();

	rcode = -1;
	for( ai = 0; afunc = authenticators[ai].a_func; ai++ ){
		rcode = (*afunc)(Conn,host,user,pass,path);
		sv1log("## Auth/%s = %d\n",authenticators[ai].a_name,rcode);
		if( 0 <= rcode )
			return rcode;
	}
	return rcode;
}

preset_login(method,vurl,user,pass,path)
	char *method,*vurl;
	char *user,*pass,*path;
{	char proto[128],site[1024];
	char ub[256],wb[256],pb[1024];

	if( mount_url_to(method,vurl) ){
		decomp_absurl(vurl,proto,site,pb);
		if( strchr(site,'@') ){
			/* with USER:PASS@SERVER */
			if( user || pass || path ){
				decomp_site("ftp",site,ub,wb,NULL,NULL);
				if( user ) strcpy(user,ub);
				if( pass ) strcpy(pass,wb);
				if( path ) strcpy(path,pb);
			}
			return 1;
		}
	}
	return 0;
}

unescape_user_at_host(email)
	char *email;
{	char *dp;
	extern char *strrpbrk();

	if( strchr(email,'@') == 0 )
	if( dp = strrpbrk(email,"%") ){
		*dp = '@';
		return 1;
	}
	return 0;
}
