/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	ntod.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	Nov1994	created
ToDo:
	sort address list and binary search...
//////////////////////////////////////////////////////////////////////#*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <string.h>

extern char *wordscan();

Finish(code){ exit(code); }

scan4num(addr,av)
	char *addr;
	int *av;
{	char *ap,ch;
	int ai,ac,num;

	ap = addr;
	for( ac = 0; *ap && ac < 4; ac++ ){
		num = 0;
		while( ch = *ap ){
			ap++;
			if( ch == '.' )
				break;
			if( !isdigit(ch) )
				goto EXIT;
			num = num * 10 + (ch - '0');
		}
		av[ac] = num;
	}
EXIT:
	for( ai = ac; ai < 4; ai++ )
		av[ai] = 0;
	return ac;
}
inetADDR(addr)
	char *addr;
{	int av[4];
	char ac,*ap;

	for( ap = addr; ac = *ap; ap++ )
		if( ac != '.' && (ac < '0' || '9' < ac) )
			return 0;

	scan4num(addr,av);
	return (av[0] << 24) | (av[1] << 16) | (av[2] << 8) | av[3];
}
static unsigned long inet_addr(addr)
	char *addr;
{	int av[4];

	if( scan4num(addr,av) == 4 )
	return (av[0] << 24) | (av[1] << 16) | (av[2] << 8) | av[3];
	return -1;
}

getMASK(iaddr)
	unsigned int iaddr;
{	int a1,mask;

	a1 = (iaddr >> 24) & 0xFF;
	if( a1 < 128       ) mask = 0xFF000000; else
	if( a1 < 128+64    ) mask = 0xFFFF0000; else
	if( a1 < 128+64+32 ) mask = 0xFFFFFF00; else
			     mask = 0xFFFFFF00;
	return mask;
}

typedef struct {
	int	full;
	int	maskedL;
	int	maskedH;
	char	*name;
} DName;

DName DnTab[0x10000];
int DnTabX;

static load_dn1(addrL,addrH,name)
	char *addrL,*addrH,*name;
{	int addri;
	char *np;
	DName *dnp;

	dnp = &DnTab[DnTabX++];
	if( inet_addr(addrL) != -1 ){
		dnp->full = 1;
		dnp->maskedL = inet_addr(addrL);
		dnp->maskedH = inet_addr(addrH);
	}else{
		addri = inetADDR(addrL);
		dnp->maskedL = addri & getMASK(addri);
		addri = inetADDR(addrH);
		dnp->maskedH = addri & getMASK(addri);
	}
	dnp->name = strdup(name);
	for( np = dnp->name; *np; np++ )
		*np = tolower(*np);
}

inet_range(addr)
	char *addr;
{	char addr0[128],addrx[128],*ap;
	int masklen,mask,addr1,addr2,mx,a1,a2;
	
	if( sscanf(addr,"%[^/]/%d",addr0,&masklen) != 2 )
		return;
	if( masklen < 24 )
		fprintf(stderr,"Warning: too long mask ? %s\n",addr);

	addr1 = inetADDR(addr0);
	mask = 0;
	for( mx = 0; mx < (32-masklen); mx++ )
		mask |= (1 << mx);
	addr2 = addr1 + mask;

	ap = addrx;
	*ap = 0;

	for( mx = 0; mx < 4; mx++ ){
		if( mx != 0 ){
			*ap++ = '.';
			*ap = 0;
		}
		a1 = (addr1 >> (8*(3 - mx))) & 0xFF;
		a2 = (addr2 >> (8*(3 - mx))) & 0xFF;

		if( a1 == a2 ){
			sprintf(ap,"%d",a1);
			ap += strlen(ap);
		}else{
			sprintf(ap,"[%d-%d]",a1,a2);
			break;
		}
	}
	strcpy(addr,addrx);
}

static char dbfile0[1024];
load_dntab(dbfile)
	char *dbfile;
{	FILE *dntab;
	char line[256];
	char *dp,addr[128],name[128];
	int tabx;

	if( File_cmp(dbfile0,dbfile) == 0 )
		return;
	strcpy(dbfile0,dbfile);

	dntab = fopen(dbfile,"r");
	if( dntab == NULL )
		return;

	tabx = DnTabX;
	while( fgets(line,sizeof(line),dntab) != NULL ){
		if( dp = strchr(line,'#') )
			*dp = 0;
		if( line[0] == 0 )
			continue;

		dp = wordscan(line,addr);
		wordscan(dp,name);
		if( addr[0] == 0 || name[0] == 0 ){
			fprintf(stderr,"? %s",line);
			continue;
		}

		if( dp = strchr(addr,'/') )
			inet_range(addr);

		if( dp = strchr(addr,'[') ){
			char addrC[128],addrL[128],addrH[128];
			int aH,aL;

			strcpy(addrC,addr);
			*strchr(addrC,'[') = 0;
			sscanf(dp+1,"%d-%d",&aL,&aH);
			sprintf(addrL,"%s%d",addrC,aL);
			sprintf(addrH,"%s%d",addrC,aH);
			load_dn1(addrL,addrH,name);
		}else	load_dn1(addr,addr,name);
	}
	fclose(dntab);
	fprintf(stderr,"LOADED %s [%d]\n",dbfile,DnTabX-tabx);
}

char *getdomainbyaddr(iaddr)
{	int ma,ai;
	DName *dnp;

	ma = iaddr & getMASK(iaddr);
	for( ai = 0; ai < DnTabX; ai++ ){
		dnp = &DnTab[ai];
		if( dnp->full ){
			if( dnp->maskedL <= iaddr && iaddr <= dnp->maskedH )
				return dnp->name;
		}else{
			if( dnp->maskedL <= ma && ma <= dnp->maskedH )
				return dnp->name;
		}
	}
	return 0;
}

static is_inetaddr(addr)
	char *addr;
{	char *ap,ch;

	for( ap = addr; ch = *ap; ap++ ){
		if( ch != '.' && !isdigit(ch) )
			return 0;
		if( strchr(" \t\r\n",ch) )
			break;
	}
	return 1;
}
static strip_inaddr(host)
	char *host;
{	char *sp,*psp;

	if( (sp = strstr(host,".IN-ADDR.ARPA"))
	 || (sp = strstr(host,".in-addr.arpa")) ){
		fprintf(stderr,"< %s\n",host);
		psp = NULL;
		for( sp--; host < sp; sp-- ){
			if( *sp == '.' ){
				if( sp[1] < '0' || '9' < sp[1] ){
					*psp = 0;
					break;
				}
				psp = sp;
			}
		}
		fprintf(stderr,"> %s\n",host);
	}
}

char *hostsfile;
extern char *getenv();

main(ac,av)
	char *av[];
{	char iline[4096],*sp,sc,*dp,class;
	char hostaddr[1024],*hp,prefix[1024],*remain;
	int a1;
	int ina;
	char *dom;
	char *dbfile;
	char *aliases,aliasb[1024];
	char hostsdb[1024];
	int ai,add_host;

	add_host = getenv("ADDHOST") != NULL;
	for( ai = 1; ai < ac; ai++ ){
		if( av[ai][0] == '+' )
			add_host = 1;
	}
	if( add_host )
		RES_verify("");

	dbfile = getenv("NETDOMDB");
	if( dbfile == NULL )
		dbfile = "./netdom";

	aliases = getenv("DOMALIAS");
	if( aliases == NULL ){
		strcpy(aliasb,dbfile);
		strcat(aliasb,".alias");
		aliases = aliasb;
	}

	hostsfile = getenv("HOSTSDB");
	if( hostsfile == NULL ){
		strcpy(hostsdb,dbfile);
		strcat(hostsdb,".hosts");
		hostsfile = hostsdb;
	}

	load_dntab(hostsfile);
	load_dntab(dbfile);

	RES_order("D",NULL);

	while( fgets(iline,sizeof(iline),stdin) != NULL ){
		if( dp = strpbrk(iline,"\r\n") )
			*dp = 0;

		hp = hostaddr;
		prefix[0] = 0;
		for( sp = iline; sc = *sp; sp++ ){
			if( sc == '@' ){
				*sp = 0;
				strcpy(prefix,iline);
				hp = hostaddr;
				continue;
			}
			if( sc==' '||sc=='\t'||sc=='\r'||sc=='\n' )
				break;
			if( isupper(sc) )
				*hp++ = tolower(sc);
			else	*hp++ = sc;
		}
		*hp = 0;
		remain = sp;

		strip_inaddr(hostaddr);

		if( *hostaddr == 0 )
			goto PUT;

		if( ina = inetADDR(hostaddr) )
		if( dom = getdomainbyaddr(ina) ){
			strcpy(hostaddr,dom);
		}else
		if( add_host ){
			char addr_host[1024],addr[128],host[256];
			FILE *hostsdb_fp;

			if( RES_1s(hostaddr,addr_host) ){
				sscanf(addr_host,"%s %s",addr,host);
				strip_inaddr(host);
				load_dn1(addr,addr,host);

				if( hostsdb_fp = fopen(hostsfile,"a") ){
					fprintf(stderr,"++ %s",addr_host);
					fputs(addr_host,hostsdb_fp);
					fclose(hostsdb_fp);
				}
				strcpy(hostaddr,host);
			}
		}

		if( is_inetaddr(hostaddr) ){
			fprintf(stderr,"?? %s\n",hostaddr);
			a1 = atoi(hostaddr);
			if( a1 < 128       ) class = 'A'; else
			if( a1 < 128+64    ) class = 'B'; else
			if( a1 < 128+64+32 ) class = 'C'; else
					     class = 'D';
			dp = hostaddr;
			dp = strchr(dp+1,'.');
			if( dp == NULL )
				goto PUT;
			if( class != 'A' ){
				if( dp == NULL )
					goto PUT;
				dp = strchr(dp+1,'.');
				if( dp == NULL )
					goto PUT;
				if( class != 'B' ){
					dp = strchr(dp+1,'.');
					if( dp == NULL )
						goto PUT;
				}
			}
			*dp = 0;
			printf("%c:",class);
		}else{
			generic_domain(hostaddr);
		}
	PUT:
		fseek(stdout,0,2);
		if( prefix[0] != 0 )
			fprintf(stdout,"%s@",prefix);
		fputs(hostaddr,stdout);
		fputs(remain,stdout);
		fputs("\n",stdout);
		fflush(stdout);
	}
}


reverse(line,rline)
	char *line,*rline;
{	char *p,*r;

	if( *line == 0 ){
		*rline = 0;
		return;
	}
	r = rline;
	for( p = line; *p; p++ )
		;
	if( line < p )
		p--;
	do *r++ = *p--; while( line <= p );
	*r = 0;
}

static struct {
	int	 d_lev;
	char	*d_name;
	char	*d_rev;
} domlev[] = {
	{3, "??.jp"	},
	{2, "ntt.jp"	},
	{2, "kek.jp"	},
	{2, "nttdata.jp"},
	{3, "city.*.jp"	},
	{3, "pref.*.jp"	},
	{4, "jp"	},
	{3, "ae"	},
	{3, "com.ar"	},
	{3, "edu.ar"	},
	{3, "net.ar"	},
	{3, "??.at"	},
	{3, "au"	},
	{3, "ba"	},
	{3, "??.be"	},
	{3, "bo"	},
	{3, "??.ca"	},
	{3, "co"	},
	{3, "cn"	},
	{3, "cr"	},
	{3, "gov.eg"	},
	{3, "net.gr"	},
	{3, "hk"	},
	{3, "id"	},
	{3, "il"	},
	{3, "??.in"	},
	{3, "net.in"	},
	{3, "ernet.in"	},
	{3, "kr"	},
	{3, "lb"	},
	{3, "ma"	},
	{3, "net.mt"	},
	{2, "jaring.my"	},
	{3, "my"	},

	{3, "com.mx"	},
	{3, "edu.mx"	},
	{3, "net.mx"	},

	{3, "com.ni"	},
	{3, "nz"	},
	{3, "com.pl"	},
	{3, "edu.pl"	},
	{3, "ph"	},

	{3, "net.ro"	},

	{3, "ac.ru"	},
	{3, "com.ru"	},
	{3, "edu.ru"	},
	{3, "net.ru"	},
	{3, "msk.ru"	},
	{3, "nsk.ru"	},
	{3, "spb.ru"	},
	{3, "tomsk.ru"	},

	{3, "sg"	},
	{3, "gov.sk"	},
	{3, "th"	},
	{3, "gov.tr"	},
	{3, "tt"	},
	{3, "tw"	},
	{3, "uk"	},
	{3, "com.ua"	},
	{3, "gov.ua"	},
	{3, "net.ua"	},
	{3, "kiev.ua"	},
	{3, "uzhgorod.ua"},
	{3, "??.us"	},
	{3, "uy"	},
	{3, "yu"	},
	{3, "za"	},
	{3, "com.br"	},
	0,
};

domain_level(rfqdn)
	char *rfqdn;
{	int hi,hc;
	char *qn,qc,sqc;
	char *dn,rdn[128];

	if( domlev[0].d_rev == NULL ){
		for( hi = 0; dn = domlev[hi].d_name; hi++ ){
			reverse(dn,rdn);
			domlev[hi].d_rev = strdup(rdn);
		}
	}
	for( hi = 0; dn = domlev[hi].d_rev; hi++ ){
		qn = rfqdn;
		for(;;){
			hc = *dn++;
			qc = *qn++;
			if( hc == '*' ){
				sqc = *dn; /* may be "." */
				while( qc != 0 && qc != sqc )
					qc = *qn++;
				if( qc == 0 )
					return domlev[hi].d_lev;
				dn++;
				continue;
			}
			if( hc == 0 && qc == '.' )
				return domlev[hi].d_lev;
			if( hc == '?' )
				continue;
			if( hc != qc )
				break;
		}
	}
	return 0;
}

generic_domain(hostaddr)
	char *hostaddr;
{	char rhostaddr[4096],*dp,dc;
	int lev,li;

	if( hostaddr[0] == 0 )
		return;

	reverse(hostaddr,rhostaddr);
	if( (lev = domain_level(rhostaddr)) == 0 )
		lev = 2;

	dp = rhostaddr;
	for( li = 0; li < lev; li++ ){
		for( dp++; dc = *dp; dp++ )
			if( dc == '.' )
				break;
		if( dc == 0 )
			return;
	}
	*dp = 0;
	reverse(rhostaddr,hostaddr);
}

/*
	 || strncmp(rhostaddr,"ee.",3) == 0
br??
*/

setBinaryIO(){ }
