/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	windows0.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970211	extracted from windows.c
//////////////////////////////////////////////////////////////////////#*/

#ifndef LE
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#ifdef _MSC_VER
#include <sys/stat.h> /* S_IREAD,S_IWRITE */
#endif
#include <fcntl.h>

#define LE 1?0:
#define LT 1?0:
#define LV 1?0:
#define LW 1?0:
#endif

#ifdef _MSC_VER
/* ######## PIPE ######## */
int pipe(sv)
	int sv[2];
{	int rcode;

	rcode = _pipe(sv,4096,O_BINARY);
	LW("pipe() = %d [%d,%d]",rcode,sv[0],sv[1]);
	return rcode;
}
FILE *popen(command,mode)
	char *command,*mode;
{
	LV("popen(%s,%s)",command,mode);
	return _popen(command,mode);
}
pclose(fp)
	FILE *fp;
{
	LV("pclose(%x)",fp);
	return _pclose(fp);
}
fcntl(fd){
	LE("fcntl(%d) NOT SUPPORTED",fd);
	return -1;
}
ftruncate(fd,size)
{	int rcode;

	rcode = chsize(fd,size);
	LV("ftruncate(%d,%d) = %d",fd,size,rcode);
	return rcode;
}
/* stat() of Windows95 does not recognize "/dir/" as "/dir" */
stat(path,stp)
	char *path;
	struct stat *stp;
{	int rcode;
	char pathb[1024];

	if( rcode = _stat(path,stp) )
	if( path[0] && path[1] && strtailchr(path) == '/' ){
		Strncpy(pathb,path,strlen(path));
		rcode = _stat(pathb,stp);
	}
	return rcode;
}
#endif

#ifdef _MSC_VER
#define O_TEMPBIN	(O_TEMPORARY|O_BINARY)
#define newtmp(path)	_open(path,O_CREAT|O_RDWR|O_TEMPBIN,S_IREAD|S_IWRITE)
#define ACT_UNLINKABLE	0
#define FOPEN_RWB	"w+b"
#define closetmpf1(fd)	(0 < _get_osfhandle(fd) ? _close(fd) : -1)
#define fdopen		_fdopen
#else
#ifdef __EMX__
#define newtmp(path)	open(path,O_CREAT|O_RDWR,0600)
#define ACT_UNLINKABLE	0
#define FOPEN_RWB	"w+b"
#define closetmpf1(fd)	close(fd)
FILE *tmpfile(void){ return TMPFILEX(tmpnam(NULL)); }
#else
#define newtmp(path)	open(path,O_CREAT|O_RDWR,0600)
#define ACT_UNLINKABLE	1
#define FOPEN_RWB	"w+"
#define closetmpf1(fd)	close(fd)
#endif
#endif

static char *tmpfiles[512];
static int tmpfilex;
extern int errno;

static deltmpfiles()
{	int ti;
	char *path;
	int rcode;
	int fd;

	for( fd = 3; fd < 256; fd++ )
		if( closetmpf1(fd) == 0 )
			LW("exit: close(%d) = 0",fd);

	for( ti = 0;  path = tmpfiles[ti]; ti++ ){
		errno = 0;
		rcode = unlink(path);
		LV("unlink(%s) = %d, errno=%d",path,rcode,errno);
	}
}

FILE *fopentmpfile(path,remove)
	char *path;
{	FILE *fp;
	int fd;

	if( ACT_UNLINKABLE ){
		if( fp = fopen(path,FOPEN_RWB) )
			if( remove )
				unlink(path);
	}else{
		fd = newtmp(path);
		if( 0 <= fd ){
			if( fp = fdopen(fd,FOPEN_RWB) ){
				tmpfiles[tmpfilex++] = strdup(path);
				LV("fopentmpfile(%s) %x/%d",path,fp,fileno(fp));
			}else	LE("cannot fdopen(%d) %s",fd,path);
		}else{
			LE("cannot open tmpfile(%s)",path);
			fp = NULL;
		}
	}
	return fp;
}
