/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1998 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	socks5.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
	UDP RELAY BY SOCKS V5

History:
	980211	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include "vsocket.h"

typedef struct sockaddr *SAP;
typedef struct sockaddr_in SIN;

static char *socks_host = NULL;
static int   socks_port = 1080;

typedef struct {
	int	s_ssock;	/* socket connected by TCP to sockd */
	SIN	s_rme;		/* remote UDP port on the sockd */
	int	s_msock;	/* local UDP socket for reception */
	SIN	s_me;		/* local UDP port */
} SocksServ;
static SocksServ socksServ[32];
static int socksServN;

#define ltob(l,b) {(b)[0]=l>>24;(b)[1]=l>>16;(b)[2]=l>>8;(b)[3]=l;}
#define stob(s,b) {(b)[0]=s>>8; (b)[1]=s;}

#define btol(b)   (((b)[0]<<24)|((b)[1]<<16)|((b)[2]<<8)|(b)[3])
#define btos(b)   (((b)[0]<<8) | (b)[1])

SOCKS_udpclose(msock)
{	int si,sj;

	for( si = 0; si < socksServN; si++ )
	if( socksServ[si].s_msock == msock ){
		for( sj = si; sj < socksServN; sj++ )
			socksServ[sj] = socksServ[sj+1];
		socksServN--;
		break;
	}
}

/*
 * declare the socket is a local UDP socket to be used for
 * UDP communication throught the socks server
 */
SOCKS_udpassoc(msock,me,rme)
	SIN *me,*rme;
{	int sock;
	unsigned char req[128],resp[128];
	int addr,port;
	int rcc,ri;
	int rcode;
	struct sockaddr_in sa;
	int si;
	SocksServ *ssp;

	if( socks_host == NULL ){
		syslog_ERROR("SOCKS_udpassoc: NO socks.\n");
		return -1;
	}
	for( si = 0; si < socksServN; si++ ){
		if( bcmp(&socksServ[si].s_me,me,sizeof(SIN)) == 0 ){
			syslog_DEBUG("SOCKS_udpassoc[%d]: already done.\n",si);
			goto EXIT;
		}
	}

	ssp = &socksServ[socksServN];
	ssp->s_msock = msock;
	ssp->s_me = *me;

	sock = socket(AF_INET,SOCK_STREAM,0);
	setCloseOnExec(sock);

	ssp->s_ssock = sock;
	sa.sin_family = AF_INET;
	sa.sin_addr.s_addr = inet_addrV4(socks_host);
	sa.sin_port = socks_port;
	syslog_DEBUG("SOCKS_connect [%x]%s:%d ...\n",
		sa.sin_addr.s_addr,socks_host,socks_port);
	rcode = connect(sock,(SAP)&sa,sizeof(sa));

	req[0] = 5; /* VERSION */
	req[1] = 1; /* leng */
	req[2] = 0; /* NO AUTH */
	send(sock,req,3,0);
	rcc = recv(sock,resp,2,0);
	if( rcc < 2 || resp[1] != 0 ){
		syslog_ERROR("SOCKS_udpassoc: AUTH error (%x)\n",resp[1]);
		close(sock);
		return -1;
	}

	addr = ntohl(me->sin_addr.s_addr);
	port = ntohs(me->sin_port);
	req[0] = 5; /* VERSION */
	req[1] = 3; /* CMD = UDP ASSOCIATE */
	req[2] = 0; /* reserved */
	req[3] = 1; /* ATYP = IP V4 address type */
	ltob(addr,&req[4]); /* DST.ADDR */
	stob(port,&req[8]); /* DST.PORT */
	send(sock,req,10,0);

	rcc = recv(sock,resp,sizeof(resp),0);
	if( rcc < 10 || resp[1] != 0 ){
		syslog_ERROR("SOCKS_udpassoc: UDP ASSOC error (%x)\n",resp[1]);
		close(sock);
		return -1;
	}

	addr = btol(&resp[4]);
	port = btos(&resp[8]);

	ssp->s_rme.sin_family = AF_INET;
	ssp->s_rme.sin_addr.s_addr = htonl(addr);
	ssp->s_rme.sin_port = htons(port);

	syslog_ERROR("SOCKS_udpassoc[%d]: OK (%x:%d/%x:%d)\n",
		socksServN,addr,port,me->sin_addr.s_addr,me->sin_port);
	socksServN++;

EXIT:
	if( rme ){
		*rme = *me;
		rme->sin_addr.s_addr = addr;
		rme->sin_port = port;
	}
	return 0;
}

SOCKS_Sendto(sock,msg,len,flags,to,tolen)
	char *msg;
	struct sockaddr_in *to;
{	char buf[8*1024];
	int addr,port,wcc;
	SIN me,rme;
	int si;

	for( si = 0; si < socksServN; si++ )
		if( socksServ[si].s_msock == sock ){
			rme = socksServ[si].s_rme;
			break;
		}
	if( socksServN <= si ){
		int len = sizeof(me);
		getsockname(sock,(SAP)&me,&len);
		if( SOCKS_udpassoc(sock,&me,&rme) < 0 )
			return -1;
	}

	addr = ntohl(to->sin_addr.s_addr);
	port = ntohs(to->sin_port);

	buf[0] = 0; /* reserved */
	buf[1] = 0; /* reserved */
	buf[2] = 0; /* FRAGment number */
	buf[3] = 1; /* ATYP = IP V4 address type */
	ltob(addr,&buf[4]); /* DST.ADDR */
	stob(port,&buf[8]); /* DST.PORT */
	bcopy(msg,buf+10,len);
	wcc = sendto(sock,buf,10+len,flags,(SAP)&rme,sizeof(SIN));

	syslog_DEBUG("SOCKS_sendto[%d](%x:%d/%x:%d) = %d\n",si,
		addr,port,rme.sin_addr.s_addr,rme.sin_port,wcc);

	return wcc - 10;
}
SOCKS_Recvfrom(sock,msg,len,flags,from,fromlen)
	unsigned char *msg;
	struct sockaddr_in *from;
	int *fromlen;
{	int addr,port,rcc;

	rcc = recvfrom(sock,msg,len,flags,(SAP)from,fromlen);
	if( rcc <= 0 )
		return rcc;
	if( msg[0] != 0 || msg[1] != 0 )
		return rcc;

	addr = btol(&msg[4]);
	port = btos(&msg[8]);

	syslog_DEBUG("SOCKS_recvfrom(%x:%d/%x:%d) = %d\n",
		addr,port,from->sin_addr.s_addr,from->sin_port,rcc);

	from->sin_addr.s_addr = htonl(addr);
	from->sin_port = htons(port);
	bcopy(10+msg,msg,rcc-10);
	return rcc - 10;
}


static int to_socksV[8];
static int to_socksN;
extern char *strdup();

SOCKS_addserv(dhost,dport,shost,sport)
	char *dhost;
	char *shost;
{	int daddr;

	socks_host = strdup(shost);
	socks_port = sport;
	if( strcmp(dhost,"*") == 0 )
		daddr = -1;
	else{
		daddr = inet_addrV4(dhost);
		if( daddr == -1 ){
			syslog_ERROR("SOCKS_addrserv(%s) host ERROR.\n",dhost);
			return; 
		}
	}

	to_socksV[to_socksN] = daddr = inet_addrV4(dhost);
	syslog_DEBUG("SOCKS_addrserv[%d](%x/%s:%d,%s:%d)\n",
		to_socksN,daddr,dhost,dport,shost,sport);
	to_socksN++;
}
static via_socks(dist)
	struct sockaddr_in *dist;
{	int ni;

	for( ni = 0; ni < to_socksN; ni++ ){
		if( to_socksV[ni] == -1 ) /* "host=*" */
			return 1;
		if( to_socksV[ni] == dist->sin_addr.s_addr )
			return 1;
	}
	return 0;
}
SOCKS_sendto(sock,buf,len,flags,to,tolen)
	char *buf;
	SAP to;
{
	if( socks_host && via_socks(to) )
		return SOCKS_Sendto(sock,buf,len,flags,to,tolen);
	else	return       sendto(sock,buf,len,flags,to,tolen);
}
SOCKS_recvfrom(sock,buf,len,flags,from,fromlen)
	char *buf;
	SAP from;
	int *fromlen;
{
	if( socks_host )
		return SOCKS_Recvfrom(sock,buf,len,flags,from,fromlen);
	else	return       recvfrom(sock,buf,len,flags,from,fromlen);
}


SOCKS_startV5(sock,command,host,port,user,rhost,rport)
	char *host,*user,*rhost;
	int *rport;
{	unsigned char qbuf[256],rbuf[256];
	int qcc,rcc,wcc;
	int addr;
	int ulen,plen;
	int nlen;
	char *pass;
	char *hp;

pass = NULL;
{extern int errno; errno = 0;}

	qbuf[0] = 5;
	qbuf[1] = 1;
	if( pass != NULL )
		qbuf[2] = 2; /* USERNAME/PASSWORD */
	else	qbuf[2] = 0; /* NO AUTH */

	wcc = send(sock,qbuf,3,0);
	rcc = recv(sock,rbuf,2,0);

	if( rcc < 2 || rbuf[1] != 0 ){
		syslog_ERROR("SOCKS_startV5: AUTH error (%x)\n",rbuf[1]);
		return -1;
	}

	if( pass != NULL ){
		ulen = strlen(user);
		plen = strlen(pass);
		qcc = 0;
		qbuf[qcc++] = 1;
		qbuf[qcc++] = ulen; strcpy(qbuf+qcc,user); qcc += ulen;
		qbuf[qcc++] = plen; strcpy(qbuf+qcc,pass); qcc += plen;
		send(sock,qbuf,qcc,0);
		rcc = recv(sock,rbuf,2,0);
		syslog_ERROR("SOCKS_startV5: %d VER[%d] STATUS[%d]\n",
			rcc,rbuf[0],rbuf[1]);
	}

	qcc = 0;
	qbuf[qcc++] = 5; /* VERSION */
	qbuf[qcc++] = command; /* CMD = CONNECT:1,BIND:2 */
	qbuf[qcc++] = 0; /* reserved */
	if( (addr = inet_addrV4(host)) != -1 ){
		qbuf[qcc++] = 1; /* ATYP = IP V4 address type */
		ltob(addr,&qbuf[qcc]); qcc += 4; /* DST.ADDR */
	}else{
		qbuf[qcc++] = 3; /* ATYP = host name */
		nlen = strlen(host);
		qbuf[qcc++] = nlen;
		strcpy(&qbuf[qcc],host);
		qcc += nlen;
	}
	stob(port,&qbuf[qcc]); qcc += 2; /* DST.PORT */
	wcc = send(sock,qbuf,qcc,0);
	return SOCKS_recvResponseV5(sock,command,rhost,rport);
}

SOCKS_recvResponseV5(sock,command,rhost,rport)
	char *rhost;
	int *rport;
{	int rcc;
	int addr,port;
	unsigned char rbuf[256];
	int ratyp;

	rcc = recv(sock,rbuf,sizeof(rbuf),0);
	if( rcc < 10 || rbuf[1] != 0 ){
		syslog_ERROR("SOCKS_respV5: cmd=%d error=%x rcc=%d\n",
			command,rbuf[1],rcc);
		return -1;
	}

	ratyp = rbuf[3];
	if( ratyp == 1 ){
		addr = btol(&rbuf[4]);
		port = btos(&rbuf[8]);
		if( rhost ) bcopy(&rbuf[4],rhost,4);
		if( rport ) *rport = port;
	}else{
		addr = -1;
		port = 0;
		if( rhost ) rhost[0] = rhost[1] = rhost[2] = rhost[3] = 0xFF;
		if( rport ) *rport = port;
	}

	syslog_ERROR("SOCKS_startV5: OK CMD=%d ATYP=%d %x:%d\n",
		command,ratyp,addr,port);
	return 0;
}
