/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1995 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	pstitle.c (process title for ps command)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	950328	created
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <string.h>

extern char *malloc();

int  PSTITLE_SIZE = 80;
char PSTITLE_PADD = ' ';

#ifdef hpux
#include <sys/pstat.h>
static p_init(path,ac,av)
	char *path;
	char *av[];
{
	return ac;
}
static p_title(buf,len)
	char *buf;
{
	pstat(PSTAT_SETCMD,buf,0,0,0);
}
#else
#if defined(__sony_news) && defined(_SYSTYPE_SYSV)
#include <sys/sysnews.h>
#include <sys/sysmips.h>
static p_init(path,ac,av)
	char *path;
	char *av[];
{
	return ac;
}
static p_title(buf,len)
	char *buf;
{
	sysmips(SONY_SYSNEWS,NEWS_SETPSARGS,buf);
}
#else

static char *title_area;
static int   title_size;
static char *ARGBUF;	/* saved arg[1..ac-1] */
static int   ARGLEN;	/* length of ARGBUF */

static p_init(path,ac,av)
	char *path;
	char *av[];
{	int pi,ai,diff;
	char padding[1024],*pp;
	char *nav[1024];

	title_area = av[0];
	pp = av[ac-1];
	title_size = &pp[strlen(pp)] - av[0];

	if( strncmp(pp,"--",2) == 0 ){
		if( 1 < ac ){
			ARGLEN = &pp[strlen(pp)] - av[1];
			ARGBUF = malloc(ARGLEN+1);
			bcopy(av[1],ARGBUF,ARGLEN+1);
			diff = ARGBUF - av[1];
			for( ai = 1; av[ai]; ai++ )
				av[ai] += diff;
		}else{
			ARGLEN = 0;
			ARGBUF = "";
		}
		return ac;
	}

	for( ai = 0; ai < ac; ai++ )
		nav[ai] = av[ai];
	nav[ac] = padding;
	nav[ac+1] = 0;

	strcpy(padding,"--");
	for( pi = 2; pi < PSTITLE_SIZE; pi++ )
		padding[pi] = PSTITLE_PADD;
	padding[pi] = 0;

	Execvp("PSTITLE",path,nav);
}
static p_title(buf,len)
	char *buf;
{	int ti,ai;

	if( title_area == NULL )
		return;

	if( title_size <= len )
		len = title_size - 1;

	/* copy new argv[0] */
	strncpy(title_area,buf,len);
	ti = len;
	title_area[ti++] = 0;

	/* shift buffer of argv[1-N] */
	for( ai = 0; ai < ARGLEN; ai++ ){
		if( title_size <= ti )
			break;
		title_area[ti++] = ARGBUF[ai];
	}
	if( title_size <= ti )
		title_area[title_size-1] = 0;
	else	title_area[ti++] = 0;

	for( ; ti < title_size; ti++ )
		title_area[ti] = ' ';
}
#endif
#endif

int PSTITLE_DISABLE;

proc_title_init(path,ac,av,fmt,a,b,c)
	char *path;
	char *av[];
{	int nac;

	PSTITLE_DISABLE++;

	if( !FS_maybeUnix() || IsBOW1_5() )
		return ac;

	nac = blockSEGVBUS(p_init,path,ac,av);
	if( 0 < nac ){
		PSTITLE_DISABLE--;
		ac = nac;
	}else	PSTITLE_DISABLE++;
	return ac;
}
proc_title(fmt,a,b,c,d,e,f,g)
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char buf[2048];
	int len;

	if( PSTITLE_DISABLE )
		return 0;

	sprintf(buf,fmt,a,b,c,d,e,f,g);
	len = strlen(buf);
	p_title(buf,len);
}
