/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1997 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	passwd.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	970514	extracted from misc.c
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <string.h>

#include <sys/types.h>
#include <sys/stat.h>
#ifdef S_ISUID /* set UID on execution */
#include <pwd.h>
#include <grp.h>
#else
struct passwd {
	int	 pw_uid;
	int	 pw_gid;
	char	*pw_name;
	char	*pw_dir;
};
static struct passwd passwd0 = { 0, 0, "?", "/" };
#define getpwuid(uid)	(&passwd0)
#define getpwnam(name)	(&passwd0)

struct group {
	int	 gr_gid;
	char	*gr_name;
};
static struct group group0 = { 0, "?" };
#define getgrgid(gid)	(&group0)
#define getgrnam(gid)	(&group0)
#endif

extern char *strdup();

usedFD(usedfd)
{	int fd;

	fd = dup(0);
	close(fd);
	if( fd != usedfd ){
		/*fprintf(stderr,"SETFD[%d]\n",usedfd);*/
		setCloseOnExec(usedfd);
	}
}
nextFD(){
	int fd;

	fd = dup(0);
	close(fd);
	return fd;
}


/* Solaris2.X leaves NIS+? relevant fd be opened after exec() */
struct passwd *GETpwuid(uid)
{	struct passwd *pw;
	int fd;

	fd = nextFD();
	pw = getpwuid(uid);
	usedFD(fd);
	return pw;
}
struct group *GETgrgid(gid)
{	struct group *gr;
	int fd;

	fd = nextFD();
	gr = getgrgid(gid);
	usedFD(fd);
	return gr;
}
struct passwd *GETpwnam(name) char *name;
{	struct passwd *pw;
	int fd;

	fd = nextFD();
	pw = getpwnam(name);
	usedFD(fd);
	return pw;
}
struct group *GETgrnam(group) char *group;
{	struct group *gr;
	int fd;

	fd = nextFD();
	gr = getgrnam(group);
	usedFD(fd);
	return gr;
}

char *getUsername(uid,name)
	char *name;
{	struct passwd *passwd;

	if( passwd = GETpwuid(uid) )
		strcpy(name,passwd->pw_name);
	else	sprintf(name,"#%d",uid);
	return name;
}

static int LastUid = -1;
static char LastUname[32];
char *getUsernameCached(uid,name)
	char *name;
{
	if( uid == LastUid && LastUname[0] != 0 )
		strcpy(name,LastUname);
	else{
		getUsername(uid,name);
		strcpy(LastUname,name);
		LastUid = uid;
	}
	return name;
}

getHOME(uid,home)
	char *home;
{	struct passwd *passwd;

	if( passwd = GETpwuid(uid) )
		strcpy(home,passwd->pw_dir);
	else	strcpy(home,"/");
}
char *getGroupname(gid,name)
	char *name;
{	struct group *group;

	if( group = GETgrgid(gid) )
		strcpy(name,group->gr_name);
	else	sprintf(name,"#%d",gid);
	return name;
}
char *getusernames(names)
	char *names;
{	char uname[32],euname[32];
	char gname[32],egname[32];

	uname[0] = euname[0] = 0;
	getUsername(getuid(),uname);
	getUsername(geteuid(),euname);

	gname[0] = egname[0] = 0;
	getGroupname(getgid(),gname);
	getGroupname(getegid(),egname);

	sprintf(names,"%s/%s(%s/%s)",uname,gname,euname,egname);
	return names;
}

/*
 *	user_group:	user / group ( euser / egroup )
 */
scan_guid(user_group,uidp,gidp)
	char *user_group;
	int *uidp,*gidp;
{	char *dp,user[256],group[256];
	struct passwd *pw;
	struct group *gr;
	int len;
	int uid,gid;

	if( dp = strchr(user_group,'/') ){
		if( len = dp - user_group ){
			strncpy(user,user_group,len);
			user[len] = 0;
		}else	getUsername(getuid(),user);
		strcpy(group,dp+1);
	}else{
		strcpy(user,user_group);
		group[0] = 0;
	}

	uid = gid = -1;

	if( *user == '#' ){
		uid = atoi(user+1) & 0xFFFF;
		if( pw = GETpwuid(uid) )
			gid = pw->pw_gid;
	}else
	if( pw = GETpwnam(user) ){
		uid = pw->pw_uid;
		gid = pw->pw_gid;
	}else	return -1;

	if( *group == '#' )
		gid = atoi(group+1);
	else
	if( gr = GETgrnam(group) )
		gid = gr->gr_gid;

	if( uidp ) *uidp = uid;
	if( gidp ) *gidp = gid;
	return 0;
}
