/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1998 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1998 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	nbio.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	980804	extracted from inets.c
//////////////////////////////////////////////////////////////////////#*/

#include <errno.h>
#include <stdio.h>
#include "vsocket.h"
typedef struct sockaddr *SAP;

isconnected(sock){
	int len;
	struct sockaddr_in sin;

	len = sizeof(sin);
	if( getpeername(sock,(SAP)&sin,&len) == 0 )
	if( len == sizeof(sin) )
	if( sin.sin_port != 0 )
		return 1;
	return 0;
}

connectTO(sock,addr,leng,timeout)
	SAP addr;
{	int NB;
	int rcode;
	int nready;

	if( timeout == 0 )
		return connect(sock,addr,leng);

	NB = getNonblockingIO(sock);
	if( !NB ) rcode = setNonblockingIO(sock,1);

	rcode = connect(sock,addr,leng);

	if( rcode == 0 ){
		if( !NB ) setNonblockingIO(sock,0);
		return 0;
	}
	nready = PollOut(sock,timeout);
	if( !NB ) setNonblockingIO(sock,0);

	if( nready <= 0 ){
		syslog_ERROR("## connect[%d] TIMEOUT(%d)\n",sock,timeout);
		return -1;
	}

	if( !isconnected(sock) ){
		syslog_ERROR("## connect[%d] failure (%d)\n",sock,errno);
		return -1;
	}

	return 0;
}
