/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	html.c (HTML entity encoder/decoder)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	941002	extracted from http.c
//////////////////////////////////////////////////////////////////////#*/
#include <string.h>

int DECODE_HTML_ENTITIES = 1;
int ENCODE_HTML_ENTITIES = 0;
int PLAIN_TO_HTML_PRE = 0;
int FULL_URL = 0;

static hconv1(conv)
	char *conv;
{
	if( streq(conv,"enent") )  ENCODE_HTML_ENTITIES = 1; else
	if( streq(conv,"deent") )  DECODE_HTML_ENTITIES = 1; else
	if( streq(conv,"pre")   )  PLAIN_TO_HTML_PRE    = 1; else
	if( streq(conv,"fullurl")) FULL_URL = 1; else
	syslog_ERROR("Error: unknown HTML conversion spec: %s\n",conv);
	return 0;
}
scan_HTMLCONV(clist)
	char *clist;
{
	ENCODE_HTML_ENTITIES = 0;
	DECODE_HTML_ENTITIES = 0;
	scan_commaList(clist,0,hconv1);
	syslog_DEBUG("HTMLCONV=%s -> en=%d,de=%d\n",
		clist,ENCODE_HTML_ENTITIES,DECODE_HTML_ENTITIES);
}

static struct {
	char	*ee;
	char	 de;
} entities[] = {
	{"&lt;",	'<'},
	{"&gt;",	'>'},
	{"&amp;",	'&'},
	{"&quot;",	'"'},
	0
};

isHTMLentity(str,chp)
	char *str;
	int *chp;
{	int ei,ej;
	char *es,ec,*sp;
	int off;

	off = *str == '&' ? 0 : 1;
	for( ei = 0; es = entities[ei].ee; ei++ ){
		for( ej = 0; ec = es[off+ej]; ej++ ){
			if( ec != str[ej] )
				break;
			if( ec == ';' ){
				*chp = entities[ei].de;
				return ej+1;
			}
		}
	}
	return 0;
}

/*
 *  Decode mal-encoded entities in ISO-2022 multibyte charset text.
 */
decode_entities(src,dst)
	char *src,*dst;
{
	if( DECODE_HTML_ENTITIES == 0 ){
		strcpy(dst,src);
		return;
	}
	decodeEntities(src,dst,0);
}
decodeEntities(src,dst,anywhere)
	char *src,*dst;
{	char *sp,*dp;
	int ei,len;
	char *ee;
	int in2byte;

	in2byte = 0;
	dp = dst;
	for( sp = src; *sp; )
	{
		if( *sp == 033 ){
			switch( sp[1] ){
				case '$': in2byte  = 1; break;
				case '(': in2byte  = 0; break;
			}
		}else
		if( (anywhere||in2byte) && *sp == '&' ){
			for( ei = 0; ee = entities[ei].ee; ei++ ){
				len = strlen(ee);
				if( strncmp(sp,ee,len) == 0 ){
					*dp++ = entities[ei].de;
					sp += len;
					goto Next;
				}
			}
		}
		*dp++ = *sp++;
	Next:;
	}
	*dp = 0;
}

encode_entities(src,dst)
	char *src,*dst;
{
	if( ENCODE_HTML_ENTITIES == 0 ){
		strcpy(dst,src);
		return;
	}
	encodeEntities(src,dst);
}
encodeEntities(src,dst)
	char *src,*dst;
{	int in2byte;
	char *sp,*dp;
	char de;
	int ei,len;

	in2byte = 0;
	dp = dst;
	for( sp = src; *sp; sp++ ){
		if( *sp == 033 ){
			switch( sp[1] ){
				case '$': in2byte  = 1; break;
				case '(': in2byte  = 0; break;
			}
		}else
		if( !in2byte ){
			for( ei = 0; de = entities[ei].de; ei++ ){
				if( *sp == de ){
					strcpy(dp,entities[ei].ee);
					dp += strlen(dp);
					goto Next;
				}
			}
		}
		*dp++ = *sp;
	Next:;
	}
	*dp = 0;
}

char *strpbrk1B(src,brks,dst)
	char *src,*brks,**dst;
{	char *sp,sch,*dp,swch,bch;
	int si,bi;
	int in2byte = 0;
	int found = 0;

	dp = *dst;
	for( sp = src; sch = *sp; ){
		if( sch == 033 ){
			swch = sp[1];
			if( (swch == '$' || swch == '(') && sp[2] != 0 ){
				for( si = 0; si < 3; si++ )
					*dp++ = *sp++;
				if( swch == '$' ) in2byte = 1; else
				if( swch == '(' ) in2byte = 0;
				continue;
			}
		}
		if( !in2byte ){
			for( bi = 0; bch = brks[bi]; bi++ )
				if( sch == bch ){
					found = 1;
					goto FOUND;
				}
		}
		*dp++ = sch;
		sp++;
	}
FOUND:
	*dp = 0;
	*dst = dp;

	if( found )
		return sp;
	else	return 0;
}

scan_html(src,dst,stack)
	char *src,*dst,*stack;
{
}
