/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	file.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	951029	extracted from DelaGate
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
extern FILE *tmpfile();
#include <string.h>
extern char *strdup();
#include <ctype.h>
extern int errno;

#ifdef S_ISUID /* set UID on execution */
#define IS_UNIX_FS
FS_maybeUnix(){ return 1; }
FS_withSetuid(){ return 1; }
#else
FS_maybeUnix(){ return 0; }
FS_withSetuid(){ return 0; }
#endif

#ifdef S_IFLNK
FS_withSymlink(){ return 1; }
#else
FS_withSymlink(){ return 0; }
#endif

#ifndef S_ISREG
#define S_ISREG(m)  (((m)&S_IFMT) == S_IFREG)
#endif

#ifndef S_ISDIR
#define S_ISDIR(m)  (((m)&S_IFMT) == S_IFDIR)
#endif

int File_is(path)
	char *path;
{	struct stat st;

	if( stat(path,&st) == 0 )
		return 1;
	else	return 0;
}
int File_isreg(path)
	char *path;
{	struct stat st;

	if( stat(path,&st) == 0 )
		return S_ISREG(st.st_mode);
	else	return 0;
}
int File_mtime(path)
	char *path;
{	struct stat st;

	if( stat(path,&st) == 0 )
		return st.st_mtime;
	else	return -1;
}
int File_size(path)
	char *path;
{	struct stat st;

	if( stat(path,&st) == 0 )
		return st.st_size;
	else	return -1;
}
int File_ino(path)
	char *path;
{	struct stat st;

	if( stat(path,&st) == 0 )
		return st.st_ino;
	else	return 0;
}
File_cmp(path1,path2)
	char *path1,*path2;
{	struct stat st1,st2;
	static struct stat st0;

	st1 = st0;
	st2 = st0;
	if( stat(path1,&st1) != 0 ) return -1;
	if( stat(path2,&st2) != 0 ) return -1;

/* st_dev will differ from each other for NFS files mounted by
 * different host name (even when they are same in IP address)
 * (/net/host/path != /net/alias/path)
 */
	if( st1.st_dev == st2.st_dev &&
	    st1.st_ino == st2.st_ino )
		return 0;
	else	return 1;
/*
return bcmp(&st1,&st2,sizeof(struct stat));
*/
}

fcompare(fp1,fp2)
	FILE *fp1,*fp2;
{	char buf1[1024],buf2[1024];
	int off1,off2;
	int rc1,rc2,ri;
	int diff;

	off1 = ftell(fp1);
	off2 = ftell(fp2);
	diff = 0;
	for(;;){
		rc1 = fread(buf1,1,1024,fp1);
		rc2 = fread(buf2,1,1024,fp2);
		if( rc1 != rc2 ){
			diff = 1;
			break;
		}
		if( rc1 == 0 )
			break;
		for( ri = 0; ri < rc1; ri++ )
			if( buf1[ri] != buf2[ri] ){
				diff = 1;
				break;
			}
	}
	fseek(fp1,off1,0);
	fseek(fp2,off2,0);
	return diff;
}

Ftruncate(fp,offset,whence)
	FILE *fp;
{	long savoff;
	int rcode;

	savoff = ftell(fp);
	fseek(fp,offset,whence);
	rcode = ftruncate(fileno(fp),(off_t)ftell(fp));
	fseek(fp,savoff,0);
	return rcode;
}

extern char *getcwd();
static char *_pathsep;
static char *_PATHSEP(){
	char cwd[1024];
	if( _pathsep == NULL ){
		getcwd(cwd,sizeof(cwd));
		if( strchr(cwd,'\\') )
			_pathsep = "\\";
		else	_pathsep = "/";
	}
	return _pathsep;
}

FullpathOfExe(path)
	char *path;
{	char xpath[1024];

	if( isFullpath(path) )
		return 1;

	if( getcwd(xpath,sizeof(xpath)) == NULL )
		return 0;

	strcat(xpath,_PATHSEP());
	strcat(xpath,path);

	if( File_mtime(xpath) != -1 ){
		strcpy(path,xpath);
		return 1;
	}

	/* should scan getenv("PATHEXT") ... */
	strcat(xpath,".exe");
	if( File_mtime(xpath) != -1 ){
		strcpy(path,xpath);
		return 1;
	}
	return 0;
}

static int colonForDrive;
ColonForDrive()
{	FILE *fp;
	char path[1024];

	if( colonForDrive == 0 ){
		/* cannot use ':' in a file name if on Windows */

		getcwd(path,sizeof(path));
		if( isalpha(path[0]) && path[1] == ':' )
			colonForDrive =  1;
		else{
			sprintf(path,"/tmp/%d:%d",time(0),getpid());
			if( fp = fopen(path,"w") ){
				fclose(fp);
				unlink(path);
				colonForDrive = -1;
			}else	colonForDrive =  1;
		}
	}
	return 0 < colonForDrive;
}

char *fullPath(path,buff)
	char *path,*buff;
{
#ifndef IS_UNIX_FS
	/*
	 * //X/path -- OpenNT -- X:/path
	 */ 
	if( path[0] == '/' && path[1] == '/'
	 && 'A' <= path[2] && path[2] <= 'Z'
	 && path[3] == '/' )
	{
		buff[0] = path[2];
		buff[1] = ':';
		strcpy(&buff[2],&path[3]);
		path = buff;
	}
#endif
	return path;
}
isFullpath(path)
	char *path;
{
	if( *_PATHSEP() == '\\' ){
		if( isalpha(path[0]) && path[1] == ':' ){
			if( path[2] == '\\' || path[2] == '/' )
				return 3;
			else	return 2;
		}
		if( path[0] == '\\' )
			return 1;
	}
	if( path[0] == '/' )
		return 1;
	return 0;
}
isBoundpath(path)
	char *path;
{
	if( isFullpath(path) )
		return 1;
	if( path[0] == '.' ){
		if( path[1] == 0 )
			return 1;
		if( path[1] == *_PATHSEP() )
			return 1;
		if( path[1] == '/' )
			return 1;
	}
	return 0;
}
chdir_cwd(cwd, go, userdir)
	char *cwd,*go;
{	char *tp,*cp;
	int uplen,len;

	for( tp = cwd; *tp; tp++ ){}
	if( len = isFullpath(go) ){
		tp = cwd;
		while( 0 < len-- )
			*tp++ = *go++;
	}else
	if( userdir && go[0] == '~' ){
		if( go[1] == 0   ){ tp = cwd; go += 1; }else
		if( go[1] == '/' ){ tp = cwd; go += 2; }
	}

	while( *go ){
		uplen = 0;
		if( go[0] == '.' ){
			if( go[1] == 0   ){ go += 1; break; }
			if( go[1] == '/' ){ go += 2; continue; }
			if( go[1] == '.' ){
				if( go[2] == 0   ){ uplen = 2; } else
				if( go[2] == '/' ){ uplen = 3; }
			}
		}
		if( uplen ){
			if( cwd < tp ){
				while( cwd+1 < tp ){
					if( tp[-1] == '/' )
						tp--;
					else	break;
				}
				*tp = 0;
				if( cp = strrchr(cwd,'/') ){
					if( cp == cwd  )
						tp = cp + 1;
					else	tp = cp;
				}else	tp = cwd;
			}
			go += uplen;
		}else{
			if( cp = strchr(go,'/') )
				len = (cp - go) + 1;
			else	len = strlen(go);

			if( cwd < tp && tp[-1] != '/' )
				*tp++ = '/';
			strncpy(tp,go,len);
			tp += len;
			go += len;
		}
	}
	while( cwd+1 < tp ){
		if( tp[-1] == '/' )
			tp--;
		else	break;
	}
	*tp = 0;
}

static int _TMPSEQ;
static int _TMPDIR_set;
#ifdef IS_UNIX_FS
static char *_TMPDIR;
#else
static char *_TMPDIR = "\\tmp";
#endif

char *getTMPDIR(){ return _TMPDIR; }

setTMPDIR(dir)
	char *dir;
{	char buff[1024];

	if( dir ){
		if( _TMPDIR && _TMPDIR_set )
			free(_TMPDIR);
		_TMPDIR = strdup(fullPath(dir,buff));
		_TMPDIR_set = 1;
	}
}

FILE *TMPFILEX(path)
	char *path;
{	char *tmpdir,pathb[1024],buff[1024];
	FILE *fp;
	extern char *getenv();
	extern FILE *fopentmpfile();

	tmpdir = _TMPDIR;
	if( tmpdir == NULL ){
		if( path == NULL )
			return NULL;
		if( (tmpdir = getenv("TMPDIR")) == NULL )
			tmpdir = "/tmp";
	}
	if( !fileIsdir(tmpdir) )
		mkdir(tmpdir,0777);

	if( path == NULL )
		path = pathb;
	sprintf(path,"%s/dg%d.%d.%d",tmpdir,getpid(),++_TMPSEQ,time(0));

	errno = 0;
	fp = fopentmpfile(fullPath(path,buff),path==pathb);

	if( fp != NULL )
		syslog_DEBUG("TMPFILE = (%d) %s\n",fileno(fp),path);
	else	syslog_ERROR("TMPFILE: cannot create (%d) = %s\n",errno,path);
	return fp;
}

FILE *TMPFILE(what)
	char *what;
{	FILE *fp;
	int besilent;
	char *tmpdir;

	fp = TMPFILEX(NULL);
	if( fp == NULL )
		fp = tmpfile();

	besilent = what[0] == '-';

	if( fp != NULL ){
		setCloseOnExec(fileno(fp));
		if( !besilent )
		syslog_DEBUG(">>>>TMPFILE(%s)>>>>%x[%d]\n",what,fp,fileno(fp));
	}else{
		tmpdir = _TMPDIR;
		if( tmpdir == NULL )
			tmpdir = "(system default, may be /tmp or /usr/tmp)";
		syslog_ERROR(">>>>TMPFILE(%s)>>>> cannot create.\n",what);
		syslog_ERROR(">>>> You MUST have the WRITE permission to\n");
		syslog_ERROR(">>>> the TMPDIR=%s\n",tmpdir);
		exit(0);
	}
	return fp;
}

static int tmpfiles[1] = {-1};
static int tmpfilepids[1];
FILE *reusableTMPFILE(what,where)
	char *what;
	int (*where)();
{	FILE *tmp;
	int tx,fd,pid;

	tx = 0;
	fd = tmpfiles[tx];
	pid = getpid();

	if( 0 <= fd && tmpfilepids[0] == pid ){
		lseek(fd,0,0);
		tmp = fdopen(dup(fd),"w+");
		Ftruncate(tmp,0,0);
		syslog_DEBUG(">>>>TMPFILE(%s) reused [%d]->[%d]\n",what,
			fd,fileno(tmp));
	}else{
		tmp = TMPFILE(what);
		tmpfiles[tx] = dup(fileno(tmp));
		tmpfilepids[tx] = pid;
	}
	return tmp;
}


FILE *Tmpfile()
{
	return TMPFILE("Tmpfile");
}

#ifdef NULLFP
#undef NULLFP /* defined in <sys/file.h> of Solaris */
#endif

FILE *NULLFP(){
	static FILE *NULLFP;
	FILE *tmp;

	if( NULLFP == NULL ){
		tmp = TMPFILE("NULLFP");
		/*close(fileno(NULLFP)); should hold to avoid reuse */
		NULLFP = fdopen(fileno(tmp),"r");
	}
	return NULLFP;
}

copyfile2(sfp,dfp,doflush)
	FILE *sfp,*dfp;
{	char buff[8*1024];
	int totalc,rcc;

	totalc = 0;
	for(;;){
		rcc = fread(buff,1,sizeof(buff),sfp);
		if( rcc == 0 )
			break;
		totalc += rcc;
		if( fwrite(buff,1,rcc,dfp) == 0 )
			break;
	}
	if( doflush )
		fflush(dfp);
	return totalc;
}

copyfile1(sfp,dfp)
	FILE *sfp,*dfp;
{
	return copyfile2(sfp,dfp,1);
}


extern char *malloc();
extern char *realloc();

char *Malloc(ptr,size)
	char *ptr;
{	char *nptr;

	if( ptr == NULL )
		nptr = malloc(size);
	else	nptr = realloc(ptr,size);
	if( nptr == NULL ){
		fprintf(stderr,"[%d] DeleGate: Malloc() failed\n",getpid());
		exit(1);
	}
	return nptr;
}

path_escchar(path)
	char *path;
{	char sc,*sp,*dp;
	char *buff;

	if( !ColonForDrive() )
		return;

	if( isalpha(path[0]) && path[1] == ':' )
		path += 2;

	if( strpbrk(path,":") == NULL && strstr(path+2,"./") == NULL )
		return;

	buff = strdup(path);
	dp = path;
	for( sp = buff; sc = *sp; sp++ ){
		if( sc == '.' && sp[1] == '/' ){
			*dp++ = '%';
			*dp++ = '2';
			*dp++ = 'E';
		}else
		if( sc == ':' ){
			if( sp[1] == '/' ){
				*dp++ = '%';
				*dp++ = '3';
				*dp++ = 'A';
			}else{
				*dp++ = '.';
				*dp++ = '.';
			}
		}else	*dp++ = sc;
	}
	*dp = 0;
	free(buff);
}

int file_isreg(fd)
{	struct stat status;

	if( fstat(fd,&status) == 0 )
		return S_ISREG(status.st_mode);
	return 0;
}
int file_isregular(fd)
{	struct stat st;

	if( fstat(fd,&st) == 0 )
		return S_ISREG(st.st_mode) || S_ISDIR(st.st_mode);
	else	return 0;
}
int file_isdir(fd)
{	struct stat stat;

	if( fstat(fd,&stat) == 0 )
		return S_ISDIR(stat.st_mode);
	return 0;
}
int fileIsdir(path)
	char *path;
{	struct stat status;

	if( stat(path,&status) == 0 )
		return S_ISDIR(status.st_mode);
	return 0;
}
int fileIsflat(path)
	char *path;
{	struct stat status;

	if( stat(path,&status) == 0 )
		return S_ISDIR(status.st_mode) == 0;
	return 0;
}

char *freadfile(fp,sizep)
	FILE *fp;
	int *sizep;
{	FILE *tmp;
	char *data;
	int size,rcc;

	if( size = *sizep ){
		data = malloc(size+1);
		rcc = fread(data,1,size,fp);
	}else{
		tmp = TMPFILE("freadfile");
		size = copyfile1(fp,tmp);
		fflush(tmp);
		fseek(tmp,0,0);
		data = malloc(size+1);
		rcc = fread(data,1,size,tmp);
		fclose(tmp);
	}
	data[rcc] = 0;
	*sizep = rcc;
	return data;
}

/*
 *	getcwd() on SunOS is slow and with side efect of popen()
 *	getwd() on FreeBSD destroy buffer smaller than MAXPATHLEN
 */
char *Getwd(dir)
	char *dir;
{	char dirbuf[2048];

	getwd(dirbuf);
	strcpy(dir,dirbuf);
	return dir;
}
