/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1996 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	fcntl.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	961231	extracted from file.c
//////////////////////////////////////////////////////////////////////#*/

#include <fcntl.h>

#if !defined(O_NDELAY) && defined(FNDELAY)
#define O_NDELAY FNDELAY
#endif

#if !defined(O_NDELAY) && defined(O_NONBLOCK)
#define O_NDELAY O_NONBLOCK
#endif

#if !defined(O_NDELAY)
#define O_NDELAY -1
#endif

#if !defined(F_SETFD)
#define F_SETFD  -1
#define F_SETFL  -1
#define F_GETFL  -1
#endif

setNonblockingIO(fd,on)
{	int flags;

	if( F_SETFL == -1 || O_NDELAY == -1 ){
		syslog_ERROR("Non-Blocking I/O not supported\n");
		return -1;
	}

	flags = fcntl(fd,F_GETFL,0);
	if( on )
		flags |=  O_NDELAY;
	else	flags &= ~O_NDELAY;
	return fcntl(fd,F_SETFL,flags);
}
getNonblockingIO(fd)
{
	if( F_GETFL == -1 || O_NDELAY == -1 )
		return -1;

	return (fcntl(fd,F_GETFL,0) & O_NDELAY) != 0;
}
setCloseOnExec(fd)
{
	if( F_SETFD == -1 ){
		syslog_DEBUG("Close-On-Exec not supported\n");
		return -1;
	}

	return fcntl(fd,F_SETFD,1);
}
