/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL), AIST, MITI

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	strings.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	940821	extracted from DeleGate/src/misc.c
//////////////////////////////////////////////////////////////////////#*/
#include <ctype.h>
#include <string.h>
extern char *strstr();
extern char *malloc();

isdigits(str)
	char *str;
{	char *sp,ch;

	if( *str == 0 )
		return 0;

	for( sp = str; ch = *sp; sp++ )
		if( !isdigit(ch) )
			return 0;
	return 1;
}
isdigit2(str)
	char *str;
{
	return isdigit(str[0]) && isdigit(str[1]);
}
Isalnum(ch)
{
	return isalnum(ch);
}
char *Isnumber(str)
	char *str;
{
	if( (*str == '-' || *str == '+') && isdigit(str[1]) )
		str++;

	if( isdigit(*str) ){
		while( isdigit(*str) )
			str++;
		return str;
	}
	return 0;
}

int strcaseeq(a,b)
	char *a,*b;
{
	if( a == b )
		return 1;
	if( toupper(*a) != toupper(*b) )
		return 0;
	return strcasecmp(a,b) == 0;
}

char *
strcasestr(s1,s2)
	char *s1,*s2;
{	char *p1;
	int len;

	if( *s2 == 0 )
		return s1;

	len = strlen(s2);
	for( p1 = s1; *p1; p1 ++ )
		if( toupper(*p1) == toupper(*s2) )
		if( strncasecmp(p1,s2,len)==0 ) 
			return p1;
	return 0;
}
char *strtoupper(s1,s2)
	char *s1,*s2;
{
	while( *s2++ = islower(*s1) ? toupper(*s1++) : *s1++ )
		;
	return s2;
}
char *strtolower(s1,s2)
	char *s1,*s2;
{
	while( *s2++ = isupper(*s1) ? tolower(*s1++) : *s1++ )
		;
	return s2;
}

int rexpmatch(rexp,str)
	char *rexp,*str;
{	int topx;
	char *sp,sc,*tp,tc,*rp,rc;

	if( *rexp == '*' ){
		if( rexp[1] == 0 ) /* any string */
			return 1;
		rexp++;
		topx = 1;
	}else	topx = 0;

	sp = str;
	for(;;){
		tp = sp++; sc = *tp++;
		rp = rexp; rc = *rp++;
		while( sc == rc ){
			if( rc == 0 ) /* exactly matched to the end */
				return 1;
			sc = *tp++;
			rc = *rp++;
		}
		if( rc == '*' ) /* remaining string matches with *  */
			return 1;
		if( sc == 0 ) /* pattern is longer than string */
			return 0;
		if( !topx )
			break;
	}
	return 0;
}

RexpMatch(str,rexp)
	unsigned char *str,*rexp;
{	unsigned char *rp,*sp,rch1,rch2,sch;
	int negate,match;

	sp = str;
	match = 1;
	for( rp = rexp; match && (rch1 = *rp); rp++ ){
		sch = *sp++;
		if( rch1 == '[' ){
			rch1 = *++rp;
			if( rch1 == '^' ){
				rp++;
				negate = 1;
				match = 1;
			}else{
				negate = 0;
				match = 0;
			}
			for(; rch1 = *rp; rp++ ){
				if( negate && match || !negate && !match ){
					if( rp[1] == '-' && rp[2] != 0 ){
						rp += 2;
						rch2 = *rp;
					}else	rch2 = rch1;
					match = (rch1 <= sch && sch <= rch2);
					if( negate )
						match = !match;
				}
				if( rch1 == ']' )
					break;
			}
		}else{
			match = (rch1 == sch);
		}
	}
	return match;
}


int vtos(av,abuf)
	char *av[];
	char *abuf;
{	int ac;
	char *ap,*a1;

	ap = abuf;
	for(ac = 0; a1 = av[ac]; ac++){
		if( ac == 0 )
			strcpy(ap,a1);
		else{
			ap[0] = ',';
			strcpy(ap+1,a1);
		}
		ap += strlen(ap);
	}
	*ap = 0;
	return ac;
}
int stoV(abuf,mac,av,sep)
	char *abuf;
	char *av[],sep;
{	char *ap,*np;
	int ac;

	ac = 0;
	for( ap = abuf; *ap; ap = np+1 ){
		av[ac++] = ap;
		if( mac <= ac )
			break;
		if( (np = strchr(ap,sep)) == 0 )
			break;
		*np = 0;
	}
	av[ac] = 0;
	return ac;
}
char **dupv(sv,length)
	char **sv;
{	int na,ai;
	char **dv;
	int len,lx;

	for( na = 0; sv[na]; na++)
		;
	dv = (char**)malloc(sizeof(char*)*(na+1));

	for( ai = 0; ai < na; ai++ ){
		if( length )
			len = length;
		else	len = strlen(sv[ai]) + 1;
		dv[ai] = malloc(len);
		for( lx = 0; lx < len; lx++ ) dv[ai][lx] = sv[ai][lx];
	}
	dv[ai] = 0;
	return dv;
}
void freev(sv)
	char *sv[];
{	int vx;

	for( vx = 0; sv[vx]; vx++ )
		free(sv[vx]);
	free(sv);
}
int cmpv(v1,v2,len)
	char *v1[],*v2[];
{	int vx;
	char *v1s,*v2s;

	for( vx = 0; ; vx++ ){
		v1s = v1[vx];
		v2s = v2[vx];

		if( v1s == 0 && v2s == 0 ) return 0;
		if( v1s == 0 || v2s == 0 ) return 1;
		if( len ){
			if( bcmp(v1s,v2s,len) != 0 )
				return 1;
		}else{
			if( strcmp(v1s,v2s) != 0 )
				return 1;
		}
	}
}
char *getv(av,name)
	char *av[];
	char *name;
{	char *val,*rval;
	int ai;
	int nlen;

	if( av == 0 || name == 0 )
		return 0;

	nlen = strlen(name);
	rval = 0;
	for(ai = 0; val = av[ai]; ai++)
		if( *name == *val && strncmp(name,val,nlen) == 0 )
		if( val[nlen] == '=' )
			rval = val+nlen+1;
	return rval;
}
scanv(av,name,func,arg1)
	char *av[];
	char *name;
	int (*func)();
	char *arg1;
{	int ai;
	int nlen;
	char *val;
	int nhit;

	nhit = 0;
	nlen = strlen(name);
	for( ai = 0; val = av[ai]; ai++ ){
		if( *name == *val && strncmp(name,val,nlen) == 0 )
		if( val[nlen] == '=' ){
			(*func)(arg1,val+nlen+1);
			nhit++;
		}
	}
	return nhit;
}

char *stralloc(str)
	char *str;
{
	return strcpy(malloc(strlen(str)+1),str);
}
char *Strdup(dst,src)
	char **dst,*src;
{
	if( *dst == src )
		return *dst;
	if( *dst != (char*)0 )
		free(*dst);
	return *dst = stralloc(src);
}
char *strncpy0(d,s,len)
	char *d,*s;
{
	strncpy(d,s,len);
	d[len] = 0;
	return d;
}
strtailchr(str)
	char *str;
{
	if( *str == 0 )
		return 0;
	else	return str[strlen(str)-1];
}

char *strtailstr(str1,str2)
	char *str1,*str2;
{	char *s1,*s2;

	for( s1 = str1; *s1 && s1[1]; s1++ );
	for( s2 = str2; *s2 && s2[1]; s2++ );

	if( *s2 == 0 ){
		if( *s1 == 0 )
			return s1;
		else	return s1 + 1;
	}

	for(;;){
		if( *s1 != *s2  ) return 0;
		if( s2 == str2 )
			return s1;
		if( --s1 < str1 ) return 0;
		if( --s2 < str2 ) return 0;
	}
}

char *awordscan(str,word)
	char *str,*word;
{	char *sp,*wp,ch;

	wp = word;
	for(sp = str; ch = *sp; sp++){
		if( !isalpha(ch) )
			break;
		*wp++ = ch;
	}
	*wp = 0;
	return sp;
}
char *anwordscan(str,word)
	char *str,*word;
{	char *sp,*wp,ch;

	wp = word;
	for(sp = str; ch = *sp; sp++){
		if( !isalnum(ch) )
			break;
		*wp++ = ch;
	}
	*wp = 0;
	return sp;
}

char *scanint(str,valp)
	char *str;
	int *valp;
{	char *sp,ch,*vp,valb[256];

	vp = valb;
	for( sp = str; ch = *sp; sp++ ){
		if( !isdigit(ch) )
			break;
		*vp++ = ch;
	}
	*vp = 0;
	if( vp == valb )
		return 0;

	*valp = atoi(valb);
	return sp;
}
char *wordscan2(s,d,size)
	char *s,*d;
{	int cc,ch;

	for(; ch = *s; s++){
		if( ch!=' ' && ch!='\t' && ch!='\r' && ch!='\n' && ch!='\f' )
			break;
	}
	for(cc = 1; (size == 0 || cc < size) && (ch = *s); cc++,s++){
		if( ch==' ' || ch=='\t' || ch=='\r' || ch=='\n' || ch=='\f' )
			break;
		*d++ = ch;
	} 
	*d = 0;
	return s;
}
char *wordscan(s,d)
	char *s,*d;
{
	return wordscan2(s,d,0);
}
char *linescan(s,d,size)
	char *s,*d;
{	int cc,ch;

	for(; ch = *s; s++){
		/* if( ch!=' ' && ch!='\t' && ch!='\r' && ch!='\n' && ch!='\f' ) */
		if( ch!=' ' && ch!='\t' )
			break;
	}
	for(cc = 1; (cc < size) && (ch = *s); cc++,s++){
		if( ch=='\n' || ch=='\r' && (s[1]=='\n' || s[1]==0) )
			break;
		*d++ = ch;
	} 
	*d = 0;
	return s;
}
scanwords(sp,wc,words)
	char *sp;
	char *words[];
{	int ch,wi;

	for( wi = 0; wi < wc; wi++ ){
		for(; ch = *sp; sp++ )
			if( !isspace(ch) )
				break;
		words[wi] = sp;

		for(; ch = *sp; sp++ ){
			if( isspace(ch) ){
				*sp++ = 0;
				break;
			}
		}
	}
}

#define STR_VOLA        0
#define STR_ALLOC       1
#define STR_OVWR        2
typedef int (*IFUNC)();

scan_List(list,sep,allocm,func,a1,a2,a3,a4)
	char *list;
	IFUNC func;
	char *a1,*a2,*a3,*a4;
{	char *alist,*lp,*np;
	int rcode;
	int lev;
	int cch,nch,pch;
	int nelm;

	if( list == 0 || *list == 0 )
		return 0;

	nelm = 0;
	alist = list;
	if( allocm != STR_OVWR )
		list = stralloc(list);
	for( lp = list; *lp; lp = np ){
		int npa;
		npa = 0;
		lev = 0;
		nch = 0;
		for( np = lp; cch = *np; ){
			if( cch == '\\' ){
				nch = np[1];
				if( nch == sep || nch == '{' || nch == '}' )
					strcpy(np,np+1);
				np++;
			}else
			if( cch == '{' ){
				np++;
				lev++;
			}else
			if( cch == '}' ){
				lev--;
				if( lev == 0 && *lp == '{'
				 && npa++ == 0 /* not {L1}@{L2} */
				 && (np[1] == sep || np[1] == 0) ){
					lp++;
					*np++ = 0;
				}else	np++;
			}else
			if( lev == 0 && cch == sep ){
				*np++ = 0;
				break;
			}else{
				np++;
			}
		}
		nelm++;
		if( func != 0 )
		if( rcode = (*func)(lp,a1,a2,a3,a4) )
			return rcode;

		if( np == 0 )
			break;
	}
	if( list != alist && allocm != STR_ALLOC )
		free(list);
	if( func == 0 )
		return nelm;
	return 0;
}
#ifdef MAIN
static pr1(s) char *s; { printf("[%s] ",s); return 0; }
static prs(s) char *s; {
	printf("##[ %-25s] ",s);
	scan_commaList(s,0,pr1);
	printf("\n");
}
main(){
	prs("a,b,c,d");
	prs("{a,b,c,d}");
	prs("{{a,b,c}}");
	prs("{a,b},{c,d}");
	prs("a@{c,d}");
	prs("{a,b}@c");
	prs("{a,b}@{c,d}");
	prs("{a,b}@{c,d},e,f");
	prs("{a,b}@{c,d},{e,f},g,h");
}
#endif

num_ListElems(list,sep)
	char *list,sep;
{
	return scan_List(list,sep,0,(IFUNC)0);
}
scan_ListL(list,sep,allocm,func,a1,a2,a3)
	char *list;
	int (*func)();
	char *a1,*a2,*a3;
{	int rcode;
	char *tp;

	if( *list == '{' && (tp = strchr(list,'}')) && tp[1] == 0 ){
		*tp = 0;
		rcode = scan_List(list+1,sep,allocm,func,a1,a2,a3);
		*tp = '}';
		return rcode;
	}
	return scan_List(list,sep,allocm,func,a1,a2,a3);
}
static list1(l1,ac,av,mac)
	char *l1;
	int *ac;
	char *av[];
{
	if( mac <= *ac )
		return -1;

	strcpy(av[*ac],l1);
	*ac += 1;
	return 0;
}
scan_ListList(list,sep,a1,a2,a3)
	char *list;
	char *a1,*a2,*a3;
{	char *av[4];
	int ac;

	av[0] = a1;
	av[1] = a2;
	av[2] = a3;
	ac = 0;
	scan_List(list,sep,0,list1,&ac,av,3);
	return ac;
}
scan_commaList(list,allocm,func,a1,a2,a3,a4)
	char *list;
	int (*func)();
	char *a1,*a2,*a3,*a4;
{
	return scan_List(list,',',allocm,func,a1,a2,a3,a4);
}
scan_commaListL(list,allocm,func,a1,a2,a3)
	char *list;
	int (*func)();
	char *a1,*a2,*a3;
{
	return scan_ListL(list,',',allocm,func,a1,a2,a3);
}
strsubst(str,pat,subs)
	char *str,*pat,*subs;
{	char *dp,sav[1024],tmp[1024];

	while( dp = strstr(str,pat) ){
		strcpy(sav,str);
		strcpy(tmp,dp+strlen(pat));
		strcpy(dp,subs); dp += strlen(dp); strcpy(dp,tmp);
		if( strcmp(str,sav) == 0 )
			break;
	}
}
onoff_flags(flags,delta,on)
	char *flags,*delta;
{	char map[256];
	char *fp;
	int mi;

	for( mi = 1; mi < 256; mi++ )
		map[mi] = 0;

	for( fp = flags; *fp; fp++ )
		map[*fp] = on;
	for( fp = delta; *fp; fp++ )
		map[*fp] = on;

	fp = flags;
	for( mi = 1; mi < 256; mi++ )
		if( map[mi] )
			*fp++ = mi;
	*fp = 0;
}

numscan(spp)
	char **spp;
{	char *sp,sc;
	int sign,width;

	sp = *spp;
	sc = *sp;
	if( sc == '-' ){
		sign = -1;
		sc = *++sp;
	}else	sign = 1;

	width = 0;
	while( '0' <= sc && sc <= '9' ){
		width = (width * 10) + (sc - '0');
		sc = *++sp;
	}

	*spp = sp;
	return sign*width;
}

#ifdef hpux
char *strncpy(s1, s2, n)
	char *s1,*s2;
	int n;
{	char *sp;

	sp = s1;
	while( 0 < n-- ){
		if( (*sp++ = *s2++) == 0 ){
			while( 0 < n-- )
				*sp++ = 0;
			break;
		}
	}
	return s1;
}
#endif

/*
 *	s1 will be zero terminated, without padded, with max. length n-1.
 */
char *Strncpy(s1,s2,n)
	char *s1,*s2;
	int n;
{	char *sp;

	sp = s1;
	while( 1 < n-- )
		if( (*sp++ = *s2++) == 0 )
			break;
	*sp = 0;
	return s1;
}

Strins(s1,ins)
	char *s1,*ins;
{	int len1,leni;
	char *dp,*sp,ch;

	leni = strlen(ins);
	if( leni == 0 )
		return;

	len1 = strlen(s1);
	if( len1 == 0 ){
		strcpy(s1,ins);
		return;
	}

	sp = &s1[len1];
	dp = &s1[len1 + leni];
	while( s1 <= sp )
		*dp-- = *sp--;

	sp = ins;
	dp = s1;
	while( ch = *sp++ )
		*dp++ = ch;
}

FQDN_hash(key)
        unsigned char *key;
{       unsigned char *ks;
        unsigned int kc,kx,ky;

        kx = 0;
        for( ks = key; kc = *ks++; ){
		ky = (kx >> 27) & 0x1F;
                kx = ((kx << 5) | ky) ^ kc;
	}
        return kx;
}

double Scan_period(period,dfltunit,dflt)
	char *period;
	double dflt;
{	double num,clock;
	char unit;

	if( period == 0 || period[0] == 0 )
		return dflt;
	num = 0;
	unit = dfltunit;
	sscanf(period,"%lf%c",&num,&unit);

	switch( unit ){
		default:
		case 'd': clock = num*24*60*60; break;
		case 'h': clock = num*60*60; break;
		case 'm': clock = num*60; break;
		case 's': clock = num; break;
	}
	if( clock < 0 ) clock = 0;
	return clock;
}
scan_period(period,dfltunit,dflt)
	char *period;
{
	return Scan_period(period,dfltunit,(double)dflt);
}

char *strrpbrk(str,brk)
	char *str,*brk;
{	char ch,*dp,*tp;

	if( brk[0] == 0 )
		return str;
	if( str[0] == 0 )
		return 0;

	tp = 0;
	for( dp = str; ch = *dp; dp++ )
		if( strchr(brk,ch) )
			tp = dp;
	return tp; /* the last match */
}

char *strip_spaces(value)
	char *value;
{	char *vp,*tp;

	for( vp = value; *vp == ' ' || *vp == '\t'; vp++)
		;
	for( tp = vp; *tp; tp++ )
		;
	while( vp < tp && tp[-1] == ' ' )
		tp--;
	*tp = 0;
	return vp;
}

/*
 *	case sensitive when a capital character is in "elem"
 */
typedef struct {
	void   (*l_logfunc)();
	void	*l_logfile;
	int	 l_top;
	int	 l_bottom;
	int	 l_nextch;
	int	 l_negate;
	int	 l_seecase;
} LMarg;

static strmatch1(pattern,target,matches,lma)
	char *pattern;
	char *target;
	int *matches;
	LMarg *lma;
{	int negate,seecase,top,btm,nextch;
	char *match;
	char *pat0,pat1[256],*sp,sc,*pp;
	int plen;

	negate  = lma->l_negate;
	seecase = lma->l_seecase;
	top     = lma->l_top;
	btm     = lma->l_bottom;
	nextch  = lma->l_nextch;

	pp = pat1;
	for( sp = pat0 = strip_spaces(pattern); sc = *sp; sp++ ){
		if( sc == '!' && sp == pat0 ){ negate = 1; }else
		if( sc == '*' && pp == pat1 ){ top = 0; }else
		if( sc == '^' && pp == pat1 ){ top = 1; }else
		if( sc == '*' && sp[1] == 0 ){ btm = 0; nextch = 0; }else
		if( sc == '$' && sp[1] == 0 ){ btm = 1; }else
			*pp++ = sc;
	}
	*pp = 0;
	plen = pp - pat1;

	for( pp = pat1; *pp; pp++ ){
		if( isupper(*pp) ){
			seecase = 1;
			break;
		}
	}

	if( seecase )
		match = strstr(target,pat1);
	else	match = strcasestr(target,pat1);

	if( match ){
		if( top && match != target )
			match = 0;
		if( btm && target[plen] != 0 )
			match = 0;
		if( nextch && target[plen] != nextch )
			match = 0;
	}

	if( match ){
		if( negate )
			*matches = 0;
		else	*matches = 1;
	}

EXIT:
	if( lma->l_logfunc )
		(*lma->l_logfunc)(lma->l_logfile,
			"allow = %d <-- [%s] / [%s] \r\n",*matches,target,pat0);
	return 0;
}
strmatch_list(str,list,cntrl,lfunc,lfile)
	char *str,*list,*cntrl;
	void *lfile;
	void (*lfunc)();
{	int matches;
	char buff[1024];
	LMarg lma;
	char tch;

	lma.l_logfunc = lfunc;
	lma.l_logfile = lfile;
	lma.l_negate = 0;
	lma.l_seecase = 0;
	lma.l_top = cntrl[0] == '^';
	tch = strtailchr(cntrl);
	lma.l_bottom = tch == '$';
	lma.l_nextch = tch != '^' ? tch : 0;

	strcpy(buff,list);
	if( *buff == '!' )
		matches = 1;
	else	matches = 0;
	scan_commaList(buff,0,strmatch1,str,&matches,&lma);
	return matches;
}

char *strcats3(dst,s0,s1,s2)
	char *dst,*s0,*s1,*s2;
{	char *sv[4],*sp,sc,*dp;
	int si;

	sv[0] = s0;
	sv[1] = s1;
	sv[2] = s2;
	sv[3] = 0;

	for( dp = dst; *dp; dp++ )
		;

	for( si = 0; sp = sv[si]; si++ ){
		while( sc = *sp++ )
			*dp++ = sc;
	}
	*dp = 0;
	return dp;
}


static subSetList2(s1,s2)
	char *s1,*s2;
{
	return strcmp(s1,s2) == 0;
}
static subSetList1(s1,s2,sbp)
	char *s1,*s2,**sbp;
{
	if( scan_commaListL(s2,STR_VOLA,subSetList2,s1) == 0 ){
		strcpy(*sbp,s1);
		strcat(*sbp,",");
		*sbp += strlen(s1) + 1;
	}
	return 0;
}
subSetList(s1,s2,sb)
	char *s1,*s2,*sb;
{
	*sb = 0;
	scan_commaListL(s1,STR_VOLA,subSetList1,s2,&sb);
	if( *sb )
		sb[strlen(sb)-1] = 0;
}

static strmatch(s1,s2) char *s1,*s2; { return strcmp(s1,s2) == 0; }
wordIsinList(list,word)
	char *list,*word;
{
	if( scan_commaList(list,0,strmatch,word) )
		return 1;
	return 0;
}


decomp_args(av,mac,args,argb)
	char *av[],*args,*argb;
{	char *sp,*dp,ch;
	int arglen;
	int quoting;
	int ac;

	ac = 0;
	quoting = 0;
	arglen = 0;
	dp = argb;

	for( sp = args; ch = *sp; sp++ ){
		switch( ch ){
			case '"':
				if( quoting )
					quoting = 0;
				else	quoting = 1;
				break;

			case ' ':
			case '\t':
				if( quoting )
					goto ARGCH1;
				else
				if( arglen ){
					*dp++ = 0;
					arglen = 0;
				}
				break;

			case '\\':
				if( sp[1] == '"' )
					ch = *++sp;

			ARGCH1:
			default:
				if( arglen == 0 ){
					av[ac++] = dp;
					if( mac <= ac ){
						while( *dp++ = *sp++ ); 
						goto EXIT;
					}
				}
				*dp++ = ch;
				arglen++;
				break;
		}
	}
EXIT:
	*dp = 0;
	av[ac] = 0;

/*
	{
	int ai;
	for( ai = 0; ai < ac; ai++ )
	printf("[%d] [%s]\n",ai,av[ai]);
	}
*/
	return ac;
}

static addelem(elem,ac,av,aip)
	char *elem;
	int ac;
	char *av[];
	int *aip;
{	int ai;

	ai = *aip;
	av[ai++] = elem;
	(*aip) = ai;
	if( ac <= ai+1 ){
		av[ai] = elem+strlen(elem)+1;
		(*aip) += 1;
		return 1;
	}else	return 0;
}
list2vect(list,del,ac,av)
	char *list,*av[];
{	int cc,ci;

	if( ac <= 1 ){
		av[0] = list;
		return cc;
	}
	cc = 0;
	list[strlen(list)+1] = 0;
	scan_ListL(list,del,STR_OVWR,addelem,ac,av,&cc);
	return cc;
}

int streq(a,b)
	char *a,*b;
{
	if( a == b )
		return 1;
	if( a == 0 || b == 0 )
		return 0;

	if( *a != *b )
		return 0;
	return strcmp(a,b) == 0;
}
char *strtail(s)
	char *s;
{
	if( s[0] ){
		while( s[1] )
			s++;
	}
	return s;
}
