/*///////////////////////////////////////////////////////////////////////
Copyright (c) 1993-1998 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1993-1998 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	JIS.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	930923	extracted from codeconv.c of cosmos
//////////////////////////////////////////////////////////////////////#*/
#include <string.h>
#include <ctype.h>
char *malloc();

/*
 *	STATUS CHANGE CODES
 */
#define ESC		'\033'
#define TO_2BCODE	'$'
#define TO_1BCODE	'('

#define TO_KANA		'\016'
#define TO_KANAOUT	'\017'

#define TO_KANJI	"\033$B"
#define TO_ASCII	"\033(B"

#define IS_SJIS_LO(lo)	((0x40<=lo)&&(lo!=0x7F)&&(lo<=0xFC))
#define IS_SJIS_HI1(hi) ((0x81<=hi)&&(hi<=0x9F))	/* 1st lev. */
#define IS_SJIS_HI2(hi) ((0xE0<=hi)&&(hi<=0xEF))	/* 2nd lev. */
#define IS_SJIS_HI(hi)	(IS_SJIS_HI1(hi)||IS_SJIS_HI2(hi))
#define IS_SJIS(hi,lo,in_sjis)\
	(!IS_SJIS_LO(lo) ? 0:\
	IS_SJIS_HI1(hi) ? (in_sjis = 1):\
	in_sjis && IS_SJIS_HI2(hi))

#define IS_SJIS_1B(ch)	(0xA1 <= (ch) && (ch) <= 0xDF)

#define SJIS_DAKUTEN	0xDE
#define SJIS_HANDAKU	0xDF
static char *SJIS_1B_TO_JIS[] = {
/* 0xA1-A7 */       "!#", "!V", "!W", "!\"","!%", "%r", "%!",
/* 0xA8-AF */ "%#", "%%", "%'", "%)", "%c", "%e", "%g", "%C",
/* 0xB0-B7 */ "!<", "%\"","%$", "%&", "%(", "%*", "%+", "%-",
/* 0xB8-BF */ "%/", "%1", "%3", "%5", "%7", "%9", "%;", "%=",
/* 0xC0-C7 */ "%?", "%A", "%D", "%F", "%H", "%J", "%K", "%L",
/* 0xC8-CF */ "%M", "%N", "%O", "%R", "%U", "%X", "%[", "%^",
/* 0xD0-D7 */ "%_", "%`", "%a", "%b", "%d", "%f", "%h", "%i",
/* 0xD8-DF */ "%j", "%k", "%l", "%m", "%o", "%s", "!+", "!,"
};
static char *SJIS_1B_TO_DAKUTEN[] = {
/* 0xA1-A7 */       0,    0,    0,    0,    0,    0,    0,
/* 0xA8-AF */ 0,    0,    0,    0,    0,    0,    0,    0,
/* 0xB0-B7 */ 0,    0,    0,    "%t", 0,    0,    "%,", "%.",
/* 0xB8-BF */ "%0", "%2", "%4", "%6", "%8", "%:", "%<", "%>",
/* 0xC0-C7 */ "%@", "%B", "%E", "%G", "%I", 0,    0,    0,
/* 0xC8-CF */ 0,    0,    "%P", "%S", "%V", "%Y", "%\\",0,
/* 0xD0-D7 */ 0,    0,    0,    0,    0,    0,    0,    0,
/* 0xD8-DF */ 0,    0,    0,    0,    0,    0,    0,    0
};
static char *SJIS_1B_TO_HANDAKU[] = {
/* 0xA1-A7 */       0,    0,    0,    0,    0,    0,    0,
/* 0xA8-AF */ 0,    0,    0,    0,    0,    0,    0,    0,
/* 0xB0-B7 */ 0,    0,    0,    0,    0,    0,    0,    0,
/* 0xB8-BF */ 0,    0,    0,    0,    0,    0,    0,    0,
/* 0xC0-C7 */ 0,    0,    0,    0,    0,    0,    0,    0,
/* 0xC8-CF */ 0,    0,    "%Q", "%T", "%W", "%Z", "%]", 0,
/* 0xD0-D7 */ 0,    0,    0,    0,    0,    0,    0,    0,
/* 0xD8-DF */ 0,    0,    0,    0,    0,    0,    0,    0
};

#define EUC_HANKAKU_HI	0x8E
#define IS_EUC_HANKAKU(hi,lo)	(hi==EUC_HANKAKU_HI && IS_SJIS_1B(lo))

#define IS_EUC_LOS(lo)	((0x21<=lo)&&(lo<=0x7E))	/* standard */
#define IS_EUC_LOX(lo)	((0xA1<=lo)&&(lo<=0xFE))	/* extended */
#define IS_EUC_HI(hi)	((0xA1<=hi)&&(hi<=0xFE))
#define IS_EUC(hi,lo)\
	(IS_EUC_HANKAKU(hi,lo) || \
	IS_EUC_HI(hi) && (IS_EUC_LOS(lo) || IS_EUC_LOX(lo)))


int TREAT_SJIS = 1;

IS_SJIS_STR(str)
	unsigned char *str;
{	unsigned char *s,ch;
	int is_sjis = 0;

	s = str;
	while( ch = *s++ ){
		if( ch & 0x80 )
			if( !IS_EUC_HANKAKU(ch,*s) )
			if( IS_SJIS(ch,*s,is_sjis) )
				return 1;
	}
	return 0;
}

unsigned char *
SJIS_TO_JIS1(HI,LO,JCODE)
	register unsigned char HI,LO,*JCODE;
{
	HI -= (HI <= 0x9F) ? 0x71 : 0xB1;
	HI = (HI << 1) + 1;
	if( 0x7F < LO )
		LO--;
	if( 0x9E <= LO ){
		LO -= 0x7D;
		HI++;
	}else	LO -= 0x1F;
	JCODE[0] = HI;
	JCODE[1] = LO;
	return JCODE;
}
unsigned char *
JIS_TO_SJIS1(HI,LO,SJCODE)
	register unsigned char HI,LO,*SJCODE;
{
	if( HI & 1 )
		LO += 0x1F;
	else	LO += 0x7D;
	if( 0x7F <= LO )
		LO++;

	HI = (((int)HI - 0x21) >> 1) + 0x81;
	if( 0x9F < HI )
		HI += 0x40;
	SJCODE[0] = HI;
	SJCODE[1] = LO;
	return SJCODE;
}

unsigned char *
SJIS_TO_EUC1(HI,LO,EUC)
	unsigned char HI,LO,*EUC;
{
	SJIS_TO_JIS1(HI,LO,EUC);
	EUC[0] |= 0x80;
	EUC[1] |= 0x80;
	return EUC;
}

unsigned char *
SJIS_TO_EUC(src,dst)
	unsigned char *src,*dst;
{	register unsigned char hi,lo,*sp,*dp;
	register int in_sjis = 0;

	in_sjis = IS_SJIS_STR(src);
	for(sp=src, dp=dst; hi = sp[0]; ){
		lo = sp[1];
		if( TREAT_SJIS && IS_SJIS(hi,lo,in_sjis) ){
			SJIS_TO_JIS1(hi,lo,dp);
			dp[0] |= 0x80;
			dp[1] |= 0x80;
			dp += 2;
			sp += 2;
		}else	*dp++ = *sp++;
	}
	*dp = 0;
	return dst;
}

unsigned char *
EUC_TO_SJIS(src,dst)
	unsigned char *src,*dst;
{	register unsigned char *sp,*dp;

	for(sp=src, dp=dst; *sp; ){
		if( *sp & 0x80 ){
			if( IS_EUC_HANKAKU(sp[0],sp[1]) ){
				*dp++ = sp[1];
				sp += 2;
			}else
			if( sp[1] && (sp[1] & 0x80) ){
				JIS_TO_SJIS1(sp[0]&0x7F,sp[1]&0x7F,dp);
				dp += 2; sp += 2;
			}else	sp++;
		}else	*dp++ = *sp++;
	}
	*dp = 0;
	return dst;
}

#define Strcpy(a,b)	(strcpy((char*)a,(char*)b),&a[strlen((char*)a)])

static char *sjis_1b_to_jis(ch1,ch2,cat)
	int *cat;
{	unsigned char c1,c2;
	char *js;

	c1 = (0x80 | ch1) - 0xA1;
	c2 =  0x80 | ch2;
	if( c2 == SJIS_DAKUTEN && (js = SJIS_1B_TO_DAKUTEN[c1])
	 || c2 == SJIS_HANDAKU && (js = SJIS_1B_TO_HANDAKU[c1]) ){
		*cat = 1;
		return js;
	}else{
		*cat = 0;
		return SJIS_1B_TO_JIS[c1];
	}
}
static EUC_hankaku_TO_JIS(spp,dpp)
	unsigned char **spp,**dpp;
{	unsigned char *sp,*dp;
	unsigned char ch1,ch2;
	char *js;
	int cat;

	sp = *spp;
	dp = *dpp;
	if( !IS_EUC_HANKAKU(sp[0],sp[1]) )
		return 0;

	ch1 = sp[1];
	if( sp[2] && sp[3] )
		ch2 = sp[3];
	else	ch2 = 0;
	js = sjis_1b_to_jis(ch1,ch2,&cat);
	if( cat )
		sp += 2;

	strcpy(dp,js);
	dp += 2; *dpp = dp;
	sp += 2; *spp = sp;
	return 1;
}

unsigned char *
EUC_TO_JIS(src,dst,toK,toA)
	unsigned char *src,*dst;
	char *toK,*toA;
{	register unsigned char kana_mode = 0;
	register unsigned char cch;
	register unsigned char *sp = src;
	register unsigned char *dp = dst;
	int is_JIS = 0;

	while( cch = *sp++ ){
		if( cch & 0x80 ){
			if( !IS_EUC(cch,*sp) ){
				if( cch == 0xA0 && is_JIS ) /* ignore NBSP */
					continue;
				is_JIS++;
				*dp++ = cch;
				continue;
			}
			if(!kana_mode){
				kana_mode = ~kana_mode;
				dp = Strcpy(dp,toK);
			}
			if( IS_EUC_HANKAKU(cch,*sp) ){
				unsigned char *sp1,*dp1;
				sp1 = sp - 1;
				dp1 = dp;
				EUC_hankaku_TO_JIS(&sp1,&dp1);
				sp = sp1;
				dp = dp1;
			}else
			if( *sp & 0x80 ){
				*dp++ = cch & ~0x80;
				*dp++ = *sp++ & ~0x80;
			}
		}else{
			if(kana_mode){
				kana_mode = ~kana_mode;
				dp = Strcpy(dp,toA);
			}
			*dp++ = cch;
		}
	}
	if(kana_mode)
		dp = Strcpy(dp,toA);

	if(dp)	*dp = 0;
	return dst;
}

#define IS_JIS_HI(c1)	(0x20 < (c1) && (c1) < 0x7F)
#define IS_JIS_LO(c1)	(0x20 < (c1) && (c1) < 0x7F)
#define	IS_JIS7(c1,c2)	(IS_JIS_HI(c1) && IS_JIS_LO(c2))
#define SO		('N'-0x40)
#define SI		('O'-0x40)

int repair_JIS = 0;
static unsigned char *repairJIStoEUC(src,dstp)
	unsigned char *src,**dstp;
{	unsigned char *s,*d,ch1,ch2;

	d = *dstp;
	s = src;
	while( (ch1 = s[0]) && (ch2 = s[1]) ){
		s += 2;
		if( ch1 == '(' )
		if( ch2 == 'B' || ch2 == 'J' ){
			*dstp = d;
			return s;
		}
		if( !IS_JIS7(ch1,ch2) )
			return 0;

		*d++ = 0x80 | ch1;
		*d++ = 0x80 | ch2;
	}
	return 0;
}


#define sputc(sp,ch)	(sp?(*sp++ = ch):ch)

static istag(str)
	char *str;
{	char ch,*s;

	for( s = str; ch = *s; s++ ){
		if( ch == '>' || isspace(ch) )
			return str < s;
		if( !isalpha(ch) )
			return 0;
	}
	return 0;
}

FIX_2022(src,dst,ctype)
	char *src,*dst,*ctype;
{	int in2B;
	char ch1,ch2,*sp,*dp;
	int bad;
	int isHTML,len,ech;

	in2B = 0;
	sp = src;
	dp = dst;
	bad = 0;

	isHTML = strcasecmp(ctype,"text/html") == 0;

	while( ch1 = *sp++ ){
		if( ch1 == ESC ){
			if( *sp == TO_2BCODE ){
				if( sp[1] == 'B' || sp[1] == '@' ){
					in2B = 1;
					sputc(dp, ch1);
					sputc(dp, *sp++);
					sputc(dp, *sp++);
					continue;
				}
			}else
			if( *sp == TO_1BCODE ){
				if( sp[1] == 'B' || sp[1] == 'J' ){
					in2B = 0;
					sputc(dp, ch1);
					sputc(dp, *sp++);
					sputc(dp, *sp++);
					continue;
				}
			}
		}

		if( in2B ){
			ch2 = sp[0];
			if( ch1 <= 0x20
			||  ch2 <= 0x20
			||  isHTML && ch1=='<' && sp[0]=='/' && istag(&sp[1])
			||  isHTML && ch2=='<' && sp[1]=='/' && istag(&sp[2]) ){
				in2B = 0;
				sputc(dp, ESC);
				sputc(dp, TO_1BCODE);
				sputc(dp, 'B');
				sputc(dp, ch1);
				bad = 1;
				continue;
			}

			if( isHTML && ch1 == '&' )
			if( len = isHTMLentity(sp,&ech) )
			if( sp[len] != 0 ){
				ch1 = ech;
				sp += len;
				bad = 1;
			}

			ch2 = *sp++;

			if( isHTML && ch2 == '&' )
			if( len = isHTMLentity(sp,&ech) )
			if( sp[len] != 0 ){
				ch2 = ech;
				sp += len;
				bad = 1;
			}

			sputc(dp, ch1);
			sputc(dp, ch2);
		}else{
			sputc(dp, ch1);
		}
	}
	sputc(dp, 0);
	return bad;
}

unsigned char*
TO_EUC(jis,euc,ctype)
	unsigned char *jis,*euc;
	char *ctype;
{	register unsigned char *s,c,jis_stat;
	register to1B,to2B;
	register int in_sjis = 0;
	int in_1Bkana = 0;
	unsigned char *d;
	static int nje;
	int n8bits;
	int is_JIS;

	nje++;
	n8bits = 0;
	s = jis;
	d = euc;
	jis_stat = 0;
	to2B = TO_2BCODE;
	to1B = TO_1BCODE;
	in_sjis = IS_SJIS_STR(jis);
	is_JIS = 0;

	while( c = *s++ ){
		if( c == 0x80 )
			continue; /* ignore it */
		if( c == 0xA0 && is_JIS )
			continue; /* ignore Non-breaking space */

		if( c == to2B && jis_stat == 0 && repair_JIS ){
			if(*s == 'B' || *s == '@'){
				unsigned char *ts;
				if( ts = repairJIStoEUC(s+1,&d) ){
					s = ts;
					continue;
				}
			}
		}
		if( c == ESC ){
			in_1Bkana = 0;
			if(*s == to2B){
				if((s[1] == 'B') || (s[1] == '@')){
					jis_stat = 0x80; s += 2;
					is_JIS++;
					continue;
				}
				jis_stat = 0;
			}else
			if(*s == to1B){
				jis_stat = 0;
				if((s[1]=='B') || (s[1]=='J') || (s[1]=='H')){
					s += 2;
					continue;
				}
				if( s[1]=='I' ){
					s += 2;
					is_JIS++;
					in_1Bkana = 1;
					continue;
				}
			}else
			if(*s == ',') /* MULE */ {
				jis_stat = 0;
			}
		}
		if( is_JIS ){
			if( c == SO ){
				in_1Bkana = 1;
				continue;
			}
			if( c == SI ){
				in_1Bkana = 0;
				continue;
			}
		}

		if( c & 0x80 )
			n8bits++;

		if( !in_sjis && c == EUC_HANKAKU_HI && IS_SJIS_1B(*s) ){
			*d++ = c;
			*d++ = *s++;
		}else
		if( in_sjis&&IS_SJIS_1B(c) || in_1Bkana&&IS_SJIS_1B(0x80|c) ){
			d[0] = EUC_HANKAKU_HI;
			d[1] = c | 0x80;
			d += 2;
			is_JIS++;
		}else
		if( IS_SJIS(c,*s,in_sjis) ){
			SJIS_TO_EUC1(c,*s,d);
			d += 2;
			s++;
			is_JIS++;
		}else
		if( jis_stat ){
			if( c <= 0x20 || 0x7F <= c ){
				*d++ = c;
				if( c == '\n' )
					jis_stat = 0;
			}else{
				if( IS_JIS7(c,*s)){
					*d++ = jis_stat | c;
					*d++ = jis_stat | *s++;
				}else	*d++ = c;
			}
		}else{
			if( n8bits == 0 && (c == SI || c == SO) ){
			}else{
				*d++ = c;
			}
		}
	}
	*d = 0;
	return euc;
}

static is_EUC_JP(euc)
	char *euc;
{	char *cp;
	int ch1,ch2;

	for( cp = euc; ch1 = *cp & 0xFF; cp++ ){
		if( ch1 & 0x80 ){
			ch2 = cp[1] & 0xFF;
			if( !IS_EUC(ch1,ch2) )
				return 0;
			cp++;
		}
	}
	return 1;
}

TO_SJIS(any,sjis,ctype)
	char *any,*sjis;
	char *ctype;
{	char *euc;

	euc = malloc(strlen(any)*2+1);
	TO_EUC(any,euc,ctype);
	if( is_EUC_JP(euc) )
		EUC_TO_SJIS(euc,sjis);
	else	strcpy(sjis,any);
	free(euc);
}

TO_JIS(any,jis,ctype)
	char *any;
	unsigned char *jis;
	char *ctype;
{	char *euc;

	if( any[0] == 0 ){
		jis[0] = 0;
		return;
	}

	euc = malloc(strlen(any)*2+1);
	TO_EUC(any,euc,ctype);

	/* if NOT old-Netscape ??? DeleGate/2.1.5-DeleGate/2.1.9 */
	if( is_EUC_JP(euc) )
		EUC_TO_JIS(euc,jis,TO_KANJI,TO_ASCII);
	else	strcpy(jis,any);
	free(euc);
}

#include <stdio.h>

#define CC_THRU		0
#define CC_ASCII	1
#define CC_JIS2B7	2
#define CC_JIS7K	3	/* with 7bit/1byte kana by ESC(I */
#define CC_SJIS		4
#define CC_EUCJP	5
#define CC_JIS7KANA	6
#define CC_JIS7ROMA	7
#define JIS2B8(code)	(code == CC_SJIS || code == CC_EUCJP)
#define JIS2B(code)	(code == CC_JIS2B7 || JIS2B8(code))

typedef struct {
	short	cc_size;
	short	cc_OUT; /* target charcode of conversion */
	short	cc_out;	/* current output charcode */
	short	cc_in;	/* current input charcode */
	short	cc_previn; /* previous non-ASCII input charcode */
unsigned char	cc_pinb[8];
	int	cc_pinx;
} CCX;

#define setccin(ccx,cc)	{ \
	if( ccx->cc_in != ccx->cc_previn && JIS2B(ccx->cc_in) )\
		ccx->cc_previn = ccx->cc_in; \
	ccx->cc_in = cc; \
}

#define pushpending(ccx,ch) (ccx->cc_pinb[ccx->cc_pinx++] = ch)
#define EOB	-1
#define CHn(n) \
	((pilen <= pix+n) ? EOB : \
	(pix+n < pin) ? ccx->cc_pinb[pix+n] : cinb[pix+n-pin])
#define CH1 CHn(0)
#define CH2 CHn(0)
#define CH3 CHn(1)
#define CH4 CHn(2)

#define inNonASCII(ccx,code) \
	(  ccx->cc_in == code \
	|| ccx->cc_in == CC_ASCII && ccx->cc_previn == code )

/* distinguish SJIS from EUC */
static is_SJIS(ccx,cinb,pix,pin,pilen)
	CCX *ccx;
	unsigned char *cinb;
{	int ci,ch1,ch2;
	int is_euc,n2K,insjis,n1K,n2B;

	is_euc = inNonASCII(ccx,CC_EUCJP);
	n2K = 0;

	if( ccx->cc_in != CC_SJIS )
	/* if( ccx->cc_previn == CC_EUCJP ) */
	/* EUC may be misunderstood as SJIS-Hankaku sequence ... */
	{
		for( ci = 0; ci < 128; ){
			ch1 = CHn(ci);
			ci++;
			if( ch1 == EOB || ch1 == '\r' || ch1 == '\n' )
				break;

			if( ch1 & 0x80 ){
				ch2 = CHn(ci);
				ci++;
				if( ch2 == EOB )
					break;
				if( !IS_EUC(ch1,ch2) ){
					is_euc = 0;
					break;
				}
				is_euc = 1;
				if( IS_EUC_HANKAKU(ch1,ch2) )
					n2K++;
			}
		}
	}

	insjis = inNonASCII(ccx,CC_SJIS);

	if( is_euc && n2K && !insjis )
		return 0;

	n1K = 0;
	n2B = 0;
	for( ci = 0; ci < 128; ){
		ch1 = CHn(ci);
		ci++;
		if( ch1 == EOB || ch1 == '\r' || ch1 == '\n' || ch1 == '\t' )
			break;
		if( ch1 == 033 )
			break;

		if( ch1 & 0x80 ){
			ch2 = CHn(ci);
			if( ch2 == EOB )
				break;

			if( IS_SJIS(ch1,ch2,insjis) ){
				ci++;
				n2B++;
				continue;
			}
			if( IS_SJIS_1B(ch1) ){
				n1K++;
				continue;
			}
			insjis = 0;
			break;
		}
	}

	if( insjis && n2B )
		return 1;
	if( is_euc && (ccx->cc_in == CC_EUCJP || ccx->cc_previn == CC_EUCJP) )
		return 0;
	return insjis;
}

CCXclear(ccx)
	CCX *ccx;
{
	bzero(ccx,ccx->cc_size);
}
CCXactive(ccx)
	CCX *ccx;
{
	return ccx->cc_OUT != CC_THRU;
}
int CCXcreate(from,to,ccx)
	char *from,*to;
	CCX *ccx;
{	int charcode;

	switch( *to ){
		case 'j': case 'J': charcode = CC_JIS2B7; break;
		case 'k': case 'K': charcode = CC_JIS7K;  break;
		case 's': case 'S': charcode = CC_SJIS;   break;
		case 'e': case 'E': charcode = CC_EUCJP;  break;
		case 't': case 'T': charcode = CC_THRU;   break;
		default: return 0;
	}
	ccx->cc_size = sizeof(CCX);
	ccx->cc_OUT = charcode;
	ccx->cc_out = CC_ASCII;
	ccx->cc_in = CC_ASCII;
	ccx->cc_previn = CC_ASCII;
	return sizeof(CCX);
}
CCX *CCXnew(from,to)
	char *from,*to;
{	CCX ccxbuf,*ccx;
	int size;

	if( size = CCXcreate(from,to,&ccxbuf) ){
		ccx = (CCX*)malloc(size);
		bcopy(&ccxbuf,ccx,size);
		return ccx;
	}else	return NULL;
}

#define toJIS7(ccx,op) {\
	if( ccx->cc_out != CC_JIS2B7 ){ \
		*op++ = 033; \
		*op++ = '$'; \
		*op++ = 'B'; \
		ccx->cc_out = CC_JIS2B7; \
	}}

#define toJIS7K(ccx,op) {\
	if( ccx->cc_out != CC_JIS7K ){ \
		*op++ = 033; \
		*op++ = '('; \
		*op++ = 'I'; \
		ccx->cc_out = CC_JIS7K; \
	}}

#define toASCII(ccx,op) { \
	if( ccx->cc_out == CC_JIS2B7 || ccx->cc_out == CC_JIS7K ) \
	if( !JIS2B8(ccx->cc_OUT) ){ \
		*op++ = 033; \
		*op++ = '('; \
		*op++ = 'B'; \
	} \
	ccx->cc_out = CC_ASCII; }

CCXexec(ccx,cinb,ilen,out,osiz)
	CCX *ccx;
	unsigned char *cinb,*out;
{	int ch1,ch2,ch3,ch4;
	unsigned char *pinb,*op;
	int pilen,pix,pin;
	int insjis;
	char *js;
	int cat;
	int codesw;

	op = out;

	pin = ccx->cc_pinx; ccx->cc_pinx = 0;
	pinb = ccx->cc_pinb;
	pilen = pin + ilen;
	pix = 0;

	while( pix < pilen ){
		ch1 = CH1;
		pix++;
		ch2 = CH2;

		if( ch1 == 033 ){
			/* single ESC from keyboard input must be passed
			 * thru ...  */
			if( ch2 == EOB /* && not buffer full ... */ ){
				pushpending(ccx,ch1);
				break;
			}
			if( ch2 == '$' || ch2 == '(' ){
				ch3 = CH3;
				if( ch3 == EOB ){
					pushpending(ccx,ch1);
					pushpending(ccx,ch2);
					break;
				}

				codesw = 0;
				if( ch2 == '$' ){
					if( ch3 == 'B' || ch3 == '@' )
						codesw = CC_JIS2B7;
				}else
				if( ch2 == '(' ){
					if( ch3 == 'B' ){
						codesw = CC_ASCII;
					}else
					if( ch3 == 'J' ){
						codesw = CC_ASCII;
						/* CC_JIS7ROMA */
					}else
					if( ch3 == 'I' ){
						codesw = CC_JIS7KANA;
					}
				}
				if( codesw ){
					setccin(ccx,codesw);
					if( JIS2B8(ccx->cc_OUT)
					 || ccx->cc_OUT == CC_JIS2B7
					 && codesw == CC_JIS7KANA
					){
						pix += 2;
						continue;
					}
				}
			}
		}

		if( ccx->cc_in == CC_JIS7KANA )
		if( (ch1 & 0x80) == 0 && IS_SJIS_1B(ch1 | 0x80) ){
			switch( ccx->cc_OUT ){
			    case CC_JIS7K:
				*op++ = ch1;
				break;

			    case CC_JIS2B7:
				toJIS7(ccx,op);
				js = sjis_1b_to_jis(ch1,ch2,&cat);
				*op++ = js[0];
				*op++ = js[1];
				if( cat ) pix++;
				break;

			    case CC_EUCJP:
				*op++ = EUC_HANKAKU_HI;
				*op++ = 0x80 | ch1;
				break;

			    default:
				*op++ = 0x80 | ch1;
				break;
			}
			continue;
		}

		if( ccx->cc_in == CC_JIS2B7 && IS_JIS_HI(ch1) ){
			if( ch2 == EOB ){
				pushpending(ccx,ch1);
				break;
			}
			if( IS_JIS7(ch1,ch2) ){
				switch( ccx->cc_OUT ){
					case CC_SJIS:
						JIS_TO_SJIS1(ch1,ch2,op);
						op += 2;
						break;
					case CC_EUCJP:
						*op++ = 0x80 | ch1;
						*op++ = 0x80 | ch2;
						break;
					default:
						*op++ = ch1;
						*op++ = ch2;
						break;
				}
				pix++;
				continue;
			}
		}

		if( IS_SJIS_HI(ch1) || IS_EUC_HI(ch1) ){
			if( ch2 == EOB ){
				pushpending(ccx,ch1);
				break;
			}

			if( IS_SJIS_1B(ch1) )
			if( ccx->cc_in != CC_EUCJP )
			if( inNonASCII(ccx,CC_SJIS)
			 || is_SJIS(ccx,cinb,pix-1,pin,pilen) ){
				setccin(ccx,CC_SJIS);

				switch( ccx->cc_OUT ){
				    case CC_JIS7K:
					toJIS7K(ccx,op);
					*op++ = 0x7F & ch1;
					break;
				    case CC_JIS2B7:
					toJIS7(ccx,op);
					js = sjis_1b_to_jis(ch1,ch2,&cat);
					*op++ = js[0];
					*op++ = js[1];
					if( cat ) pix++;
					break;

				    case CC_EUCJP:
					*op++ = EUC_HANKAKU_HI;
					*op++ = ch1;
					break;

				    default:
					*op++ = ch1;
					break;
				}
				continue;
			}

			if( IS_EUC_HANKAKU(ch1,ch2) )
			if( inNonASCII(ccx,CC_EUCJP)
			 || !is_SJIS(ccx,cinb,pix-1,pin,pilen) ){
				setccin(ccx,CC_EUCJP);
				ch3 = CH3;
				ch4 = CH4;
				pix++;

				switch( ccx->cc_OUT ){
				    case CC_SJIS:
					*op++ = ch2;
					break;

				    case CC_JIS7K:
					toJIS7K(ccx,op);
					*op++ = 0x7F & ch2;
					break;

				    case CC_JIS2B7:
					ch1 = ch2;
					if( IS_EUC_HANKAKU(ch3,ch4) )
						ch2 = ch4;
					else	ch2 = -1;

					toJIS7(ccx,op);
					js = sjis_1b_to_jis(ch1,ch2,&cat);
					*op++ = js[0];
					*op++ = js[1];
					if( cat ) pix += 2;
					break;

				    default:
					*op++ = ch1;
					*op++ = ch2;
					break;
				}
				continue;
			}

			if( IS_EUC(ch1,ch2) )
			if( inNonASCII(ccx,CC_EUCJP)
			 || !is_SJIS(ccx,cinb,pix-1,pin,pilen) ){
				setccin(ccx,CC_EUCJP);
				pix++;

				switch( ccx->cc_OUT ){
				    case CC_JIS2B7:
				    case CC_JIS7K:
					toJIS7(ccx,op);
					*op++ = 0x7F & ch1;
					*op++ = 0x7F & ch2;
					break;

				    case CC_SJIS:
					JIS_TO_SJIS1(0x7F&ch1,0x7F&ch2,op);
					op += 2;
					break;

				    default:
					*op++ = ch1;
					*op++ = ch2;
					break;
				}
				continue;
			}

			insjis = inNonASCII(ccx,CC_SJIS);
			if( IS_SJIS(ch1,ch2,insjis) )
			if( inNonASCII(ccx,CC_SJIS)
			 || is_SJIS(ccx,cinb,pix-1,pin,pilen) ){
				setccin(ccx,CC_SJIS);
				pix++;

				switch( ccx->cc_OUT ){
				    case CC_JIS2B7:
				    case CC_JIS7K:
					toJIS7(ccx,op);
					SJIS_TO_JIS1(ch1,ch2,op);
					op += 2;
					break;

				    case CC_EUCJP:
					SJIS_TO_JIS1(ch1,ch2,op);
					*op++ |= 0x80;
					*op++ |= 0x80;
					break;

				    default:
					*op++ = ch1;
					*op++ = ch2;
					break;
				}
				continue;
			}
		}
		setccin(ccx,CC_ASCII);
		toASCII(ccx,op);
		*op++ = ch1;
	}
	if( ilen == 0 )
		toASCII(ccx,op);
	*op = 0;
	return op - out;
}

strip_ISO2022JP(str)
	char *str;
{	char ch,*sp,*dp;

	dp = str;
	for( sp = str; ch = *sp++; ){
		if( ch == 033 )
		if( *sp == TO_2BCODE && (sp[1]=='@' || sp[1]=='B')
		 || *sp == TO_1BCODE && (sp[1]=='J' || sp[1]=='B')
		){
			sp += 2;
			continue;
		}
		*dp++ = ch;
	}
	*dp = 0;
}
