/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1998 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1998 Yutaka Sato

Permission to use, copy, and distribute this material for any purpose
and without fee is hereby granted, provided that the above copyright
notice and this permission notice appear in all copies.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	mimecodes.c
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:
History:
	980910	created
//////////////////////////////////////////////////////////////////////#*/
#include <ctype.h>
#include <stdio.h>

#define CR	'\r'
#define LF	'\n'
#define SP	' '
#define TAB	'\t'
#define EQ	'='

static char B64CH[] =
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

#define NON64	-1
#define WHITE	-2
#define PADDCH	-3
static char B64IX[0x100];

static init_64()
{	int ix;

	for( ix = 0; ix < 0x100; ix++ )
		B64IX[ix] = NON64;
	B64IX[SP] = B64IX[TAB] = B64IX[CR] = B64IX[LF] = WHITE;
	B64IX[EQ] = PADDCH;
	for( ix = 0; ix < 64; ix++ )
		B64IX[B64CH[ix]] = ix;
}

#define QP_THRU	 1
#define QP_ESC	-1
static char QPIX[0x100];
static init_QP()
{	int ix;

	for( ix = 0; ix < 0x100; ix++ ){
		if( 0x80 <= ix || iscntrl(ix) && !isspace(ix) || ix == EQ )
			QPIX[ix] = QP_ESC;
		else	QPIX[ix] = QP_THRU;
	}
}
MIME_setQP(qpchars)
	char *qpchars;
{	int ch;

	init_QP();
	while( ch = *qpchars++ )
		QPIX[ch] = QP_ESC;
}

MIME_to64(in,out)
	FILE *in,*out;
{	int gotEOF,ich,ocol,ix,oint,shifts,o1,ox;

	gotEOF = 0;
	ocol = 0;
	while( !gotEOF ){
		oint = 0;
		shifts = 16;
		for( ix = 0; ix < 3; ix++ ){
			ich = getc(in);
			if( ich == EOF ){
				gotEOF = 1;
				break;
			}
			oint |= (ich << shifts);
			shifts -= 8;
		}
		if( ix == 0 )
			break;
		if( 71 < ocol ){
			putc(LF,out);
			ocol = 0;
		}
		shifts = 18;
		for( ox = 0; ox <= ix; ox++ ){
			o1 = (oint >> shifts) & 0x3F;
			shifts -= 6;
			putc(B64CH[o1],out);
		}
		for(; ox < 4; ox++ )
			putc(EQ,out);
		ocol += 4;
	}
	if( 0 < ocol )
		putc(LF,out);
	fflush(out);
}
MIME_from64(in,out)
	FILE *in,*out;
{	int gotEOF,ich,ix,ii,i1,ox,oint,o1,shifts;

	if( B64IX[0] == 0 )
		init_64();

	gotEOF = 0;
	while( !gotEOF ){
		ix = 0;
		oint = 0;
		shifts = 18;
		for( ii = 0; ii < 4; ){
			ich = getc(in);
			if( ich == EOF ){
				if( ix != 0 )
					syslog_ERROR("BASE64 premature EOF\n");
				gotEOF = 1;
				break;
			}
			i1 = B64IX[ich];
			if( i1 == NON64 ){
				syslog_ERROR("BASE64 unrecognized CHAR(0x%x)\n",
					ich);
				ungetc(ich,in);
				gotEOF = 1;
				break;
			}
			if( i1 == WHITE )
				continue;

			if( i1 == PADDCH ){
				ii++;
				continue;
			}
			oint |= (i1 << shifts);
			shifts -= 6;
			ix++;
			ii++;
		}
		if( ix == 0 )
			break;

		shifts = 16;
		for( ox = 1; ox < ix; ox++ ){
			o1 = (oint >> shifts) & 0xFF;
			shifts -= 8;
			putc(o1,out);
		}
	}
	fflush(out);
}

#define GETC1(ch,in,exit)	{ch = getc(in); if( ch == EOF ) goto exit;}
static char hexd[] = "0123456789ABCDEF";

MIME_toQP(in,out)
	FILE *in,*out;
{	int ich,ocol;

	if( QPIX[0] == 0 )
		init_QP();

	ocol = 0;
	for(;;){
		GETC1(ich,in,EXIT);
		if( QPIX[ich] == QP_ESC
		 || ocol == 0 && ich == '.'
		){
			putc(EQ,out);
			putc(hexd[0xF&(ich>>4)],out);
			putc(hexd[0xf&(ich)],out);
			ocol += 3;
		}else
		if( ich == LF ){
			putc(ich,out);
			ocol = 0;
		}else{
			putc(ich,out);
			ocol += 1;
		}
		if( 72 < ocol ){
			putc(EQ,out);
			putc(LF,out);
			ocol = 0;
		}
	}
EXIT:
	if( 0 < ocol ){
		putc(EQ,out);
		putc(LF,out);
	}
	return;
}

MIME_fromQP(in,out)
	FILE *in,*out;
{	int ch1,ch2,softnl,och;
	char buf[3];

	softnl = 0;
	buf[2] = 0;
	for(;;){
		GETC1(ch1,in,EXIT);
		och = ch1;
		if( ch1 == EQ ){
			GETC1(ch1,in,EXIT);
			if( ch1 == CR ){
				GETC1(ch2,in,EXIT);
				if( ch2 == LF )
					ch1 = LF;
				else	ungetc(ch2,in);
			}
			if( ch1 == LF ){
				continue;
			}else
			if( !isxdigit(ch1) ){
				putc(EQ,out);
				putc(ch1,out);
				continue;
			}else{
				GETC1(ch2,in,EXIT);
				if( !isxdigit(ch2) ){
					putc(EQ,out);
					putc(ch1,out);
					putc(ch2,out);
					continue;
				}
				buf[0] = ch1;
				buf[1] = ch2;
				sscanf(buf,"%x",&och);
			}
		}
		putc(och,out);
	}
EXIT:
	return;
}
