#include "vsocket.h"

typedef struct sockaddr *SAP;
typedef struct sockaddr_in SIN;
typedef struct sockaddr_un SUN;

socketpair(d,type,protocol,sv)
	int sv[2];
{	SIN ina;
	SUN una;
	int asock,len;
	SAP sa;
	int salen;
	int rcode = 0;

	sv[0] = sv[1] = -1;
	if( d != AF_INET )
		return -1;

	asock = socket(d,type,protocol);
	if( asock < 0 )
		return -1;

	sa = (SAP)&ina;
	salen = sizeof(ina);
	ina.sin_family = AF_INET;
	ina.sin_addr.s_addr = INADDR_ANY;
	ina.sin_port = 0;

	rcode |= bind(asock,sa,salen);
	rcode |= listen(asock,2);

	len = salen;
	getsockname(asock,sa,&len);
	if( d == AF_INET )
		ina.sin_addr.s_addr = inet_addrV4("127.0.0.1");

	sv[1] = socket(d,type,protocol);
	rcode |= connect(sv[1],sa,salen);

	len = salen;
	sv[0] = accept(asock,sa,&len);
	close(asock);

	return rcode;
}
