/*
 *	@poll.c: this file will be used in systems with poll()
 */
#if defined(_nec_ews) || defined(BUGGY_POLL)
DO NOT USE ITS BUGGY POLL
#endif

#include <poll.h>
#include <stropts.h>
#include <errno.h>
#include "vsocket.h"
int errno;

static int _gotRESET = -1;
connRESETbypeer(){ return _gotRESET; }
static int _gotHUP = -1;
connHUP(){ return _gotHUP; }

static getmsg1(where,what,fd)
	char *where,*what;
{	int rcode;
	struct strbuf cntl,data;
	int flags;

	cntl.maxlen = 0; cntl.len = -1; cntl.buf = 0;
	data.maxlen = 0; data.len = -1; data.buf = 0;
	flags = 0;
	errno = 0;
	rcode = getmsg(fd,&cntl,&data,&flags);
	if( errno == ECONNRESET )
		_gotRESET = fd;

	syslog_ERROR("%s.%s getmsg(%d)=%d %d,%d flags=%x errno=%d\n",
		where,what,fd,rcode,cntl.len,data.len,flags,errno);
}
static checkERR(where,fd,revents)
	char *where;
{
	if( revents & POLLERR )
		getmsg1(where,"POLLERR",fd);

	if( revents & POLLHUP ){
		_gotHUP = fd;
		syslog_ERROR("%s.POLLHUP (%d)\n",where,fd);
	}
	if( revents & POLLNVAL ){
		_gotHUP = fd;
		syslog_ERROR("%s.POLLNVAL (%d)\n",where,fd);
	}
}

PollOut(fd,timeout)
{	struct pollfd pfd[256];
	int nready;

	if( fd < 0 )
		return -1;

	pfd[0].fd = fd;
	pfd[0].events = POLLOUT;

	nready = poll(pfd,1,timeout?timeout:-1);
	if( nready <= 0 )
		return nready;

	return (pfd[0].revents & POLLOUT) ? 1 : 0;
}

PollIn1(fd,timeout)
{	struct pollfd pfd[256];
	int nready;

	_gotRESET = -1;
	_gotHUP = -1;

	if( fd < 0 )
		return -1;

	pfd[0].fd = fd;
	pfd[0].events = (POLLIN|POLLPRI);
	pfd[0].revents = 0;

	nready = poll(pfd,1,timeout?timeout:-1);
	if( nready <= 0 )
		return nready;

	checkERR("PollIn",fd,pfd[0].revents);

	return (pfd[0].revents & (POLLIN|POLLPRI)) ? 1 : 0;
}

PollIns(timeout,size,mask,rmask)
	int *mask,*rmask;
{	struct pollfd pfd[256];
	int fd,nfd,rfd,nready,rready;
	int fi;

	_gotRESET = -1;
	_gotHUP = -1;

	nfd = 0;
	for(fi = 0; fi < size; fi++){
		fd = mask[fi];
		if( 0 <= fd ){
			pfd[nfd].fd = mask[fi];
			pfd[nfd].events = (POLLIN|POLLPRI);
			nfd++;
		}
		rmask[fi] = 0;
	}
	nready = poll(pfd,nfd,timeout?timeout:-1);
	if( nready <= 0 )
		return nready;

	rready = 0;
	rfd = 0;
	for(fi = 0; fi < size; fi++){
		fd = mask[fi];
		if( 0 <= fd ){
			checkERR("PollIns",fd,pfd[rfd].revents);

			if( pfd[rfd].revents & (POLLIN|POLLPRI) ){
				rready++;
				rmask[fi] = 1;
			}else	rmask[fi] = 0;
			rfd++;
		}else	rmask[fi] = 0;
	}
	return rready;
}


PollInsOuts(timeout,nfds,fdv,ev,rev)
	int fdv[],ev[],rev[];
{	struct pollfd fds[1024];
	int fi,ev1,ev2,nready;

	for( fi = 0; fi < nfds; fi++ ){
		fds[fi].fd = fdv[fi];
		fds[fi].revents = 0;
		ev1 = ev[fi];
		ev2 = 0;
		if( ev1 & PS_IN  ) ev2 |= POLLIN;
		if( ev1 & PS_PRI ) ev2 |= POLLPRI;
		if( ev1 & PS_OUT ) ev2 |= POLLOUT;
		fds[fi].events = ev2;
	}
	nready = poll(fds,nfds,timeout);
	for( fi = 0; fi < nfds; fi++ ){
		ev2 = fds[fi].revents;
		ev1 = 0;
		if( ev2 & POLLIN   ) ev1 |= PS_IN;
		if( ev2 & POLLPRI  ) ev1 |= PS_PRI;
		if( ev2 & POLLOUT  ) ev1 |= PS_OUT;
		if( ev2 & POLLERR  ) ev1 |= PS_ERR;
		if( ev2 & POLLHUP  ) ev1 |= PS_HUP;
		if( ev2 & POLLNVAL ) ev1 |= PS_NVAL;
		rev[fi] = ev1;
	}
	return nready;
}
