char *WithThread;
int (*ThreadFork)();
int (*ThreadYield)();

#include <stdio.h>

char *INHERENT_thread()
{
	return WithThread;
}
thread_fork(size,func,a1,a2,a3,a4)
	int (*func)();
	void *a1,*a2,*a3,*a4;
{
	if( ThreadFork )
		return (*ThreadFork)(size,func,a1,a2,a3,a4);

	porting_dbg("NO thread_fork() available.");
	exit(-1);
}


/*
 * Threads are expected to switch to another when a thread become idle
 * waiting for input.  But threads library on some system don't support
 * it, thus switching must be done explicitly, typically on I/O polling.
 * ThreadYield must be defined in such systems.
 */
static int fd_polling[64];
thread_PollIn(fd,timeout)
{	int ti,nth,fdv[8],rfv[8],fdx;
	int timeout1,remain,nready,efd;

	if( ThreadYield == NULL )
		return PollIn(fd,timeout);

	if( fd_polling[fd] != 0 ){
	/*porting_dbg("#### THREAD-POLL: another thread waiting on %d",fd);*/
		exit(0);
	}

	fd_polling[fd] = 1;

START:
	nth = 0;
	fdx = 0;
	for( ti = 0; ti < 64; ti++ )
		if( 0 < fd_polling[ti] ){
			if( ti == fd )
				fdx = nth;
			fdv[nth++] = ti;
		}
	if( nth == 0 )
		goto EXIT;

	if( nth == 1 )
		timeout1 = 100; /* waiting another thread be started */
	else	timeout1 = 5000; /* and more threads... */

	for( remain = timeout; timeout == 0 || 0 < remain; remain -= timeout1 ){
		nready = PollIns(timeout1,nth,fdv,rfv);
		if( 0 <= (efd = connHUP()) ){
			if( efd == fd ){
				nready = 1;
				goto EXIT;
			}else{
				fd_polling[efd] = 0;
				goto START;
			}
		}
		if( nready < 0 )
			break;
		if( nready == 0 ){
			/*porting_dbg("#### yield 1");*/
			(*ThreadYield)();
			continue;
		}
		if( 0 < rfv[fdx] ){
			nready = 1;
			goto EXIT;
		}
		for( ti = 0; ti < nth; ti++ )
		if( 0 < rfv[ti] ){
			/*porting_dbg("#### yield 2: %d",fdv[ti]);*/
			if( (*ThreadYield)() == 0 )
				break;
		}
	}
EXIT:
	fd_polling[fd] = 0;
	return nready;
}
