extern int LOG_type;

#define LOGLEVEL	(LOG_type&0xF)

#define L_SYNC		0x00010
#define L_FG		0x00020
#define L_TTY		0x00040
#define L_SILENT	0x00100
#define	L_TERSE		0x00200
#define L_VERB		0x00400
#define L_EXEC		0x00800
#define L_FORK		0x01000
#define L_STICK		0x02000
#define L_LOCK		0x04000
#define L_ARGDUMP	0x10000

#define lSYNC()	  	(LOG_type & L_SYNC)
#define lFG()	  	(LOG_type & L_FG)
#define lTTY()	  	(LOG_type & L_TTY)
#define lSILENT()	(LOG_type & L_SILENT)
#define lTERSE()  	(LOG_type & L_TERSE)
#define lVERB()	  	(LOG_type & L_VERB)
#define lEXEC()   	(LOG_type & L_EXEC)
#define lFORK()	  	(LOG_type & L_FORK)
#define lSTICK()  	(LOG_type & L_STICK)
#define lLOCK()	  	(LOG_type & L_LOCK)
#define lARGDUMP()	(LOG_type & L_ARGDUMP)

#define LW_CREATE	1
#define LW_EXMATCH	2

typedef struct _Logfile {
	char	*l_proto;
	char	*l_filters;	/* depend on l_proto */
	char	*l_pform;	/* template of path */
	char	*l_path;
	char	*l_lform;	/* format of log data */
	char	*l_mode;	/* mode of fopen */
	FILE	*l_fp;
	int	 l_dolock;	/* do lock */
	int	 l_lockfd;	/* extra lock file */
	char	*l_lkpath;
	int	 l_until;
	char	*l_buff;
	int	 l_size;
	int	 l_leng;
	int	 l_abandon;
} Logfile;

extern char LF_PROTOLOG[];
extern char LF_ERRORLOG[];
extern char LF_LOGFILE[];
extern char *(*LOG_stdlogfile)();
extern int   (*LOG_substfile)();

#ifndef Verbose
extern int LOG_VERBOSE;
#define	Verbose	LOG_VERBOSE==0 ? 0 : sv1vlog
#endif
