/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1994 Electrotechnical Laboratry (ETL)

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies, and
that the name of ETL not be used in advertising or publicity pertaining
to this material without the specific, prior written permission of an
authorized representative of ETL.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:   program/C; charset=US-ASCII
Program:        SLL.h (Simple LL parser)
Author:         Yutaka Sato <ysato@etl.go.jp>
Description:
History:
        940320  created
//////////////////////////////////////////////////////////////////////#*/

typedef struct state {
	char		*r_name;
	char		*r_gate;
	struct state	*r_dest;
	int		 r_flag;
/*
	int		 r_glen;
	char		*r_from;
	char		*r_to;
*/
} SLLRule;

#define ISRULE(s)	extern SLLRule s[]
#ifdef _AIX
#define RULE(s)		SLLRule s[] =
#else
#define RULE(s)		static SLLRule s[] =
#endif
#define ALT(s)		RULE(s){ {"s",0,0,ISALT},
#define SEQ(s)		RULE(s){ {"s",0,0,ISSEQ},
#define END		0};

static char IMM[] = "";

#define SUCCESS		((SLLRule*)1)
#define NEXT		((SLLRule*)2)

#define ISSEQ		 1
#define ISALT		 2
#define OPTIONAL	 4
#define CHARSET		 8
#define PUTVAL		16
#define PUTGATE		32
#define IGNCASE		64

