/*////////////////////////////////////////////////////////////////////////
Copyright (c) 1998 Electrotechnical Laboratry (ETL), AIST, MITI
Copyright (c) 1998 Yutaka Sato

Permission to use, copy, modify, and distribute this material for any
purpose and without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.
ETL MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY OF THIS
MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", WITHOUT ANY EXPRESS
OR IMPLIED WARRANTIES.
/////////////////////////////////////////////////////////////////////////
Content-Type:	program/C; charset=US-ASCII
Program:	sslway.c (SSL encoder/decoder with SSLeay)
Author:		Yutaka Sato <ysato@etl.go.jp>
Description:

  Given environment:
    file descriptor 0 is a socket connected to a client
    file descriptor 1 is a socket connected to a server

  Commandline argument:
    -co  apply SSL for the connection to the server
    -ac  aplly SSL for the accepted connection from the client
    -ht  through pass if the request is in bare HTTP protocol (GET,HEAD,POST)

  Usage:
    delegated FSV="sslway -co" ...
    delegated FCL="sslway -ac" ...

  How to make:
    - copy ssl.o and crypto.o of SSLeay to this directory
    - do make at .. or ../src directory
    - make -f Makefile.go sslway

History:
	980412	created
	980428	renamed from "sslrelay" to "sslway"
//////////////////////////////////////////////////////////////////////#*/
#include <stdio.h>

static int debugging = 0;
static char *client_host;
static int PID;
static ERROR(fmt,a,b,c,d,e,f,g)
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char msg[0x4000];

	sprintf(msg,"## SSLway[%d](%s) ",PID,client_host);
	sprintf(msg+strlen(msg),fmt,a,b,c,d,e,f,g);
	syslog_ERROR("%s\n",msg);
}
#define DEBUG	(debugging==0)?0:ERROR

/*
#include "ssl.h"
*/
#define SSL_FILETYPE_PEM 1
#define SSL_VERIFY_PEER			0x01
#define SSL_VERIFY_FAIL_IF_NO_PEER_CERT	0x02

typedef void SSL_CTX;
typedef void SSL_METHOD;
typedef void SSL;
typedef void X509;
#define BIO_NOCLOSE 0
X509 *PEM_read_bio_X509();
typedef void BIO;
BIO *BIO_new_fp();
X509 *SSL_get_peer_certificate();
SSL_METHOD *SSLv23_method();
SSL_CTX *SSL_CTX_new();
SSL *SSL_new();
char *X509_NAME_oneline();

static SSL_CTX *ssl_new()
{	SSL_CTX *ctx;
	SSL_METHOD *meth;

	SSLeay_add_ssl_algorithms();
	SSL_load_error_strings();
	meth = SSLv23_method();
	ctx = SSL_CTX_new(meth);
	return ctx;
}
static ssl_printf(ssl,fd,fmt,a,b,c,d,e,f,g)
	SSL *ssl;
	char *fmt,*a,*b,*c,*d,*e,*f,*g;
{	char buf[0x4000];

	sprintf(buf,fmt,a,b,c,d,e,f,g);
	if( ssl )
		SSL_write(ssl,buf,strlen(buf));
	else	write(fd,buf,strlen(buf));
}
static ssl_prcert(ssl,show,outssl,outfd,what)
	SSL *ssl;
	char *what;
{	X509 *peer;
	char subjb[1024],*sb,issrb[1024],*is;

	if( peer = SSL_get_peer_certificate(ssl) ){
		sb = X509_NAME_oneline(X509_get_subject_name(peer),subjb,1024);
		is = X509_NAME_oneline(X509_get_issuer_name(peer),issrb,1024);
		if( show ){
			ssl_printf(outssl,outfd,
				"##[SSLway: %s's certificate]\r\n",what);
			ssl_printf(outssl,outfd,"## Subject: %s\r\n",sb);
			ssl_printf(outssl,outfd,"## Issuer: %s\r\n",is);
		}
		ERROR("%s's cert. = **subject<<%s>> **issuer<<%s>>",what,sb,is);
		X509_free(peer);
	}else{
		ERROR("%s's cert. = NONE",what);
	}
}
static SSL *ssl_conn(ctx,confd)
	SSL_CTX *ctx;
{	SSL *conSSL;

	conSSL = SSL_new(ctx);
	SSL_set_connect_state(conSSL);
	SSL_set_fd(conSSL,SocketOf(confd));
	if( SSL_connect(conSSL) < 0 ){
		ERROR("connect failed");
		ERR_print_errors_fp(stderr);
		return NULL;
	}else{
		ERROR("connected");
		return conSSL;
	}
}
static SSL *ssl_acc(ctx,accfd)
	SSL_CTX *ctx;
{	SSL *accSSL;

	accSSL = SSL_new(ctx);
	SSL_set_accept_state(accSSL);
	SSL_set_fd(accSSL,SocketOf(accfd));
	if( SSL_accept(accSSL) < 0 ){
		ERROR("accept failed");
		ERR_print_errors_fp(stderr);
		ssl_printf(accSSL,0,"SSLway: accept failed\n");
		return NULL;
	}else{
		ERROR("accepted");
		return accSSL;
	}
}
static ssl_keycert(ctx,keyfile,certfile)
	SSL_CTX *ctx;
	char *keyfile,*certfile;
{	int code = 0;
	char cwd[1024];

	getcwd(cwd,sizeof(cwd));
	if( SSL_CTX_use_RSAPrivateKey_file(ctx,keyfile,SSL_FILETYPE_PEM) ){
		DEBUG("keyfile loaded: %s",keyfile);
	}else{
		ERROR("keyfile not found or wrong: %s [at %s]",keyfile,cwd);
		code = -1;
	}
	if( SSL_CTX_use_certificate_file(ctx,certfile,SSL_FILETYPE_PEM) ){
		DEBUG("certfile loaded: %s",keyfile);
	}else{
		ERROR("certfile not found or wrong: %s [at %s]",certfile,cwd);
		code = -1;
	}
	return code;
}
static verify_callback()
{
	return 1;
}
static ssl_relay(accSSL,accfd,conSSL,confd)
	SSL *accSSL,*conSSL;
{	int fdv[2],rfdv[2],nready,rcc,wcc;
	char buf[8*1024];

	fdv[0] = accfd;
	fdv[1] = confd;

	for(;;){
		nready = PollIns(0,2,fdv,rfdv);
		if( nready <= 0 )
			break;

		if( rfdv[0] ){
			if( accSSL )
				rcc = SSL_read(accSSL,buf,sizeof(buf));
			else	rcc = read(accfd,buf,sizeof(buf));
			if( rcc <= 0 )
				break;
			if( conSSL )
				wcc = SSL_write(conSSL,buf,rcc);
			else	wcc = write(confd,buf,rcc);
		}
		if( rfdv[1] ){
			if( conSSL )
				rcc = SSL_read(conSSL,buf,sizeof(buf));
			else	rcc = read(confd,buf,sizeof(buf));
			if( rcc <= 0 )
				break;

			if( accSSL )
				wcc = SSL_write(accSSL,buf,rcc);
			else	wcc = write(accfd,buf,rcc);
		}
	}
}
static HTTP_CAresp(fd,certfile)
	char *certfile;
{	FILE *tc,*cfp;
	X509 *cert;
	BIO *in,*out;

	tc = fdopen(fd,"w");
	cfp = fopen(certfile,"r");
	if( cfp == NULL )
		return -1;

	fprintf(tc,"HTTP/1.0 200 ok\r\n");
	fprintf(tc,"MIME-Version: 1.0\r\n");
	fprintf(tc,"Content-Type: application/x-x509-ca-cert\r\n");
	fprintf(tc,"\r\n");

	in = BIO_new_fp(cfp,BIO_NOCLOSE);
	cert = PEM_read_bio_X509(in,NULL,NULL);
	out = BIO_new_fp(tc,BIO_NOCLOSE);
	i2d_X509_bio(out,cert);

	BIO_free(in);
	BIO_free(out);
	fclose(tc);
	return 0;
}
static CArequest(accfd,isHTTP,certfile)
	int *isHTTP;
	char *certfile;
{	char method[8],line[1024],url[1024];
	int rcc;

	setNonblockingIO(accfd,1);
	rcc = RecvPeek(accfd,method,6);
	setNonblockingIO(accfd,0);

	if( rcc <= 0 )
		return 0;

	method[rcc] = 0;

	if( strncmp(method,"GET ",4) == 0 ){
		setNonblockingIO(accfd,1);
		rcc = RecvPeek(accfd,line,16);
		setNonblockingIO(accfd,0);
		line[rcc] = 0;

		wordscan2(line+4,url,sizeof(url));
		if( strcmp(url,"/-/ca.der") == 0 ){
			HTTP_CAresp(0,certfile);
			ERROR("sent cert");
			return 1;
		}
		*isHTTP = 1;
	}else
	if( strncmp(method,"HEAD ",5) == 0 || strncmp(method,"POST ",5) == 0 )
		*isHTTP = 1;
	return 0;
}

static int   do_accSSL = 0;
static int   do_conSSL = 0;
static int   do_bareHTTP = 0;
static int   do_showCERT = 0;
static char *sv_key  = "server-key.pem";
static char *sv_cert = "server-cert.pem";
static char *cl_key  = "client-key.pem";
static char *cl_cert = "client-cert.pem";
static char *cipher_list = NULL;
static int   cl_auth = 0;
static int   cl_vrfy = SSL_VERIFY_PEER;

main(ac,av)
	char *av[];
{	int ai;
	char *arg;
	int accfd,confd;
	SSL_CTX *ctx;
	SSL *accSSL,*conSSL;
	char *env,*getenv();
	int fdv[2],rfdv[2];

	CFI_init(ac,av);
	if( env = getenv("CFI_TYPE") ){
		if( strcmp(env,"FCL") == 0 ){
			DEBUG("CFI_TYPE=%s: -ac is assumed\n",env);
			do_accSSL = 1;
		}else
		if( strcmp(env,"FSV") == 0 || strcmp(env,"FMD") == 0 ){
			DEBUG("CFI_TYPE=%s: -co is assumed\n",env);
			do_conSSL = 1;
		}
	}

	PID = getpid();
	if( (client_host = getenv("REMOTE_HOST")) == 0 )
		client_host = "?";

	accfd = dup(0);
	confd = dup(1);

	if( env = getenv("SSL_CIPHER") ) cipher_list = env;

	if( env = getenv("SSL_CERT_FILE") )
		sv_cert = sv_key = cl_cert = cl_key = env;

	if( env = getenv("SSL_SERVER_KEY_FILE" ) ) sv_key  = env;
	if( env = getenv("SSL_SERVER_CERT_FILE") ) sv_cert = env;

	if( env = getenv("SSL_CLIENT_KEY_FILE" ) ) cl_key  = env;
	if( env = getenv("SSL_CLIENT_CERT_FILE") ) cl_cert = env;

	for( ai = 1; ai < ac; ai++ ){
		arg = av[ai];
		if( strncmp(arg,"-ac",3) == 0 ){
			do_accSSL = 1;
		}else
		if( strncmp(arg,"-co",3) == 0 ){
			do_conSSL = 1;
		}else
		if( strncmp(arg,"-ht",3) == 0 ){
			do_bareHTTP = 1;
		}else
		if( strncmp(arg,"-show",3) == 0 ){
			do_showCERT = 1;
		}else
		if( strcmp(arg,"-client_auth") == 0 ){
			cl_auth = 1;
		}else
		if( strcmp(arg,"-client_verify") == 0 ){
			cl_auth = 1;
			cl_vrfy |= SSL_VERIFY_FAIL_IF_NO_PEER_CERT;
		}else
		if( strcmp(arg,"-cipher") == 0 ){
			if( ai + 1 < ac )
				cipher_list = av[++ai];
		}else
		if( strcmp(arg,"-cert") == 0 ){
			if( ai + 1 < ac )
				sv_cert = sv_key = cl_cert = cl_key = av[++ai];
		}
	}

	accSSL = NULL;
	conSSL = NULL;

	if( do_conSSL || do_accSSL )
		ERROR("start");

	fdv[0] = accfd;
	fdv[1] = confd;

	if( do_bareHTTP ){
		int isHTTP;
		if( 0 < PollIns(100,2,fdv,rfdv) && 0<rfdv[0] && rfdv[1] <= 0 ){
			isHTTP = 0;
			if( CArequest(accfd,&isHTTP,sv_cert) )
				return 0;
			if( isHTTP ){
				 /* ... through raw HTTP request ...
				do_accSSL = 0;
				 */
			}
		}
	}

	if( do_conSSL ){
		ctx = ssl_new();
		if( cipher_list )
			SSL_CTX_set_cipher_list(ctx,cipher_list);
		if( 0 <= open(cl_key ,0) && 0 <= open(cl_cert,0) )
		ssl_keycert(ctx,cl_key ,cl_cert);
		conSSL = ssl_conn(ctx,confd);
		if( conSSL == NULL )
			return -1;
	}

	if( do_accSSL ){
		ctx = ssl_new();
		if( cipher_list )
			SSL_CTX_set_cipher_list(ctx,cipher_list);
		if( ssl_keycert(ctx,sv_key,sv_cert) < 0 )
			return -1;

		if( cl_auth )
			SSL_CTX_set_verify(ctx,cl_vrfy,verify_callback);

		accSSL = ssl_acc(ctx,accfd);
		if( accSSL == NULL )
			return -1;
	}

	if( conSSL )
		ssl_prcert(conSSL,do_showCERT,NULL,  accfd,"server");
	if( accSSL )
		ssl_prcert(accSSL,do_showCERT,accSSL,accfd,"client");

	ssl_relay(accSSL,accfd,conSSL,confd);

	if( do_conSSL || do_accSSL )
		ERROR("done");
	return 0;
}
