/* regular dialup with reconnect */
/* By Jeff Jackowski       */
/*    jeffj@ro.com         */
/*    http://ro.com/~jeffj */
/* This script will make the computer remotely dial up an ISP on demand */
/* Sequence of events:
	Spawn the OS/2 dialer to connect to the network
		The dialer is a text based dialer that the graphical dialer uses
		The dialer is included with Warp Connect and Warp v4.
	Wait for the dialer to connect
		75 seconds (mine is slow)
	Check the connection
	Dial again until connection is made
	Run the command given on the comand line
*/

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
signal on halt

TestConnect = "@ping ro.com 1 1 | RxQueue"
  /* change "ro.com" to the domain name of your service provider */

newq = RxQueue("create")
Call RxQueue 'set', newq
'@echo off'
conn = 0
/***** Connection loop *****/
do until conn = 1
  /* connect to ISP */
  say 'Dialing network'
  'start "dialppp" /b /c /min dialppp'  /* runppp is separate from this script because it has a long line */
  /* wait for connection */
  call SysSleep 70
  /* test connection */
  TestConnect newq
  parse upper pull appname stat host hname
  call Flush
  if stat = 'UNKNOWN' then do
    conn = 0
    say 'Connection not made, trying again'
    call SysSleep 120  /* wait for PPP dialer to terminate */
  end
  else do
    conn = 1
    say 'Connected to network'
  end
end

/***** Connected *****/
/* run connection command */
parse arg stuff
if stuff <> '' then do
  say 'Running command: 'stuff
  '@detach 'stuff
end
else say 'No connect command given'

Call RXQueue "delete", newq
exit

Flush:
  /* flush queue */
  Do While Queued() > 0
    Parse Pull .
  end
  return

halt:
   Call RXQueue "delete", newq
   Exit  /* Rexx */
