/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.StringTokenizer;

public class Throwable
implements Serializable {
    private transient Object backtrace;
    private String detailMessage;
    private static final long serialVersionUID = -3042686055658047285L;
    private static boolean initialized = false;
    private static String synchronizer = "boo";
    private static int trace = 0;
    public static final int OFF = 0;
    public static final int ON = 1;
    public static final int EX = 2;
    public static final int INC = 3;
    private static int[] exceptionHashCodes;
    private static String[] exceptionStrings;
    private static long timetostart;
    private static boolean delayactive;

    public Throwable() {
        this(null);
    }

    public Throwable(String string) {
        this.detailMessage = string;
        this.doTrace();
    }

    void doTrace() {
        block20: {
            this.fillInStackTrace();
            String string = synchronizer;
            synchronized (string) {
                if (!initialized) {
                    Throwable.initialize();
                }
            }
            if (delayactive) {
                if (System.currentTimeMillis() > timetostart) {
                    delayactive = false;
                } else {
                    return;
                }
            }
            boolean bl = false;
            switch (trace) {
                case 0: {
                    bl = false;
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                case 2: 
                case 3: {
                    boolean bl2 = false;
                    int n = this.getClass().getName().hashCode();
                    int n2 = 0;
                    while (n2 < exceptionHashCodes.length) {
                        if (exceptionHashCodes[n2] == n) {
                            bl2 = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!bl2) {
                        Class<?>[] classArray = this.getClass().getInterfaces();
                        int n3 = 0;
                        block11: while (n3 < classArray.length) {
                            n = classArray[n3].getName().hashCode();
                            int n4 = 0;
                            while (n4 < exceptionHashCodes.length) {
                                if (exceptionHashCodes[n4] == n) {
                                    bl2 = true;
                                    break block11;
                                }
                                ++n4;
                            }
                            ++n3;
                        }
                    }
                    bl = trace == 2 ^ bl2;
                    break;
                }
                default: {
                    System.err.println("Logic error. Exception trace setting has an unknown setting: " + trace);
                }
            }
            if (!bl) break block20;
            try {
                this.writeTrace();
            }
            catch (Throwable throwable) {}
        }
    }

    public native Throwable fillInStackTrace();

    public static String[] getExceptionList() {
        return exceptionStrings == null ? new String[]{} : exceptionStrings;
    }

    public String getLocalizedMessage() {
        return this.getMessage();
    }

    public String getMessage() {
        return this.detailMessage;
    }

    public static int getTrace() {
        return trace;
    }

    private static void initialize() {
        Object object;
        Object object2;
        initialized = true;
        String string = null;
        string = System.getProperty("enableExceptionTrace");
        if (string == null) {
            trace = 0;
            System.out.println("Exception trace is installed but disabled because the property 'enableExceptionTrace' is not set.");
            System.err.println("Exception trace is installed but disabled because the property 'enableExceptionTrace' is not set.");
            return;
        }
        if (string.equalsIgnoreCase("off") || string.equalsIgnoreCase("false")) {
            trace = 0;
            System.out.println("Exception trace is installed but disabled because the property 'enableExceptionTrace' is set to " + string);
            System.err.println("Exception trace is installed but disabled because the property 'enableExceptionTrace' is set to " + string);
            return;
        }
        if (string.equalsIgnoreCase("on") || string.equalsIgnoreCase("true")) {
            trace = 1;
            System.out.println("Exception trace is installed and enabled.");
            System.err.println("Exception trace is installed and enabled.");
            Throwable.setDelay();
            return;
        }
        if (string.toLowerCase().startsWith("ex")) {
            trace = 2;
        } else if (string.toLowerCase().startsWith("inc")) {
            trace = 3;
        } else {
            System.err.println("The property 'enableExceptionTrace' may not be set to: " + string + ".\n" + "The only accepted values are: off/false, on/true, exclude, include\n" + "Exception tracing is disabled.  Please correct and retry\n");
            trace = 0;
            return;
        }
        String string2 = null;
        File file = null;
        string2 = System.getProperty("exceptionsFile");
        if (string2 == null) {
            object2 = File.separator;
            object = String.valueOf(object2) + "properties" + (String)object2 + "exceptions.txt";
            System.out.println("The property 'exceptionsFile' is not set... attempting default value <WAS_ROOT>" + (String)object);
            System.err.println("The property 'exceptionsFile' is not set... attempting default value <WAS_ROOT>" + (String)object);
            String string3 = System.getProperty("WAS_ROOT");
            if (string3 == null) {
                System.err.println("Property WAS_ROOT is not set.  Try java -DWAS_ROOT=C:\\WebSphere\\AppServer .... ");
            } else {
                string2 = String.valueOf(string3) + (String)object2 + "properties" + (String)object2 + "exceptions.txt";
            }
        }
        if (string2 == null) {
            trace = trace == 2 ? 1 : 0;
            System.err.println("Error: exceptions list file name could not be obtained.\nException tracing is now defaulted to " + (trace == 0 ? "false" : "true"));
            if (trace == 1) {
                Throwable.setDelay();
            }
            return;
        }
        System.err.println("Using exceptions list file name: " + string2);
        file = new File(string2);
        if (!file.isFile()) {
            trace = trace == 2 ? 1 : 0;
            System.err.println("Error opening \"exceptionsFile\" = " + string2 + ".\n" + "Exception tracing is now defaulted to " + (trace == 0 ? "false" : "true"));
            if (trace == 1) {
                Throwable.setDelay();
            }
            return;
        }
        object2 = null;
        object = new ArrayList();
        try {
            try {
                object2 = new BufferedReader(new FileReader(file));
                String string4 = null;
                while ((string4 = ((BufferedReader)object2).readLine()) != null) {
                    ((ArrayList)object).add(string4);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Unable to find file: " + file.toString());
            }
            catch (IOException iOException) {
                System.err.println("IO exception while reading file: " + file.toString());
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (object2 != null) {
                    ((BufferedReader)object2).close();
                }
            }
            catch (IOException iOException) {
                System.err.println("Error closing file");
            }
            throw throwable;
        }
        try {
            if (object2 != null) {
                ((BufferedReader)object2).close();
            }
        }
        catch (IOException iOException) {
            System.err.println("Error closing file");
        }
        if (((ArrayList)object).size() == 0) {
            trace = trace == 2 ? 1 : 0;
            System.err.println("Error getting exception list from file.\nException tracing is now defaulted to " + (trace == 0 ? "false" : "true"));
            if (trace == 1) {
                Throwable.setDelay();
            }
            return;
        }
        Throwable.updateExceptions(((ArrayList)object).toArray());
        if (trace != 0) {
            Throwable.setDelay();
        }
    }

    public void printStackTrace() {
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.println(this);
            this.printStackTrace0(System.err);
        }
    }

    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            printStream.println(this);
            this.printStackTrace0(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            printWriter.println(this);
            this.printStackTrace0(printWriter);
        }
    }

    private native void printStackTrace0(Object var1);

    static void setDelay() {
        String string = null;
        string = System.getProperty("enableExceptionTraceDelay");
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                timetostart = System.currentTimeMillis() + (long)n * 1000L;
                delayactive = true;
            }
            catch (Exception exception) {
                System.out.println("The property enableExceptionTraceDelay must be a valid integer. " + string + " is not valid!");
                System.err.println("The property enableExceptionTraceDelay must be a valid integer. " + string + " is not valid!");
                exception.printStackTrace();
            }
        }
        if (delayactive) {
            System.err.println("Exception trace delay is enabled and exception tracing will start at: " + new Date(timetostart));
        } else {
            System.err.println("Exception trace delay is not enabled.\n\tIf you would like to use exception tracing with a delay [from process start time]\n\tspecify -DenableExceptionTraceDelay=<delay_in_seconds>");
        }
    }

    public static int setTrace(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                trace = n;
                break;
            }
            default: {
                System.err.println("Attempt to set exception trace to an invalid value: " + n + "\n" + "trace setting unchanged (" + trace + ")");
            }
        }
        return trace;
    }

    public String toString() {
        String string = this.getClass().getName();
        String string2 = this.getLocalizedMessage();
        return string2 != null ? String.valueOf(string) + ": " + string2 : string;
    }

    public static void updateExceptions(Object[] objectArray) {
        if (objectArray == null) {
            objectArray = new String[]{};
        }
        System.err.println("new exception list length = " + objectArray.length);
        if (objectArray.length == 0) {
            exceptionHashCodes = null;
            exceptionStrings = null;
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(7);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(7);
        String string = null;
        Object var4_4 = null;
        StringTokenizer stringTokenizer = null;
        int n = 0;
        while (n < objectArray.length) {
            stringTokenizer = new StringTokenizer((String)objectArray[n], "\b\t\f\n ");
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if ((string = string.trim()).length() < 2) continue;
                System.err.println("Adding Class to HashCode = " + string);
                arrayList2.add(new Integer(string.hashCode()));
                arrayList.add(string);
            }
            ++n;
        }
        System.err.println("HashCode size = " + arrayList2.size());
        System.err.println("stringList size = " + arrayList.size());
        if (arrayList2.size() == 0) {
            exceptionHashCodes = null;
            exceptionStrings = null;
            if (trace == 0 || trace == 1) {
                System.err.println("Error exception list is empty it doesn't matter since trace is " + (trace == 0 ? "off." : "on."));
                return;
            }
            trace = trace == 2 ? 1 : 0;
            System.err.println("Error: exceptions list is empty.\nException tracing is now defaulted to " + (trace == 0 ? "false" : "true"));
            return;
        }
        exceptionStrings = new String[arrayList.size()];
        System.arraycopy(arrayList.toArray(), 0, exceptionStrings, 0, exceptionStrings.length);
        exceptionHashCodes = new int[arrayList2.size()];
        int n2 = 0;
        while (n2 < exceptionHashCodes.length) {
            Throwable.exceptionHashCodes[n2] = (Integer)arrayList2.get(n2);
            ++n2;
        }
        if (trace == 0 || trace == 1) {
            return;
        }
        System.err.println("Exception trace is installed and set to " + (trace == 2 ? "ex" : "in") + "clude the following exception" + (exceptionStrings.length == 1 ? ":" : "s:"));
        int n3 = 0;
        while (n3 < exceptionStrings.length) {
            System.err.println("\t" + exceptionStrings[n3] + "\thash = " + exceptionHashCodes[n3]);
            ++n3;
        }
        System.err.println("\n");
    }

    public void writeTrace() {
        if (!(this instanceof EmptyStackException)) {
            long l = System.currentTimeMillis();
            System.out.println(">>> Exception " + this.toString() + " at: " + l);
            System.err.println(">>> Exception " + this.toString() + " at: " + l);
            this.printStackTrace();
            System.out.println(">>> End exception " + this.toString() + " at: " + l);
            System.err.println(">>> End exception " + this.toString() + " at: " + l);
        }
    }
}

