/*--------------------------------------------------------------------------*/
/*        OS/2 2.1 / WARP REX Driver for IBM TCP/IP version 2.0 / IAK       */
/*                                                                          */
/*                            LOGNCRIS.CMD                                  */
/*                                                                          */
/*            ..................................................            */
/*                                                                          */
/* Sample attachment script for dialing into a CRIS Point of Presence       */
/* server in order to establish a SLIP connection.  This script should be   */
/* specified on page 1 in the Login Script field for connections via SlipPM */
/*                                                                          */
/*       YOU WILL NEED THE FOLLOWING FOR YOUR ADD PROVIDER CHANGES          */
/*       Login Script: logncris.cmd 999-9999 loginid@SLIP password          */
/*                                                                          */
/* which would then feed the "999-9999" command to the modem, followed      */
/* by the login id and password once the connection is established.         */
/*--------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------*/
/*                   Initialization and Main Script Code                    */
/*--------------------------------------------------------------------------*/

parse arg interface , dialcmd username password

cr='0d'x
crlf='0d0a'x
call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'
'mode.com COM2,,,,,,DTR=ON'

/*--------------------------------------------------------------------------*/

say ''
say 'CRIS SLIP Connection Script ' , 
'(interface' interface')'
say 'Resetting Modem'
say 'Now Dialing...'
phoneresult = 2
trys = 1

do while trys < 5 & phoneresult > 1
 call placecall
end

if phoneresult > 1
 then
 exit 99
  
  call send '@D' || cr
  call waitfor 'user:' ; call flush_receive 'echo'
  call send username || cr
  call waitfor 'Password:' ; call flush_receive 'echo'
  call send password || cr
  call flush_receive 'echo'
  say 'SLIP Connection Established'
  cris_address = 192.0.2.1
  os2_address = 199.3.12.9
  say 'Configuring local address =' os2_address
  'ifconfig sl0' os2_address cris_address 'netmask 255.255.255.0'
  'route add default' cris_address '1'

 exit 0

/*--------------------------------------------------------------------------*/

send:

   parse arg sendstring
   call slip_com_output interface , sendstring

   return

/*--------------------------------------------------------------------------*/

placecall:
 say 'Try #' trys
 say 'No Connection Yet'
 call mdmreset
 call send 'atdt' dialcmd || cr
 call waitfor3 'ARQ', 'BUSY' , 'NO CARRIER' ; call waitfor crlf
 phoneresult = stringchosen
 trys = trys + 1
 call flush_receive ''
return

/*--------------------------------------------------------------------------*/

waitfor:

   parse arg waitstring , timeout

   if timeout = '' then
     timeout = 5000    /* L O N G   delay if not specified */
   waitfor_buffer = '' ; done = -1; curpos = 1
   ORI_TIME=TIME('E')

   if (remain_buffer = 'REMAIN_BUFFER') then do
      remain_buffer = ''
   end

   do while (done = -1)
      if (remain_buffer \= '') then do
         line = remain_buffer
         remain_buffer = ''
       end
       else do
         line = slip_com_input(interface,,10)
      end
      waitfor_buffer = waitfor_buffer || line
      index = pos(waitstring,waitfor_buffer)
      if (index > 0) then do
         remain_buffer = substr(waitfor_buffer,index+length(waitstring))
         waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
         done = 0
      end
      call charout , substr(waitfor_buffer,curpos)
      curpos = length(waitfor_buffer)+1
      if ((done \= 0) & (TIME('E')>timeout)) then do
        call lineout , ' WAITFOR: timed out '
        done = 1
       end
   end
   timeout=0
   RC=done
 return RC

/*--------------------------------------------------------------------------*/

mdmreset:

call SysSleep 2
call flush_receive ''
call send 'AT&F' || cr
call waitfor 'OK', 5 ; call flush_receive ''
call send 'ATHZ0' || cr
call waitfor 'OK', 5 ; call flush_receive ''
 if RC = 1 then do
    call lineout , 'Modem not resetting... Trying again'
    call send '+++'
    call waitfor 'OK'
    call send 'ATHZ' || cr
    call waitfor 'OK', 3
  end

return

/*--------------------------------------------------------------------------*/

flush_receive:

   parse arg echo

   if (echo \= '') & (length(remain_buffer) > 0) then do
      call charout , remain_buffer
      remain_buffer = ''
   end

   do until line = ''
     line = slip_com_input(interface,,100)
     if echo \= '' then
        call charout , line
   end

   return
   
/*--------------------------------------------------------------------------*/

waitfor3:

   parse arg waitstring1 , waitstring2 , waitstring3 , timeout
   waitfor_buffer = '' ; done = 0 ; curpos = 1
   if (remain_buffer = 'REMAIN_BUFFER') then do
      remain_buffer = ''
   end
   do while done = 0
      if (remain_buffer \= '') then do
         line = remain_buffer
	 remain_buffer = ''
      end
      else do
         line = slip_com_input(interface)
      end
      waitfor_buffer = waitfor_buffer || line
      index1 = pos(waitstring1,waitfor_buffer)
      index2 = pos(waitstring2,waitfor_buffer)
      index3 = pos(waitstring3,waitfor_buffer)
      if (index1 > 0) then do
         remain_buffer = substr(waitfor_buffer,index1+length(waitstring1))
	 waitfor_buffer = delstr(waitfor_buffer,index1+length(waitstring1))
         stringchosen = 1
         done = 1
      end
      else do
	if (index2 > 0) then do
		remain_buffer = substr(waitfor_buffer,index2+length(waitstring2))
		waitfor_buffer = delstr(waitfor_buffer,index2+length(waitstring2))
		stringchosen = 2
		done = 1
	end
	else do
		if (index3 > 0) then do
		remain_buffer = substr(waitfor_buffer,index3+length(waitstring3))
		waitfor_buffer = delstr(waitfor_buffer,index3+length(waitstring3))
		stringchosen = 3
		done = 1	
		end
	end
      end

      call charout , substr(waitfor_buffer,curpos)
      curpos = length(waitfor_buffer)+1
    end

  return
