/*
  REXX Routine to sort Netscape bookmark file
  format:  bookmark f:dsn   ie.,  bookmark c:\ibmnet\bookmark.htm
  original bookmark.htm will be backed up in bookmark.sav.  Do not run exec
  a second time until you have tested Bookmarks using NETSCAPE (ie do not
  destroy your backup file before testing new file).

  Note: Output file will be double spaced but will work fine.  Netscape will
        eventually put it back in single spaced mode.  DO NO edit the
        bookmark.htm file.

  If you find this program useful do not hesitate to send $15.00 to:
     Ed Huband
     15220 Emory Ln
     Rockville MD 20853
     USA

  Changes:
    02/08/97: Original by Ed Huband   <huband@ibm.net>
*/

trace

parse arg dsn
do forever
  if dsn = '' then say 'Please enter full path and dataset name'
    else leave
  pull dsn
end

'echo off'

parse value dsn with dsnx '.' .
'copy ' dsn dsnx'.sav'
if rc <> 0 then exit

infile =  dsnx'.sav'
outfile = dsn
'erase' outfile    /*    clear outfile */

i = 0
do forever
  test = lines(infile)
  if test = 0 then leave  /*eof*/
  i=i+1
  inline.i = linein(infile)
end

isave = i
inline.0 = i
say isave 'lines in'

swapcnt = 0
dot = ''

do forever
swap = 'n'
  do i = 1 to inline.0 - 1
    parse upper value inline.i with first1  '>' . '>' rest1
    if first1 <> '    <DT' then iterate

    j = i + 1
    parse upper value inline.j with first2  '>' . '>' rest2
    if first2 <> '    <DT' then         /*  check for double spaced */
      do forever
        j = j + 1
        if j > inline.0 then leave
        parse upper value inline.j with first2  '>' . '>' rest2
        if first2 = '    <DT' then leave
      end

    if rest1 > rest2 then
      do
        swap = 'y'
        swapcnt = swapcnt + 1
        save = inline.i
        inline.i = inline.j
        inline.j = save
        lastswap = j
      end
  end
  inline.0 = lastswap
  if swap = 'n' then leave

  'cls'
  say ''
  say isave 'lines in'
  say ''
  say 'Sorting..please wait'
  dot = dot||'.'
  say dot

end

say 'Swap Count = 'swapcnt

do i = 1 to isave
  call lineout outfile,inline.i
end

call lineout outfile  /* close */
exit 0
