/*
  REXX Script to install BinSuk and create a desktop folder and objects.
*/

  appName="BinSuk 1.80"
  DefaultDir="C:\BinSuk"

  say'Unzipping the 'appName' distribution...'
  say''

  '@unzip -oC BinSuk.zip 1>nul 2>nul'

  if rc\=0 then do
    rc=errorSound(1)
    say'There has been an error in unzipping the 'appName' distribution archive!'
    say''
    say'Good luck!'
    say
    exit 1
    end /* if rc */

  SIGNAL ON ERROR NAME Err

  say'Installing 'appName'...'

  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs;

  Question:
    say''
    say'Where do you wish to copy the files for 'appName' ?'
    say'(e.g. 'DefaultDir')  '
    PARSE PULL path

    IF path = "" THEN path=DefaultDir

    say''
    say appName' files will be copied to 'path
    say''
    say'Press <return> to continue, <E> to enter a new location or'
    say'<C> to cancel.'
    pull answer

  if answer="C" then exit
  if answer="E" then signal Question

  if pos(':',path) \=2 then do
   say'Sorry, but this install routine requires that you enter a COMPLETE path,'
   say'including a legal drive assignment!'
   rc=erroSound(1)
   signal Question
   end /* if pos */

  if pos('\',path) \=3 then do
   say'Sorry, but 'appName' should not be installed to a root directory!'
   rc=erroSound(1)
   signal Question
   end /* if pos */

  parse var path drive '\' dir.1 '\' dir.2 '\' dir.3 '\' dir.4 '\' dir.5 '\' dir.6

  rc=sysDriveInfo(drive)
  if rc='' then do
    say'Sorry, not able to find the 'drive' drive!'
    say''
    rc=errorSound(1)
    signal Question
    end /* if rc */

  say'Creating the target path: 'path
  say''
  NewDir=drive

  do i = 1 to 6
    if dir.i='' then leave
    NewDir=NewDir||'\'||dir.i
    rc=SysMkDir(NewDir)
    if rc\=0 then leave
    end /* do i */

  if rc\= 0 then do
    say"Sorry, there's a problem creating the supplied path: "path
    say
    signal Question
    end

  say'Copying the 'appName' files to 'path
  '@copy *.* 'path' 1>nul 2>nul'

  path=path||'\'

  say "Creating the 'appName' main folder..."
  call SysCreateObject "WPFolder", appName, "<WP_DESKTOP>",        "OBJECTID=<BINSUKFOLDER>;    ICONVIEW=NONGRID,NORMAL;ALWAYSSORT=YES;ICONFONT=10.Helv;BACKGROUND=" || path || "back.bmp,T;ICONFILE=" || path || "FOLDER.ICO", "REPLACE"
  call SysCreateObject "WPFolder", "Utility programs", "<BINSUKFOLDER>", "OBJECTID=<BINSUKUTILFOLDER>;ICONVIEW=NONGRID,NORMAL;ALWAYSSORT=YES;ICONFONT=10.Helv;BACKGROUND=" || path || "back.bmp,T", "REPLACE"
  call SysCreateObject "WPFolder", "Information",      "<BINSUKFOLDER>", "OBJECTID=<BINSUKINFOFOLDER>;ICONVIEW=NONGRID,NORMAL;ALWAYSSORT=YES;ICONFONT=10.Helv;BACKGROUND=" || path || "back.bmp,T", "REPLACE"
  call SysCreateObject "WPFolder", "Binaries",         "<BINSUKFOLDER>", "OBJECTID=<BINSUKBINARIES>;  ICONVIEW=NONGRID,NORMAL;ALWAYSSORT=YES;ICONFONT=10.Helv;BACKGROUND=" || path || "back.bmp,T", "REPLACE"

  say "Creating program objects in the BinSuk utility folder..."
  call SysCreateObject "WPProgram", "BinSuk.cmd",      "<BINSUKUTILFOLDER>", "EXENAME=" || path || "BINSUK.CMD;     STARTUPDIR=" || path || ";ICONVIEW=NONGRID,NORMAL;ALWAYSSORT=YES;", "REPLACE"
  call SysCreateObject "WPProgram", "BSParse.cmd",     "<BINSUKUTILFOLDER>", "EXENAME=" || path || "BSPARSE.CMD;    STARTUPDIR=" || path || ";ICONVIEW=NONGRID,NORMAL;ALWAYSSORT=YES;", "REPLACE"
  call SysCreateObject "WPProgram", "AgeDupeLogs.cmd", "<BINSUKUTILFOLDER>", "EXENAME=" || path || "AGEDUPELOGS.CMD;STARTUPDIR=" || path || ";PARAMETERS=" || " 60 " || ";ICONVIEW=NONGRID,NORMAL;ALWAYSSORT=YES;", "REPLACE"
  call SysCreateObject "WPProgram", "doit.cmd",        "<BINSUKUTILFOLDER>", "EXENAME=" || path || "DOIT.CMD;       STARTUPDIR=" || path || ";ICONVIEW=NONGRID,NORMAL;ALWAYSSORT=YES;", "REPLACE"
  call SysCreateObject "WPProgram", "MakeList.cmd",    "<BINSUKUTILFOLDER>", "EXENAME=" || path || "MAKELIST.CMD;   STARTUPDIR=" || path || ";ICONVIEW=NONGRID,NORMAL;ALWAYSSORT=YES;", "REPLACE"

  say "Creating information objects in the BinSuk information folder..."
  call SysCreateObject "WPProgram", "File_ID.DIZ",          "<BINSUKINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || path || "FILE_ID.DIZ",              "REPLACE"
  call SysCreateObject "WPProgram", "BinSuk.Read.Me",       "<BINSUKINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || path || "BINSUK.READ.ME",           "REPLACE"
  call SysCreateObject "WPProgram", "BinSuk.trash",         "<BINSUKINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || path || "BINSUK.TRASH",             "REPLACE"
  call SysCreateObject "WPProgram", "BinSuk.fetch",         "<BINSUKINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || path || "BINSUK.FETCH",             "REPLACE"
  call SysCreateObject "WPProgram", "BSParse.txt",          "<BINSUKINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || path || "BSPARSE.TXT",              "REPLACE"
  call SysCreateObject "WPProgram", "The Future Plans",     "<BINSUKINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || path || "GOING.TO.DO.THIS.SOMEDAY", "REPLACE"
  call SysCreateObject "WPProgram", "GNU COPYRIGHT LICENSE","<BINSUKINFOFOLDER>", "EXENAME=E.EXE;PARAMETERS=" || path || "COPYING.TXT",              "REPLACE"

  call SysIni , 'BinSuk', 'InstallDirectory', path

  say'Installation completed - 'appName
  say''

  exit 0

Err:
  say ""
  say "An error has occured. Possible causes are:"
  say ""
  say " - You have interrupted installation by pressing CTRL-BREAK."
  say " - A file is missing in the package. Try to unpack the archive file again."
  say " - A file cannot be replaced because it is in use. Make sure the program"
  say "   you're about to install is not running currently."
  say ""
  say "Please try again later."
exit 1

errorSound: procedure

  SOUND=arg(1)

  if SOUND = 1 then do
    call beep 400, 25
    call beep 500, 25
    end /* if sound */

    return 0

