/* sys/time.h (emx+gcc) */

#if !defined (_SYS_TIME_H)
#define _SYS_TIME_H

#include <time.h>

#if defined (__cplusplus)
extern "C" {
#endif

#if !defined (_TIMEVAL)
#define _TIMEVAL
struct timeval
{
  long tv_sec;
  long tv_usec;
};
#endif

#if !defined (_TIMEZONE)
#define _TIMEZONE
struct timezone
{
  int tz_minuteswest;
  int tz_dsttime;
};
#endif

#define    DST_NONE    0    /* not on dst */
#define    DST_USA        1    /* USA style dst */
#define    DST_AUST    2    /* Australian style dst */
#define    DST_WET        3    /* Western European dst */
#define    DST_MET        4    /* Middle European dst */
#define    DST_EET        5    /* Eastern European dst */
#define    DST_CAN        6    /* Canada */
#define    DST_GB        7    /* Great Britain and Eire */
#define    DST_RUM        8    /* Rumania */
#define    DST_TUR        9    /* Turkey */
#define    DST_AUSTALT    10    /* Australian style with shift in 1986 */

/*
 * Names of the interval timers, and structure
 * defining a timer setting.
 */
   #define    ITIMER_REAL    0
   #define    ITIMER_VIRTUAL    1
   #define    ITIMER_PROF    2

struct    itimerval {
    struct    timeval it_interval;    /* timer interval */
    struct    timeval it_value;    /* current value */
};

#define    timerisset(tvp)        ((tvp)->tv_sec || (tvp)->tv_usec)
#define    timercmp(tvp, uvp, cmp)    \
  (((tvp)->tv_sec == (uvp)->tv_sec && (tvp)->tv_usec cmp (uvp)->tv_usec) \
  || (tvp)->tv_sec cmp (uvp)->tv_sec)
#define    timerclear(tvp)        ((tvp)->tv_sec = (tvp)->tv_usec = 0)

int utimes (__const__ char *, __const__ struct timeval *);
int gettimeofday (struct timeval *, struct timezone *);
int settimeofday (__const__ struct timeval *, __const__ struct timezone *);

int _utimes (__const__ char *, __const__ struct timeval *);
int _gettimeofday (struct timeval *, struct timezone *);
int _settimeofday (__const__ struct timeval *, __const__ struct timezone *);

int _getitimer (int __which, struct itimerval *__value);
int getitimer (int __which, struct itimerval *__value);
int _setitimer (int __which, __const struct itimerval *__value, struct itimerval *__ovalue);
int setitimer (int __which, __const struct itimerval *__value, struct itimerval *__ovalue);

#if defined (__cplusplus)
}
#endif

#endif /* !defined (_SYS_TIME_H) */
