/*****************************************************************************/
/* FA Partners                                                               */
/* Copyright (c) FA Partner 1997, 1998                                       */
/*---------------------------------------------------------------------------*/
/* Name        : install.cmd                                                 */
/* Description : Installs the Bandit Tagger                                  */
/*---------------------------------------------------------------------------*/
/* 1997-08-10  | Created                                 | FB                */
/* 1997-08-27  | Inserted product support option.        | FB                */
/* 1997-11-07  | Aligned with Bandit Tagger v1.27a       | FB                */
/* 1997-11-10  | Promted user to overwrite old os2.tag   | FB                */
/* 1998-02-12  | Added creation of nested directories    | FB                */
/* 1998-02-12  | Added creation of Bandit Netscape icon  | FB                */
/* 1998-02-23  | Added creation of shadow in startup     | FB                */
/*             | folder                                  |                   */
/*****************************************************************************/

'@ECHO OFF'

call RxFuncAdd 'SysCreateObject', 'RexxUtil', 'SysCreateObject'
call RxFuncAdd 'SysCreateShadow', 'RexxUtil', 'SysCreateShadow'
call RxFuncAdd 'SysOpenObject'  , 'RexxUtil', 'SysOpenObject'
call RxFuncAdd 'SysMkDir'       , 'RexxUtil', 'SysMkDir'
call RxFuncAdd 'SysFileTree'    , 'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysIni'         , 'RexxUtil', 'SysIni'

Say 'Install the Bandit Tagger to :'
pull path
Say 'Use Bandit Tagger togther with :'
Say '1. Internet Adventure'
Say '2. SouthSide Software'
Say '3. MR/2 Internet Cruiser Edition for OS/2'
Say '4. Netscape/2'
Say '5. None of the above'

pull option

select
  when option = 1 then do
    xnews   = "Internet Adventurer v1.20 for OS/2 with Bandit Tagger v2.00"
    xmailer = "Internet Adventurer v1.20 for OS/2 with Bandit Tagger v2.00"
    parent  = "<INETADVFOLDER>"
  end
  when option = 2 then do
    xnews   = "PMINews 1.01a for OS/2 with Bandit Tagger v2.00"
    xmailer = "PMMail 1.95a for OS/2 with Bandit Tagger v2.00"
    parent  = "<PMMAILFLDR>"
  end
  when option = 3 then do
    xnews   = "MR/2 Internet Cruiser Edition for OS/2 v1.38 with Bandit Tagger v2.00"
    xmailer = "MR/2 Internet Cruiser Edition for OS/2 v1.38 with Bandit Tagger v2.00"
    parent  = "<WP_DESKTOP>"
  end
  when option = 4 then do
    xnews   = "Brought to you by OS/2 Warp"
    xmailer = "Brought to you by OS/2 Warp"
    parent = "<NETSCAPEFLDR>"
  end
  otherwise
    xnews   = "Brought to you by OS/2 Warp"
    xmailer = "Brought to you by OS/2 Warp"
    parent = "<WP_DESKTOP>"
end

rc = SysIni('bandit.in_', 'BANDIT_USER', 'X_MAILER', xmailer);
rc = SysIni('bandit.in_', 'BANDIT_USER', 'X_NEWS'  , xnews  );

position = 1;

do while (position <> 0)
  position = pos("\", path, position+1)
  if (position <> 0) then
    createPath = substr(path, 1, position-1)
  else
    createPath = substr(path, 1)
  rc = SysMkDir(createPath)
end

Say  'Place Bandit Tagger for Netscape in the start-up folder. (Y/N) ?';
Pull startupFolder

/* Avoid overwriting old inifiles. & os2.tag */
Call SysFileTree path'\os2.tag', 'fileStem', 'F';
if fileStem.0 <> 0 then do
  Say 'Do your want to overwrite the os2.tag file (Y/N) ?';
  Pull tagOverwrite
end

if (rc = 0 | rc = 5) then do
  'copy license.doc  'path'\license.doc'
  'copy bandit.exe   'path'\bandit.exe'
  'copy hookdll.dll  'path'\hookdll.dll'
  'copy st.exe       'path'\st.exe'
  'copy bandit.cmd   'path'\bandit.cmd'
  'copy netscape.ico 'path'\netscape.ico'
  'copy file_id.diz  'path'\file_id.diz'
  'copy bandit.doc   'path'\bandit.doc'
  'copy wysiwyg.ta_  'path'\wysiwyg.ta_'

  if fileStem.0 = 0 | tagOverwrite = 'Y' then
    'copy os2.tag     'path'\os2.tag'

  Call SysFileTree path'\bandit.ini', 'fileStem', 'F';

  if fileStem.0 = 0 then
    'copy bandit.in_  'path'\bandit.ini'


  rc = SysOpenObject(parent, "icon", "TRUE")


  rc = SysCreateObject("WPProgram", "Bandit Tagger", parent,,
                       "EXENAME="path"\bandit.exe;OBJECTID=<BANDIT>", "replace")
  if rc = 0 then
    rc = SysCreateObject("WPProgram", "Bandit Tagger", "<WP_DESKTOP>",,
                       "EXENAME="path"\bandit.exe;OBJECTID=<BANDIT>", "replace")

  rc = SysCreateObject("WPProgram", "Bandit Tagger for Netscape", parent,,
                       "EXENAME="path"\bandit.exe;OBJECTID=<BANDIT_NETSCAPE>;ICONFILE="path"\NETSCAPE.ICO;PARAMETERS=/n", "replace")

  if rc = 0 then
    rc = SysCreateObject("WPProgram", "Bandit Tagger for Netscape", "<WP_DESKTOP>",,
                         "EXENAME="path"\bandit.exe;OBJECTID=<BANDIT_NETSCAPE>;ICONFILE="path"\NETSCAPE.ICO;PARAMETERS=/n", "replace")

  if rc = 1  & startupFolder = 'Y' then
    rc = SysCreateShadow("<BANDIT_NETSCAPE>", "<WP_START>")
end
else
  Say 'Unable to create directories. Installation ended.'

exit
