/* REXX installation script for Auto WGet
 * Copyright (C) 1998-1999 by Dmitry A.Steklenev
 *
 * $Revision: 1.5.1.2 $
 */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse source os what program tail
dll = substr( program, 1, lastpos( "\", program )) || "awget.dll"

call RxFuncAdd 'AwLoadFuncs', dll, 'AwLoadFuncs'
call AwLoadFuncs

'@echo off'

if translate( value( "REXX_TRACE",, "OS2ENVIRONMENT" )) == "YES" then do
   trace intermediate
   trace results
end

CfgFile = value( "ETC",, "OS2ENVIRONMENT" )"\awget.cfg"

/*------------------------------------------------------------------
 * Initialization
 *------------------------------------------------------------------*/

say "Auto WGet Daemon $Revision: 1.5.1.2 $ Installation"
say "Copyright (C) 1998-1999 by Dmitry A.Steklenev"
say ""

call MsgRead "awget"

if MsgYesNo( "!!! "msg.msg_instin" "directory()) == 0 then
   exit

/*------------------------------------------------------------------
 * Create configuration file
 *------------------------------------------------------------------*/

call CfgRead CfgFile

if cfg.download == "." then do
   call charout, "!!! "msg.msg_downdir": "
   parse pull cfg.download
end

if cfg.use_desktop == 0 then
   cfg.use_desktop = (MsgYesNo( "!!! "msg.msg_usedesk ) == 1)

if cfg.logfile == "" then
   cfg.logfile = directory()"\ToDo\Info\awget.log"

if cfg.errorlog == "" then
   cfg.errorlog = directory()"\ToDo\Info\awget_error.log"

say; call CfgShow
say; pause
say

call CfgSave CfgFile
say  " "msg.msg_updcfg": "CfgFile

/*------------------------------------------------------------------
 * Create Folders and Objects
 *------------------------------------------------------------------*/

if SysOs2Ver() > "2.30" then
   FldClass = "WPUrlFolder"
else
   FldClass = "WPFolder"

call CreateObject FldClass  , "ToDo"   , directory() , "OBJECTID=<AWG_TODO>;"  ||,
                  "ICONFILE="directory()"\icon\todo.ico;"                      ||,
                  "DEFAULTVIEW=DETAILS;DETAILSTODISPLAY=0,1,7,8,12;DETAILSVIEW=NORMAL;", "U"
call CreateObject "WPFolder", "Info"   , "<AWG_TODO>", "OBJECTID=<AWG_INFO>;"  ||,
                  "ICONFILE="directory()"\icon\info.ico;"                      ||,
                  "DEFAULTVIEW=ICON", "U"
call CreateObject FldClass  , "Running", "<AWG_TODO>", "OBJECTID=<AWG_RUN>;"   ||,
                  "ICONFILE="directory()"\icon\run.ico;"                       ||,
                  "DEFAULTVIEW=DETAILS;DETAILSTODISPLAY=0,1,7,8,12;", "U"
call CreateObject FldClass  , "Done"   , "<AWG_TODO>", "OBJECTID=<AWG_DONE>;"  ||,
                  "ICONFILE="directory()"\icon\done.ico;"                      ||,
                  "DEFAULTVIEW=DETAILS;DETAILSTODISPLAY=0,1,7,8,12;", "U"
call CreateObject FldClass  , "Failed" , "<AWG_TODO>", "OBJECTID=<AWG_ERROR>;" ||,
                  "ICONFILE="directory()"\icon\failed.ico;"                    ||,
                  "DEFAULTVIEW=DETAILS;DETAILSTODISPLAY=0,1,7,8,12;", "U"

call CreateObject "WPShadow", "ToDo", "<WP_DESKTOP>",,
                  "SHADOWID=<AWG_TODO>", "R"

call CreateObject "WPProgram", "Auto WGet Daemon", "<WP_START>",,
                  "EXENAME="directory()"\AWGETD.CMD;MINIMIZED=YES;STARTUPDIR="directory()";" ||,
                  "OBJECTID=<AWG_DAEMON>;ICONFILE="directory()"\icon\awget.ico;", "R"
call CreateObject "WPProgram", "Add URL", "<AWG_INFO>",,
                  "EXENAME="directory()"\AWGADD.CMD;MINIMIZED=YES;STARTUPDIR="directory()';PARAMETERS="['msg.msg_enterurl']";' ||,
                  "OBJECTID=<AWG_ADD>;ICONFILE="directory()"\icon\add.ico;", "U"
call CreateObject "WPProgram", "Uninstall Auto WGet Daemon", "<AWG_INFO>",,
                  "EXENAME="directory()"\UNINSTL.CMD;STARTUPDIR="directory()";" ||,
                  "OBJECTID=<AWG_DEINST>;ICONFILE="directory()"\icon\uninstl.ico;", "R"

call CreateObject "WPShadow", "ToDo", "<AWG_TODO>",,
                  "SHADOWID=<AWG_ADD>;OBJECTID=<AWG_ADD_SHADOW>;", "R"

call CreateObject "WPProgram", "Readme (Russian)", "<AWG_INFO>" ,,
                  'EXENAME=E.EXE;PROGTYPE=PM;PARAMETERS="'directory()'\AWGET.RUS"', "R"
call CreateObject "WPProgram", "Readme (English)", "<AWG_INFO>" ,,
                  'EXENAME=E.EXE;PROGTYPE=PM;PARAMETERS="'directory()'\AWGET.ENG"', "R"
call CreateObject "WPProgram", "AWGet Configuration", "<AWG_INFO>" ,,
                  'EXENAME=E.EXE;PROGTYPE=PM;PARAMETERS='CfgFile, "R"

if SysOs2Ver() > "2.30" then do
   call CreateObject "WPUrl", "Auto WGet Daemon" || "0A"x || "Home Page (Russian)", "<AWG_INFO>",,
                    "URL=http://www.geocities.com/SiliconValley/Vista/7567/software/index.html", "R"
   call CreateObject "WPUrl", "Auto WGet Daemon" || "0A"x || "Home Page (English)", "<AWG_INFO>",,
                    "URL=http://www.geocities.com/SiliconValley/Vista/7567/software/english/index.html", "R"
end

if SysOs2Ver() > "2.30" then do
   say
   if MsgYesNo( "!!! "msg.msg_addtray ) == 1 then
      call SysSetObjectData "<WP_WARPCENTER>", "ADDTRAY=Auto WGet Daemon,<AWG_TODO>,<AWG_INFO>,<AWG_ADD>"
   say
end

/*------------------------------------------------------------------
 * Delete old files
 *------------------------------------------------------------------*/

old.1 = directory()"\vwin.eng"
old.2 = directory()"\vwin.exe"
old.3 = directory()"\awget.ico"
old.4 = directory()"\info.ico"
old.5 = directory()"\awget.msg"
old.0 = 5

do i = 1 to old.0
   if stream( old.i, "c", "query exists" ) \= "" then do
      '@del "'old.i'" 1> nul 2> nul'
   end
end

call SysDestroyObject "<AWG_LOCK>"
call SysSetObjectData "<AWG_DAEMON>", "OPEN=DEFAULT"

say " "msg.msg_started
say "Done!"

exit

/*------------------------------------------------------------------
 * Create object
 *------------------------------------------------------------------*/
CreateObject: procedure expose msg.

   parse arg class, objname, folder, prmstr, action

   rc = SysCreateObject( class, objname, folder, prmstr, action )

   objname = translate( objname, " ", "0D"x )
   objname = translate( objname, " ", "0A"x )

   if rc then
      say " "msg.msg_objdone || " "substr(class,1,12) || ": "objname"..."
   else
      say " "msg.msg_objerr  || " "substr(class,1,12) || ": "objname"..."

return rc


/*------------------------------------------------------------------
 * National Messages Procedures
 *------------------------------------------------------------------*/
MsgRead: procedure expose msg.

  parse arg msgfile
  parse source OS2 what msgpath

  msgfile = filespec( "disk", msgpath ) ||,
            filespec( "path", msgpath ) || msgfile

  country = strip( SysIni( "BOTH", "PM_National", "iCountry" ),, '0'x )
  country = right( country, 3, "0" )

  if stream( msgfile"."country, "c", "query exists" ) == "" then
     country = "001"

  msgfile = msgfile"."country
  rc = stream( msgfile, "C", "OPEN READ" )

  if rc \= "READY:" then do
     say "ERROR: Error open message file: "msgfile
     exit
  end

  do while lines(msgfile) > 0
     line = linein(msgfile)

     if line \= "" then do
        parse value line with id "=" msg

        id  = translate(strip(id))
        msg = strip(msg)

        i = pos( "\n", msg )
        do while i > 0
           msg = substr( msg, 1, i-1 ) || '0A0D'x || substr( msg, i+2 )
           i = pos( "\n", msg )
        end

        msg.id = msg
     end
  end

  rc = stream( msgfile, "C", "CLOSE" )

return

/*------------------------------------------------------------------
 * Get Yes or No
 *------------------------------------------------------------------*/
MsgYesNo: procedure expose msg.

   parse arg prompt
   ok = 0

   do until ok
      call charout, prompt"? "
      pull reply
      reply = left(reply,1)

      ok = (reply == "Y") |,
           (reply == "N") |,
           (pos( reply, msg.msg_yes ) > 0 ) |,
           (pos( reply, msg.msg_no  ) > 0 )

      if \ok then do
         say msg.msg_badyn
      end
   end

return (reply = "Y") | (pos( reply, msg.msg_yes ) > 0 )

/*------------------------------------------------------------------
 * Get Configuration
 *------------------------------------------------------------------*/
CfgRead: procedure expose cfg. msg.

  parse arg CfgFile

  cfg.download          = "."
  cfg.maximum_downloads = 3
  cfg.messages          = 1
  cfg.message_done      = ""
  cfg.message_error     = ""
  cfg.wget_parameters   = "-c -t 0 -w 30"
  cfg.scan_interval     = 60
  cfg.check_connection  = 0
  cfg.logfile           = ""
  cfg.errorlog          = ""
  cfg.use_desktop       = 0
  cfg.keep_failed       = 1
  cfg.keep_done         = 0

  rc = stream( CfgFile, "C", "OPEN READ" )

  do while lines(CfgFile) > 0
     parse value linein(CfgFile) with command "=" argument

     command = translate(strip(command))
     argument = strip(argument)

     select
        when command == "DOWNLOAD" then
             cfg.download = argument
        when command == "MAXIMUM_DOWNLOADS_SIMULTANEOUSLY" then
             cfg.maximum_downloads = argument
        when command == "MESSAGES" then
             cfg.messages = (argument == "1")
        when command == "WGET_PARAMETERS" then
             cfg.wget_parameters = argument
        when command == "SCAN_INTERVAL" then
             cfg.scan_interval = argument
        when command == "LOG_FILE" then
             cfg.logfile = argument
        when command == "ERROR_LOG" then
             cfg.errorlog = argument
        when command == "MESSAGE_DONE" then
             cfg.message_done = argument
        when command == "MESSAGE_ERROR" then
             cfg.message_error = argument
        when command == "CHECK_CONNECTION" then
             cfg.check_connection = (argument == "1")
        when command == "USE_DESKTOP" then
             cfg.use_desktop = (argument == "1")
        when command == "KEEP_FAILED_URL" then
             cfg.keep_failed = (argument == "1")
        when command == "KEEP_DONE_URL" then
             cfg.keep_done = (argument == "1")
        otherwise
     end
  end

  if right( cfg.download, 1 ) = "\" then
     cfg.download = left( cfg.download, length(cfg.download) - 1 )

  setlocal
  cfg.download = directory( cfg.download )
  endlocal

  if cfg.download == "" then do
     call LogPut cfg.errorlog, msg.msg_invdown
     cfg.download = "."
  end

  rc = stream( CfgFile, "C", "CLOSE" )
  cfg.file_date = stream( CfgFile, "C", "QUERY DATETIME" )

return

/*------------------------------------------------------------------
 * Show Configuration
 *------------------------------------------------------------------*/
CfgShow: procedure expose cfg. msg.

  say "*** "msg.msg_downdir  || ": "cfg.download
  say "*** "msg.msg_maxcon   || ": "cfg.maximum_downloads
  say "*** "msg.msg_show     || ": "cfg.messages

  if cfg.message_done \= "" then
     say "*** "msg.msg_done  || ": "cfg.message_done

  if cfg.message_error \= "" then
     say "*** "msg.msg_error || ": "cfg.message_error

  say "*** "msg.msg_interval || ": "cfg.scan_interval
  say "*** "msg.msg_chckconn || ": "cfg.check_connection
  say "*** "msg.msg_parm     || ": "cfg.wget_parameters
  say "*** "msg.msg_usedesk  || ": "cfg.use_desktop
  say "*** "msg.msg_keepfail || ": "cfg.keep_failed
  say "*** "msg.msg_keepdone || ": "cfg.keep_done

return

/*------------------------------------------------------------------
 * Save Configuration
 *------------------------------------------------------------------*/
CfgSave: procedure expose cfg. msg.

  parse arg CfgFile

  if stream( CfgFile, "C", "QUERY EXISTS" ) \= "" then
     "del "CfgFile

  rc = stream( CfgFile, "C", "OPEN WRITE" )

  rc = lineout( CfgFile, "download = "cfg.download )
  rc = lineout( CfgFile, "maximum_downloads_simultaneously = "cfg.maximum_downloads )
  rc = lineout( CfgFile, "messages = "cfg.messages )

  if cfg.message_done  \= "" then
     rc = lineout( CfgFile, "message_done  = "cfg.message_done  )

  if cfg.message_error \= "" then
     rc = lineout( CfgFile, "message_error = "cfg.message_error )

  rc = lineout( CfgFile, "log_file = "cfg.logfile )
  rc = lineout( CfgFile, "error_log = "cfg.errorlog )
  rc = lineout( CfgFile, "wget_parameters = "cfg.wget_parameters )
  rc = lineout( CfgFile, "scan_interval = "cfg.scan_interval )
  rc = lineout( CfgFile, "check_connection = "cfg.check_connection )
  rc = lineout( CfgFile, "use_desktop = "cfg.use_desktop )
  rc = lineout( CfgFile, "keep_failed_url = "cfg.keep_failed )
  rc = lineout( CfgFile, "keep_done_url = "cfg.keep_done )

  rc = stream( CfgFile, "C", "CLOSE" )

return

/*------------------------------------------------------------------
 * Check Configuration
 *------------------------------------------------------------------*/
CfgCheck: procedure expose cfg. msg.

  parse arg CfgFile

  if cfg.file_date \= stream( CfgFile, "C", "QUERY DATETIME" ) then do

     call LogPut cfg.logfile, msg.msg_readcfg
     call CfgRead CfgFile
     say
     call CfgShow
     say
  end

return

/*------------------------------------------------------------------
 * Write Log Record
 *------------------------------------------------------------------*/
LogPut: procedure expose cfg.

  parse arg logfile, message

  say " "message
  if logfile \= "" then do
     call lineout logfile, date()" "time()" -> "message
     rc = stream( logfile, "c", "close" )
  end

return

/*------------------------------------------------------------------
 * Append Log Record
 *------------------------------------------------------------------*/
LogAdd: procedure expose cfg.

  parse arg logfile, message

  if logfile \= "" then do
     call lineout logfile, date()" "time()" -> "message
     rc = stream( logfile, "c", "close" )
  end

return

