/* Auto WGet Daemon Termination
 * Copyright (C) 1999-2001 by Dmitry A.Steklenev
 *
 * $Id: awgstop.cms,v 1.9 2001/03/03 19:12:07 glass Exp $
 */

globals = "cfg. local. msg. sys. color. dir. jobs. job. plugins."

if translate( value( "AWGET_TRACE",, "OS2ENVIRONMENT" )) == "YES" then do
   call  value "AWGET_TRACE", "", "OS2ENVIRONMENT"
   trace intermediate
   trace results
end

call AwInit

cls
say color.bold  || "Auto WGet Daemon " || color.usual || "Version 1.6.1 (beta) Termination"
say color.usual || "Copyright (C) 1999-2001 by Dmitry A.Steklenev"
say color.usual || ""

call MsgRead "awgmsg"
call CfgRead
call AwStop

exit 0

/* $Id: init.cms,v 1.20 2001/04/16 13:47:54 glass Exp $ */

/*------------------------------------------------------------------
 * Initialization
 *------------------------------------------------------------------*/
AwInit: procedure expose (globals)

  if RxFuncQuery('SysLoadFuncs') then do
     call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
     call SysLoadFuncs
  end

  '@echo off'

  sys.config_file = value( "ETC",, "OS2ENVIRONMENT" )"\awget.cfg"
  sys.connected   = 1

  /* enable ANSI extended screen and keyboard control */
  '@ansi on > nul'

  color.brown   = "1B"x"[0;33m"
  color.red     = "1B"x"[1;31m"
  color.green   = "1B"x"[1;32m"
  color.yellow  = "1B"x"[1;33m"
  color.blue    = "1B"x"[1;34m"
  color.magenta = "1B"x"[1;35m"
  color.cyan    = "1B"x"[1;36m"
  color.white   = "1B"x"[1;37m"
  color.gray    = "1B"x"[0m"

  color.usual   = color.gray
  color.bold    = color.white
  color.error   = color.red
  color.info    = color.green
  color.debug   = color.brown

  /* known download utilites */

  sys.utils.0      = 2
  sys.utils.1.prog = wget.exe
  sys.utils.1.name = "GNU WGet"
  sys.utils.1.parm = '-c -t 10 -w 30 -P "%p" "%u"'
  sys.utils.2.prog = curl.exe
  sys.utils.2.name = "cURL"
  sys.utils.2.parm = '-y 300 -Y 1 -v -C - -o "%p/%f" "%u"'

  sys.utils.default.prog = sys.utils.1.prog
  sys.utils.default.name = sys.utils.1.name
  sys.utils.default.parm = sys.utils.1.parm

  /* service semaphores */

  sys.running = "$live$"
  sys.killing = "$stop$"
  sys.tqueue  = "$term$"
return

/* $Id: stop.cms,v 1.11 2001/04/12 11:32:32 glass Exp $ */

/*------------------------------------------------------------------
 * Stop Auto WGet Daemon
 *------------------------------------------------------------------*/
AwStop: procedure expose (globals)

  sys_running  = cfg.home'\'sys.running
  sys_killing  = cfg.home'\'sys.killing

  'del 'sys_running' /F 1>nul 2>nul'

  call lineout sys_killing, "Must die!"
  call charout, color.info || " "msg.wait_stopped"..."

  do 20 while stream( sys_running, 'c', 'query exist' ) \= ""
     call SysSleep  2
     call charout, "."
    'del 'sys_running' /F 1>nul 2>nul'
  end
  say ; say color.info || " "msg.stopped || color.usual

  rc = stream( sys_killing, 'c', 'close' )
 'del 'sys_killing' /F 1>nul 2>nul'

return ""

/* $Id: message.cms,v 1.8 2001/03/05 17:31:06 glass Exp $ */

/*------------------------------------------------------------------
 * Returns Country Identifier
 *------------------------------------------------------------------*/
MsgCountryID: procedure expose (globals)

  country = strip( SysIni( "BOTH", "PM_National", "iCountry" ),, '0'x )

  if country == "ERROR:" then
     country =  "001"
  else
     country =  right( country, 3, "0" )

return country

/*------------------------------------------------------------------
 * National Messages Procedures
 *------------------------------------------------------------------*/
MsgRead: procedure expose (globals)

  parse arg msgfile
  parse source OS2 what msgpath

  msgfile = filespec( "disk", msgpath ) ||,
            filespec( "path", msgpath ) || "NLS\" || msgfile

  country = MsgCountryID()

  if stream( msgfile"."country, "c", "query exists" ) == "" then
     country = "001"

  msgfile = msgfile"."country
  rc = stream( msgfile, "C", "OPEN READ" )

  if rc \= "READY:" then do
     say  color.error || " Error on open NLS file: "msgfile
     exit 1
  end

  do while lines(msgfile) > 0
     line = strip(linein(msgfile))

     do while right(line,1) == "\"
        line = left( line, length(line)-1 )
        line = line || strip(linein(msgfile))
     end

     if line \= "" & left(line,1) \= "#" then do
        parse value line with id "=" msg

        id  = strip(id )
        msg = strip(msg)

        i = pos( "\n", msg )
        do while i > 0
           msg = substr( msg, 1, i-1 ) || '0D0A'x || substr( msg, i+2 )
           i = pos( "\n", msg )
        end

        msg.id = msg
     end
  end

  rc = stream( msgfile, "C", "CLOSE" )
return

/*------------------------------------------------------------------
 * Get Yes or No
 *------------------------------------------------------------------*/
MsgYesNo: procedure expose (globals)

  parse arg prompt
  ok = 0

  do until ok
     call charout, prompt"? "
     pull reply
     reply = left(reply,1)

     ok = (reply == "Y") |,
          (reply == "N") |,
          (pos( reply, msg.yes ) > 0 ) |,
          (pos( reply, msg.no  ) > 0 )

     if \ok then do
        say msg.bad_yesno
     end
  end

return (reply = "Y") | ( pos( reply, msg.yes ) > 0 )

/*------------------------------------------------------------------
 * Get numeric value
 *------------------------------------------------------------------*/
MsgGetNum: procedure expose (globals)

  parse arg prompt, min, max
  ok = 0

  do until ok
     call charout, prompt"? "
     pull reply

     ok = datatype( reply, "NUMBER" ) & reply >= min & reply <= max
  end

return reply

/* $Id: config.cms,v 1.23 2001/03/20 05:16:13 glass Exp $ */

/*------------------------------------------------------------------
 * Returns Confguration Keys
 *------------------------------------------------------------------*/
CfgKeys: procedure expose (globals)

return "HOME "                      ||,
       "DOWNLOAD "                  ||,
       "DOWNLOADS_SIMULTANEOUSLY "  ||,
       "DOWNLOADS_ATTEMPTS "        ||,
       "DOWNLOADS_UTILITY "         ||,
       "DOWNLOADS_PARAMETERS "      ||,
       "SCAN_INTERVAL "             ||,
       "LOG_FILE "                  ||,
       "ERROR_LOG "                 ||,
       "MESSAGE_DONE "              ||,
       "MESSAGE_ERROR "             ||,
       "MESSAGES "                  ||,
       "CHECK_CONNECTION "          ||,
       "USE_DESKTOP "               ||,
       "KEEP_FAILED_URL "           ||,
       "KEEP_DONE_URL "

/*------------------------------------------------------------------
 * Get Configuration
 *------------------------------------------------------------------*/
CfgRead: procedure expose (globals)

  cfg.home                     = "."
  cfg.download                 = "."
  cfg.downloads_simultaneously = 3
  cfg.downloads_attempts       = 15
  cfg.downloads_utility        = sys.utils.default.prog
  cfg.downloads_parameters     = sys.utils.default.parm
  cfg.scan_interval            = 30
  cfg.log_file                 = "nul"
  cfg.error_log                = "nul"
  cfg.message_done             = 'start /n pmpopup2.exe "%m:~~%u" "Auto WGet Daemon" /BELL /B1:"OK" /T:3600 /F:"8.Helv"'
  cfg.message_error            = 'start /n pmpopup2.exe "%m:~~%u~%i" "Auto WGet Daemon" /BELL /B1:"OK" /T:3600 /F:"8.Helv"'
  cfg.messages                 = 1
  cfg.check_connection         = 0
  cfg.use_desktop              = 0
  cfg.keep_failed_url          = 1
  cfg.keep_done_url            = 0

  rc = stream( sys.config_file, "C", "OPEN READ" )

  do while lines(sys.config_file) > 0
     parse value linein(sys.config_file) with command "=" argument

     command  = translate(strip(command))
     argument = strip(argument)

     select
        when command == "HOME",
           | command == "DOWNLOAD",
           | command == "DOWNLOADS_SIMULTANEOUSLY",
           | command == "DOWNLOADS_ATTEMPTS",
           | command == "DOWNLOADS_UTILITY",
           | command == "DOWNLOADS_PARAMETERS",
           | command == "SCAN_INTERVAL",
           | command == "LOG_FILE",
           | command == "ERROR_LOG",
           | command == "MESSAGE_DONE",
           | command == "MESSAGE_ERROR" then

             cfg.command = argument

        when command == "MESSAGES",
           | command == "CHECK_CONNECTION",
           | command == "USE_DESKTOP",
           | command == "KEEP_FAILED_URL",
           | command == "KEEP_DONE_URL" then

             cfg.command = (argument == "1")
        otherwise
     end
  end

  rc = stream( sys.config_file, "C", "CLOSE" )
  cfg.file_date = stream( sys.config_file, "C", "QUERY DATETIME" )
return

/*------------------------------------------------------------------
 * Show Configuration
 *------------------------------------------------------------------*/
CfgShow: procedure expose (globals)

  key_list = CfgKeys()
  do i = 1 to words(key_list)

     key = word(key_list,i)

     if  key \= "LOG_FILE"      &,
         key \= "ERROR_LOG"     &,
         key \= "MESSAGE_DONE"  &,
         key \= "MESSAGE_ERROR" &,
         cfg.key \= ""          &,
         cfg.key \= "nul" then do

         say color.usual || "*** "msg.key  || ": " || color.bold || cfg.key
     end
  end

  call charout , color.usual
return ""

/*------------------------------------------------------------------
 * Save Configuration
 *------------------------------------------------------------------*/
CfgSave: procedure expose (globals)

  rc = stream( sys.config_file, "C", "OPEN READ" )

  do i = 1 while lines(sys.config_file) > 0
     body.i = linein(sys.config_file)
  end
  body.0 = i - 1
  rc = stream( sys.config_file, "C", "CLOSE" )

  key_list = CfgKeys()

  do i = 1 to words(key_list)
     key = word(key_list,i)

     do j = 1 to body.0
        if left( strip( body.j ), 1 ) == "#" then
           iterate

        parse value body.j with command "="
        command = translate(strip(command))

        if key == command then
           leave
     end j

     if cfg.key \= "nul" then do
        if j > body.0 then do
           comment = "CFG_"  || key
           body.j  = "# "replace( msg.comment, "0D0A"x, "0D0A"x || "# " ) ||,
                     "0D0A"x || "0D0A"x || key "=" cfg.key || "0D0A"x
           end
        else
           body.j = key "=" cfg.key

        if j > body.0 then
          body.0 = j
     end
  end i

  if stream( sys.config_file, "C", "QUERY EXISTS" ) \= "" then
     "@del " sys.config_file

  rc = stream( sys.config_file, "C", "OPEN WRITE" )

  do j = 1 to body.0
     parse value body.j with command "="
     command  = translate(strip(command))

     if command \= "MAXIMUM_DOWNLOADS_SIMULTANEOUSLY" &,
        command \= "WGET_PARAMETERS" then
        call lineout sys.config_file, body.j
  end

  rc = stream( sys.config_file, "C", "CLOSE" )
return

/*------------------------------------------------------------------
 * Check Configuration Changes
 *------------------------------------------------------------------*/
CfgCheckChanges: procedure expose (globals)

  changed = (cfg.file_date \= stream( sys.config_file, "C", "QUERY DATETIME" ))

  if changed then do
     call LogPut inf, msg.config_changed
     call CfgRead
     cfg.download = CfgCheckDownload( cfg.download )
     call CfgShow
     changed = 1
  end

return changed

/*------------------------------------------------------------------
 * Check Download Directory
 *------------------------------------------------------------------*/
CfgCheckDownload: procedure expose (globals)

  parse arg download
  download = translate( download, "\", "/" )

  if right( download, 1 ) = "\" then
     download = left( download, length(download) - 1 )

  if download \= "." then do
     setlocal
     download = directory( download )
     endlocal
  end

  if download == "" then do
     call LogPut err, msg.bad_downldir
     download = "."
  end

return download

/*------------------------------------------------------------------
 * Read Local Configuration
 *------------------------------------------------------------------*/
CfgReadLocal: procedure expose (globals)

  parse arg home

  if right( home, 1 ) \= "\" then
     home = home"\"

  cfg_file = home"awget.cfg"
  cfg_date = stream( cfg_file, "C", "QUERY DATETIME" )

  if local.config_home \= home |,
     local.file_date   \=  cfg.file_date" "cfg_date then do

     key_list = CfgKeys()
     do i = 1 to words(key_list)
        key = word(key_list,i)
        local.key = cfg.key
     end

     local.schedule    = ""
     local.config_home = home
     local.file_date   = ""

     rc = stream( cfg_file, "C", "OPEN READ" )

     do while lines(cfg_file) > 0
        parse value linein(cfg_file) with command "=" argument

        command  = translate(strip(command))
        argument = strip(argument)

        select
           when command == "DOWNLOAD",
              | command == "DOWNLOADS_ATTEMPTS",
              | command == "SCHEDULE",
              | command == "MESSAGE_DONE",
              | command == "MESSAGE_ERROR" then

                local.command = argument

           when command == "MESSAGES",
              | command == "KEEP_FAILED_URL",
              | command == "KEEP_DONE_URL" then

                local.command = (argument == "1")
           otherwise
        end
     end

     rc = stream( cfg_file, "C", "CLOSE" )
     local.file_date = cfg.file_date" "cfg_date
  end

return

/*------------------------------------------------------------------
 * Create Local Configuration
 *------------------------------------------------------------------*/
CfgCreateLocal: procedure expose (globals)

  parse arg home

  if right( home, 1 ) \= "\" then
     home = home"\"

  cfg_file = home"awget.cfg"

  if stream( cfg_file, "C", "QUERY EXISTS" ) \= "" then
     "@del " cfg_file

  rc = stream( cfg_file, "C", "OPEN WRITE" )

  key_list =  "DOWNLOAD "            ||,
              "DOWNLOADS_ATTEMPTS "  ||,
              "SCHEDULE "            ||,
              "MESSAGE_DONE "        ||,
              "MESSAGE_ERROR "       ||,
              "MESSAGES "            ||,
              "KEEP_FAILED_URL "     ||,
              "KEEP_DONE_URL "

  do i = 1 to words(key_list)
     key     = word(key_list,i)
     comment = "CFG_"  || key
     body    = "# "replace( msg.comment, "0D0A"x, "0D0A"x || "# " ) ||,
               "0D0A"x || "0D0A"x || "#" key "=" || "0D0A"x

     call lineout cfg_file, body
  end

  rc = stream( cfg_file, "C", "CLOSE" )
return


/* $Id: replace.cms,v 1.3 2001/02/16 16:47:55 glass Exp $ */

/*------------------------------------------------------------------
 * Search and replace string
 *------------------------------------------------------------------*/
replace: procedure expose (globals)

  parse arg source, string, substitute
  string = translate(string)

  i = pos( string, translate(source))

  do while i \= 0
     source = substr( source, 1, i-1 ) || substitute ||,
              substr( source, i+length(string))

     i = pos( string, translate(source), i + length(substitute))
  end

return source
