/* Auto WGet Daemon Private Plugin Sample
 * Copyright (C) 2001 by Dmitry A.Steklenev
 *
 * $Id: awppriv.cms,v 1.2 2001/04/13 10:25:00 glass Exp $
 */

signal on notready
globals = "job."

do forever
  parse value linein() with event +4 +1 info

  select
    when event == "INIT" then do
       call JobRead info
       call lineout, "DONE PLUGIN is activated"
       end

    when event == "STOP" then do
       call JobRead info
       call lineout, "DONE PLUGIN is stopped"
       exit 0
       end

    when event == "DATA" then do
       call lineout, "DONE"

       do forever
          chars = charin()
          if chars == '00'x then
             leave
       end
       end

    otherwise
       call lineout, "FAIL PLUGIN receives unknown event:" event info
  end
end

notready: exit 1

/* $Id: jobs.cms,v 1.6 2001/04/10 12:13:56 glass Exp $ */

/*------------------------------------------------------------------
 * Read Job from file
 *------------------------------------------------------------------*/
JobRead: procedure expose (globals)

  parse arg pathname

  job.object               = ""
  job.url                  = ""
  job.download             = ""
  job.message_done         = ""
  job.message_error        = ""
  job.downloads_utility    = ""
  job.downloads_parameters = ""
  job.downloads_rc         = 0
  job.downloads_info       = ""

  rc = stream( pathname, "C", "OPEN READ" )

  if rc \= "READY:" then do
     return 0
  end

  do while lines(pathname) > 0
     parse value linein(pathname) with command "=" argument

     command  = translate(strip(command))
     argument = strip(argument)

     select
        when command == "OBJECT",
           | command == "URL",
           | command == "DOWNLOAD",
           | command == "DOWNLOADS_UTILITY",
           | command == "DOWNLOADS_PARAMETERS",
           | command == "DOWNLOADS_SIMULTANEOUSLY",
           | command == "DOWNLOADS_RC",
           | command == "DOWNLOADS_INFO",
           | command == "MESSAGE_DONE",
           | command == "MESSAGE_ERROR" then

             job.command = argument
        otherwise
     end
  end

  rc = stream( pathname, "C", "CLOSE" )
return 1

/*------------------------------------------------------------------
 * Save Job to file
 *------------------------------------------------------------------*/
JobSave: procedure expose (globals)

  parse arg pathname

  if arg( 1, "omitted" ) | pathname == "" then do
     pathname = SysTempFileName( dir.jobs"\?????.job" )
     body.0   = 0
     end
  else do
     rc = stream( pathname, "C", "OPEN READ" )

     do i = 1 while lines(pathname) > 0
        body.i = linein(pathname)
     end
     body.0 = i - 1
     rc = stream( pathname, "C", "CLOSE" )
  end

  key_list = "OBJECT "               ||,
             "URL "                  ||,
             "DOWNLOAD "             ||,
             "MESSAGE_DONE "         ||,
             "MESSAGE_ERROR "        ||,
             "DOWNLOADS_UTILITY "    ||,
             "DOWNLOADS_PARAMETERS " ||,
             "DOWNLOADS_RC "         ||,
             "DOWNLOADS_INFO "

  do i = 1 to words(key_list)
     key = word(key_list,i)

     do j = 1 to body.0
        if left( strip( body.j ), 1 ) == "#" then
           iterate

        parse value body.j with command "="
        command = translate(strip(command))

        if key == command then
           leave
     end j

     body.j = key "=" job.key

     if j > body.0 then
        body.0 = j
  end i

  if stream( pathname, "C", "QUERY EXISTS" ) \= "" then
     '@del "'pathname'" /F'

  rc = stream( pathname, "C", "OPEN WRITE" )

  if rc \= "READY:" then do
     return ""
  end

  do j = 1 to body.0
     call lineout pathname, body.j
  end

  rc = stream( pathname, "C", "CLOSE" )
return pathname
