/*
 *  Wait4PPP is a REXX script that expects the output from PPP.EXE
 *  to be directed to the REXX queue passed on the command line.
 *  When PPP.EXE indicates it's connected, the program and it's
 *  arguments (also passed on the command line) is launched.
 *
 *  Author:  David Forrai <dforrai@erinet.com>
 *    Initial release
 *
 *  First, load the REXX Util functions to access SysSleep()
 */
CALL RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
CALL SysLoadFuncs
/*
 *  Parse the command line arguments
 */
PARSE ARG theQueue program args
/*
 *  Change the drive and directory to that of the program to be executed.
 */
drive = FILESPEC('drive', program)
IF drive \= '' THEN drive
path = FILESPEC('path', program)
IF path \= '' THEN 'CD '||path||'.'
name = FILESPEC('name', program)
PARSE UPPER VAR name name
IF POS('.CMD', name) > 0 THEN
   nameIsCmdFile = 1
ELSE
   nameIsCmdFile = 0
/*
 *  Set the passed read queue as the default queue
 */
CALL RXQUEUE 'SET', theQueue
/*
 *  Loop until PPP indicates a connection, terminates, slattach exits,
 *  or the loop times out (after 30 seconds of no activity).
 */
line = ''
DO UNTIL (POS('[PPP]', line) > 0) | (POS('Exiting', line) > 0) | (POS('PPP ended', line) > 0)
   IF QUEUED() \= 0 THEN DO
/*
 *  If there are lines in the queue, process all of them.  Reset the
 *  time out count when through.
 */
      DO WHILE QUEUED() \= 0
         line = LINEIN('QUEUE:')
         SAY line    /* For diagnostic purposes */
/*
 *  PPP.EXE seems sensitive to competing processes, so sleep for a
 *  full minute before processing messages in the queue.
 *
 *        IF POS('PPP started', line) > 0 THEN CALL SysSleep(60)
 */
      END
   END /* If */
   ELSE CALL SysSleep(2)
END /* do */
/*
 *  If we have a connection, launch our Internet application
 */
IF POS('[PPP]', line) > 0 THEN DO
   CALL LINEOUT 'QUEUE:', 'Wait4PPP: Program started'
   IF nameIsCmdFile = 1 THEN
      'CALL' name args
   ELSE
      name args
   CALL LINEOUT 'QUEUE:', 'Wait4PPP: Program ended'
END /* If */
/*
 *  "Timed out" may not be accurate for all other exit descriptions
 *  but it gets the job done.
 */
ELSE CALL LINEOUT 'QUEUE:', 'Wait4PPP: Timed out'
'EXIT'
