/* WebIP -- a derivitive of: */
/* REXX -- SENDIP.CMD Ver. 2.0

   Send dynamic IP via email to addressee of your choice.
   Some ISP's allow you to keep a line up 24 hours/day with
   the caviat that you drop the line at least once in that
   period -- this prog allows that to happen while keeping you
   advised of the new IP on reconnecting so you can always reach
   your private site from work or school or where ever.

   Run this from a cron job once a day or however often your ISP
   requires.

   From: Dennis Peterson
   Free to the world
*/

/* The method of finding the IP addres was enhanced to allow the address
   to be found, even if multiple TCP/IP interfaces are used. However,
   the hostanme may be blank or possibly incorrect when multiple
   interfaces are used. Best to use the IP address.

   The interface must now be specified. The defaut is the first PPP
   connection. See the bottom of the section the user (you) must fill
   out below.

   I have altered SendIP to create a short web page with links to your
   current IP address and FTP the file to another server (presumably your
   ISP's server).

   Change done by Jeff Jackowski (jeffj@ro.com, http://ro.com/~jeffj)
*/

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
Call RxFuncAdd 'FtpLoadFuncs','rxFtp','FtpLoadFuncs'
Call FtpLoadFuncs

Signal On Halt Name CLEANUP

/* Use your favorite means to restart your PPP/SLIP session */
/* 'restart_PPP' */

/********************************************
 *
 *                  NOTE: 
 *     You MUST fill in the following entries
 *
 ********************************************/

/* Enter your timezone - default is for left coast, USA */
TZ = "CST"

/* Set the administrator's name and email address.                    */
/* Used to make a link to let users easily send email about problems. */
AdminName = "Administrator"
AdminEmail = "admin@zuse.olympus.gov"

/* FTP Upload location -- where to load the web page on your other server
   (ISP) */
FTPUploadLoc = "public_html"  /* common for ISP's using UNIX, may also */
                              /* specify directories under this one,   */
                              /* but be sure to use a slash, and the   */
                              /* correct case!                         */
                              /* ex: "public_html/adirectory/here"     */
FTPUploadFile = "door.html"   /* the name to give the web page with the IP */
FTPUploadSite = "here.com"    /* FTP site to upload the page to        */
FTPUser       = "me"          /* your username for FTP access          */
FTPPassword   = "password"    /* your password for the FTP account     */

/* Define links */
/* WebLink is the page to link to on the web server running on your
   computer. The IP address is filled in dynamically */
WebLink = "index.html"
/* FTPLink works the same way. Be sure the given directory is valid
   for the anonymous account on your server. */
FTPLink = "pub"

/* Define the background to use on the web page */
BackgroundImage = "plaster.gif"

/* Tell it what device to use. ppp0 is the first PPP connection, sl0 is
   the first SLIP connection, lan0 is the first LAN/ethernet connection.
   For the second connection, use the number 1 instead of 0   */

INetDevice = 'ppp0'

/******************************************
 *
 *     No user-defined variables below here
 *
******************************************/

Outfile = 'new_ip.fil'
Call SysFileDelete Outfile

/* let's create a queue for the new IP */
newq = RxQueue("create")
Call RxQueue 'set', newq

/* The method of finding the IP addres was enhanced to allow the address
   to be found, even if multiple TCP/IP interfaces are used.
*/

'@ifconfig' INetDevice '| RxQueue' newq
Parse Pull interfacename flags
Parse Pull dumb inet IP extra

/* Now flush the queue */
Do While Queued() > 0
   Parse Pull .
end

/* now get the time and date */
Parse Value Date() With Today Month Year
Day = Left(Date('W'),3)
Year = Right(Year,4)
Parse Value Time('L') With Hour':'Minutes':'Seconds'.'Hundredths
    /* comment out the next line to prevent an http link */ 

Message =  '<HTML><HEAD><TITLE>WebIP</TITLE></HEAD><BODY background = "' ||,
           BackgroundImage || '">' ||,
           '<H2><I>WebIP</I></H2>' ||,
           'The last known IP address of the computer you are trying to' ||,
           ' reach is ' || IP ||,
           '<P><H3>Select a method of communication:</H3><UL>' ||,
           '<LI><A HREF="http://' || IP ||'/' || WebLink || '">Web (HTTP)</A>' ||,
           '<LI><A HREF="ftp://' || IP ||'/' || FTPLink || '">FTP</A>' ||,
           '<LI><A HREF="telnet://' || IP || '">Telnet</A>' ||,
           '</UL>Last updated: '|| Left(Date('W'),3) ||', '||,
           Today Month Year || ', ' || Hour || ':' || Minutes || ':' ||,
           Seconds || ' ' || TZ || '<P><HR>' ||,
           'If you are having trouble, first read ' ||,
           '<A HREF="WebIPfaq.html">the FAQ</A>. If it doesn''t help, then ' ||,
           'contact <A HREF="mailto:' || AdminEmail || '">' || AdminName ||,
           '</A> for futher assistance</BODY></HTML>'

Call Lineout Outfile, Message
Call Lineout Outfile

/* now send it off */
call FtpSetUser FTPUploadSite, FTPUser, FTPPassword
call FtpChDir FTPUploadLoc
call FtpPut Outfile, FTPUploadFile
call FtpLogoff
call FtpDropFuncs

say 'Sent WebIP web page to server'

CLEANUP:
   Call RXQueue "delete", newq
   Exit  /* Rexx */
