/* suspend.cmd */
/* By Jeff Jackowski       */
/*    jeffj@ro.com         */
/*    http://ro.com/~jeffj */
/* Puts the commuupter into suspend mode
   This script uses the apmtst library of REXX based PM automation functions
   To run:
      APM suport must be installed and hardware must have APM supprt
      apmtst must be installed (its IBM EWS availble at hobbes.nmsu.edu)
      the Power object from system setup must be open
   Arguments:
      suspend x fname
      x is the number of seconds to wait
      fname is a file name to check for the string "NoSuspend". If the file
        is not present or does not contatin the string, the computer will be
        suspended
      Both arguments or just fname may be omitted
   What happens:
      suspend.cmd changes the keyboard focus to the Power object
      it selects "Suspend" from the menus
      changes keyboard focus to the 'Are you sure?' dialog
      presses enter
   Note:
      The system will begin to enter suspend mode 6 seconds after this script
       is run with a delay of a specified number of seconds passed as a parameter
      The delays in the script are intentional for 2 reasons:
        If input is given too fast, input may be lost. This is most notable
         on systems using multiple desktops when the Power object is on a
         non-visible desktop. 
        Other programs (and other scripts of mine) may call this script and
         then need to do a little more processing. An example is AutoDial.
         It runs this script in a seporate process and then enters a loop to
         read data from the modem. If it doesn't reach this loop, it won't
         respond to the modem when someone calls its number. Being able to
         respond is a major part of AutoDial's functionality.
*/

call rxfuncadd  'APMTLoadFuncs',  'apmtext', 'APMTLoadFuncs' 
call APMTLoadFuncs;
rc = INIT_SESSION();
if rc \= 0
   then do
     say "Not connected"
     /* call END_SESSION */
     'path'
     exit
end

parse arg DelayTime CheckFile

if DelayTime \= '' then do
   DelayTime = DelayTime * 1000
   call WAIT DelayTime
end
if CheckFile \= '' then do   /* if file has string "NoSuspend", then quit */
   scan = linein(CheckFile)
   parse upper var scan chkStr
   if (chkStr = "NOSUSPEND") then exit
end

call SELECT_WINDOW "Power*"
call WAIT 2000               /* delay needed or keyboard input may be lost */
call KEYBOARD "F10"  /* the only pull down menu */
call WAIT 1000
call KEYBOARD "LEFT" /* move to the root of the menu (window submenu will appear) */
call WAIT 1000
call KEYBOARD "P"    /* select suspend */
call WAIT 1000
call SELECT_WINDOW "Workplace Shell"  /* goto the conformation dialog */
call WAIT 1000
call KEYBOARD "ENTER"                 /* say yes */
call END_SESSION

