/* REXX -- SENDIP.CMD Ver. 2.0

   Send dynamic IP via email to addressee of your choice.
   Some ISP's allow you to keep a line up 24 hours/day with
   the caviat that you drop the line at least once in that
   period -- this prog allows that to happen while keeping you
   advised of the new IP on reconnecting so you can always reach
   your private site from work or school or where ever.

   Run this from a cron job once a day or however often your ISP
   requires.

   From: Dennis Peterson
   Free to the world
*/

/* The method of finding the IP addres was enhanced to allow the address
   to be found, even if multiple TCP/IP interfaces are used. However,
   the hostanme may be blank or possibly incorrect when multiple
   interfaces are used. Best to use the IP address.

   The interface must now be specified. The defaut is the first PPP
   connection. See the bottom of the section the user (you) must fill
   out below .

   Change done by Jeff Jackowski (jeffj@ro.com, http://ro.com/~jeffj)
*/

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Signal On Halt Name CLEANUP

/* Use your favorite means to restart your PPP/SLIP session */
/* 'restart_PPP' */

CRLF='0d0a'x

/********************************************
 *
 *                  NOTE: 
 *     You MUST fill in the following entries
 *
 ********************************************/

/* Enter any comments you wish to have placed in the body of the message.
   This text will be placed following the host name and IP information.
   If you wish to have no comments then leave this blank.
   e.g. Comments = ""
*/
Comments = ''
 
/* Enter your timezone - default is for left coast, USA */
TZ = "CST"

/* set up the address lists
   e.g. From = 'slickwilly@whitehouse.gov (Slick Willy)' || CRLF
*/

From = "jeffj@ro.com (computer)" || CRLF
Reply_to = "jeffj@ro.com (please don't)" || CRLF

/* Build list of recipients. Add any number of names to CC list. Separate
   names with a comma character.
   e.g.: CC = "meatball@hoser.com,wahoo@mindless.com,hairball@cathouse.com"
*/

To = "me@here.com" || CRLF
CC = "" /* do not add CRLF to this line */
Subject = "Current IP address" || CRLF || CRLF

/* Tell it what device to use. ppp0 is the first PPP connection, sl0 is
   the first SLIP connection, lan0 is the first LAN/ethernet connection.
   For the second connection, use the number 1 instead of 0
*/

INetDevice = 'ppp0'

/******************************************
 *
 *     No user-defined variables below here
 *
******************************************/

Outfile = 'new_ip.fil'
Call SysFileDelete Outfile

/* let's create a queue for the new IP */
newq = RxQueue("create")
Call RxQueue 'set', newq

/* Now get the host name and IP and put them in the queue.
   Use OS/2's hostname.exe to get host name and ping.exe to
   get the IP. Can also use netstat.exe and a different parsing
   template if you have a netcard and a tcp/ip network installed.
*/
'@hostname | RxQueue' newq
Parse Pull Host_Name

/* The method of finding the IP addres was enhanced to allow the address
   to be found, even if multiple TCP/IP interfaces are used.
*/

'@ifconfig' INetDevice '| RxQueue' newq
Parse Pull interfacename flags
Parse Pull dumb inet IP extra

/* Now flush the queue */
Do While Queued() > 0
   Parse Pull .
end

/* now get the time and date and bundle all the header info into
   an RFC822 format for sendmail
*/
Parse Value Date() With Today Month Year
Day = Left(Date('W'),3)
Year = Right(Year,2)
Parse Value Time('L') With Hour':'Minutes':'Seconds'.'Hundredths

Message = 'Date: '|| Left(Date('W'),3) ||', '||,
           Today Month Year Hour || ':' || Minutes || ':' ||,
           Seconds || ':' ||,
           Left(Hundredths,2) TZ || CRLF ||,
           'From: ' || From ||,
           'Reply-to: ' || Reply_to ||,
           'To: ' || To ||,
           'CC: ' || CC || CRLF ||,
           'Subject: ' || Subject ||,
           'Host name =' Host_Name || CRLF ||,
           'IP =' IP || CRLF || CRLF ||,
           Comments

Call Lineout Outfile, Message
Call Lineout Outfile

/* now send it off */
'sendmail -t -a' Outfile

CLEANUP:
   Call RXQueue "delete", newq
   Exit  /* Rexx */
