/* auto dialup */
/* By Jeff Jackowski       */
/*    jeffj@ro.com         */
/*    http://ro.com/~jeffj */
/* This script will make the computer remotely dial up an ISP on demand */
/* Sequence of events:
	If the "S" paramter is given, call the suspend script (seporate process)
		The computer will enter suspend mode in 10 seconds
		AutoDial will continue to run before then
		See the instructions for the suspend script to make it work
	Wait for the phone to ring
	Wait for a person to leave a message on an answering machine
		75 seconds
	Spawn the OS/2 dialer to connect to the network
		The dialer is a text based dialer that the graphical dialer uses
		The dialer is included with Warp Connect and Warp v4.
	Wait for the dialer to connect
		75 seconds (mine is slow)
	Check the connection
	Dial again until connection is made
	Send an email with computer's IP address
		use "SENDIP21"
	Check connection every 15 minutes
		Dialer is set to disconnect after 12 minutes of inactivity
	After loss of connection, wait again for the phone to ring.
   This works great with the telnetd and ftpd programs included in Warp v4.
*/

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs
signal on halt

SerialPort = "com3:"  /* use the port your modem is attached to */
TestConnect = "@ping ro.com 1 1 | RxQueue"
  /* change "ro.com" to the domain name of your service provider */
SuspendWait = 900   /* number of seconds to wait until suspending
                       computer after a disconnect is noticed */

/* initialize a few variables */
Suspend = 0
argin.0 = 2
/* get arguments */
parse arg argin.1 argin.2
/* loop to decipher arguments */
do argstart = 1 to 2
  if (argin.argstart = "s") | (argin.argstart = "-s") | (argin.argstart = "/s")
    then Suspend = 1      /* when true, causes the suspend script to run just
                             before the serial port is opened */
  else if (argin.argstart <> "") then do
    if ((argstart = 2) & (Suspend = 0)) then  /* command with arguments */
      ConnectCommand = ConnectCommand || ' ' || argin.argstart
    else ConnectCommand = argin.argstart
  end
end
say 'Suspend =' Suspend
say 'ConnectCommand =' ConnectCommand

newq = RxQueue("create")
Call RxQueue 'set', newq
call lineout SerialPort, 'ATS0=0'   /* no auto answer */
conn = 0
do forever

  /***** Wait for connection request *****/
  req = 0
  attempts = 0
  do until req = 1
    ring = linein(SerialPort)
    parse upper var ring stat
    if stat = 'RING' then req = 1
    else do
      call SysSleep 2
      attempts = attempts + 1
      /***** Check connection *****/
      if (attempts > 615) & (conn = 1) then do /* check network every 1230 seconds */
        attempts = 0         /* reset attempts to allow check again */
        TestConnect newq
        parse upper pull appname stat host hname
        call Flush
        if stat = 'UNKNOWN' then do
          conn = 0
          call StatusOut 'Connection lost'
          call lineout SerialPort, 'ATS0=0'   /* no auto answer */
          /***** Begin task to Suspend system *****/
          if Suspend = 1 then do
            call SysFileDelete 'SuspChk'  /* allow suspension of computer */
            '@start /win suspend' SuspendWait 'SuspChk'
          end  /* suspend */
        end    /* net disconnect */
      end      /* net check */
    end        /* no ring */
  end          /* do until ring */
  call StatusOut 'Receved a ring'
  call lineout SerialPort   /* disconnect from serial port */
  if Suspend = 1 then do
    call lineout 'SuspChk', 'NoSuspend'  /* prevent suspension of computer */
    call lineout 'SuspChk'
  end

  /***** Connection loop *****/
  call lineout SerialPort   /* disconnect from serial port */
  /* wait for person to leave a message */
  call SysSleep 75
  conn = 0
  do until conn = 1
    /* connect to ISP */
    call StatusOut 'Dialing network'
    '@detach runppp'  /* runppp is separate from this script because it has a long line */
    /* wait for connection */
    call SysSleep 75
    /* test connection */
    TestConnect newq
    parse upper pull appname stat host hname
    call Flush
    if stat = 'UNKNOWN' then do
      conn = 0
      call StatusOut 'Connection not made, trying again'
      call SysSleep 120  /* wait for PPP dialer to terminate */
    end
    else do
      conn = 1
      call StatusOut 'Connected to network'
    end
    call SysSleep 10
  end

  /***** Connected *****/
  /* run connection command to send IP address */
  call StatusOut 'Running command: 'ConnectCommand
  '@detach 'ConnectCommand

end
Call RXQueue "delete", newq
exit

StatusOut: arg statStr
  /* Print out the current time and a message */
  Parse Value Date() With Today Month Year
  Parse Value Time('L') With Hour':'Minutes':'Seconds'.'Hundredths

  Message = '[' || Today Month Year || ', ' || Hour || ':' || Minutes || ':' ||,
            Seconds || ']  ' || statStr
  say Message
  return

Flush:
  /* flush queue */
  Do While Queued() > 0
    Parse Pull .
  end
  return

halt:
   Call RXQueue "delete", newq
   call lineout SerialPort
   Exit  /* Rexx */

checkcon:
  do until conn = 0
    call SysSleep 735                /* check every 12 minutes + 15 seconds */
    TestConnect newq
    parse upper pull appname stat host hname
    call Flush
    if stat = 'UNKNOWN' then do
      conn = 0
      call StatusOut 'Connection lost'
    end
  end
