/*
 * @(#)ReleaseFormServlet.java	1.29 97/05/22
 * 
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.0
 */
import java.util.*;
import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;

public class ReleaseFormServlet extends HttpServlet {

    public void service(HttpServletRequest req, HttpServletResponse res)
	throws IOException
    {
	// System.out.println("sendResponse");
        Enumeration keys;
        String key;
        String value;
	ServletOutputStream out = res.getOutputStream();
        RandomAccessFile raf = null;  
        String line = null;
 
        res.setContentType("text/html");

	String name = req.getParameter("name");
	String email = req.getParameter("e-mail");
	if (name == null || email == null) {
	    preamble(out, "Please try again");
	    out.println("<h1> Please try again </h1>");
	    out.println("<br>");
	    out.println("We were unable to record your name or email address:");
	    out.println("<blockquote>");
	    out.println("Name: " + name);
	    out.println("<br>");
	    out.println("Email: " + email);
	    out.println("</blockquote>");
	    out.println("Please fill out the entire form before downloading.");
	    postamble(out);
	  } else {
	      preamble(out, "Java Server Download Page");
	      out.println("<h1> Java Server Download Page </h1>");
	      out.println("<br>");
	      out.println("Click to download:");

	      out.println("<blockquote>");
	      addLink(out, "Solaris global zip file with documentation",
		      "/JavaServerBeta/JavaServer-beta-solaris-gl.zip");

	      out.println("<br>");
	      addLink(out, "Solaris domestic zip file with documentation",
		      "/JavaServerBeta/JavaServer-beta-solaris-dom.zip");

	      out.println("<br>");
	      addLink(out, "Windows global executable with documentation",
		      "/JavaServerBeta/JavaServer-beta-win32-gl.exe");

	      out.println("<br>");
	      addLink(out, "Windows domestic executable with documentation",
		      "/JavaServerBeta/JavaServer-beta-win32-dom.exe");

	      out.println("<br>");
	      addLink(out, "Installation Guide", 
		      "/JavaServerBeta/JavaServerBeta/system/doc/installation.html");
	      out.println("</blockquote>");

	      out.println("<p>");
	      postamble(out);

	      raf = new RandomAccessFile("/opt/access_log_files/access_log", "rw");
	    
	      while(raf.read() != -1) {
	      } 
	      raf.writeChars("\n");
	      raf.writeChars("name: " + name);
	      raf.writeChars("\n");
	      raf.writeChars("e-mail: " + email);
	      raf.writeChars("\n");
	      raf.writeChars("intended_use: " + req.getParameter("intended_use"));
	      raf.writeChars("\n");
	      raf.writeChars("\n");
	      raf.close();
	  }
    }

    private void preamble(ServletOutputStream out, String s)
	throws IOException
    {
        out.println("<HEAD><TITLE> " + s + "</TITLE></HEAD><BODY>");
    }

    private void postamble(ServletOutputStream out)
	throws IOException
    {
        out.println("</BODY>");
	out.flush();
    }

    private void addLink(ServletOutputStream out, String anchor, String link)
	throws IOException
    {
	out.println("<a href=" + link + ">" + anchor + "</a>");
    }
}
