/*
 * @(#)KeepAliveServlet.java	1.3 97/05/22
 * 
 * Copyright (c) 1995-1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.0
 */

import java.io.*;

import javax.servlet.*;
import javax.servlet.http.*;

/**
 * This is an example of different ways to do keepalive connections
 * with servlets. The Content-Length header needs to be set for
 * keep-alive to work.  This is done automatically for servlets with
 * small amounts of output (&lt;4K), but needs to be done manually
 * otherwise.
 * <P> 
 * <B>What is keep-alive, and why should you care?</B><BR>
 * <P>
 * When a browser talks to a server, it needs to establish a TCP connection.
 * Establishing this connection is expensive in terms of time.  Keep-Alive
 * connections are connections which keep the connection open for subsequent
 * requests, greatly speeding the downloading of data from the server.
 * By ensuring that you follow the simple rules illustrated below, you
 * can enable automatic establishment of Keep-Alive connections from your
 * servlet.
 *
 * @author Jim Driscoll
 * @version 1.3 05/22/97
 *
 */

public class KeepAliveServlet extends HttpServlet { 

    public void doGet(HttpServletRequest req, HttpServletResponse res)
	throws ServletException, IOException {

        res.setContentType("text/html");
        ServletOutputStream out = res.getOutputStream();

	//Set up the strings we will use for output
	String str1 = "<HTML><HEAD><TITLE> Keep-Alive Servlet Output";
	str1 = str1 + "</TITLE></HEAD><BODY>\r\n";
	String str2 = "<h1> Keep-Alive Servlet Output </h1>\r\n";
	String str3 = "<P>This is output from Keep-Alive Servlet.\r\n";
	String str4 = "</BODY></HTML>\r\n";
	int strlen1 = str1.length();
	int strlen2 = str2.length();
	int strlen3 = str3.length();
	int strlen4 = str4.length();

	String runType = req.getParameter("runType");
	if (runType == null ||runType.equals("short nohead")) {;
	    // First the "normal" way - keepalive and content-length should
	    // be automatically set
            out.print(str1);
	    out.print(str2);
	    out.print(str3);
	    out.print(str4);
	    out.close();
        } else if (runType.equals("short nohead flush")) {
	    // If you have a flush() of the output stream,
	    // content length can't be determined - so,
	    // keepalive will not be enabled!  (Don't worry,
            // the output stream is flushed on close - you
	    // won't lose any data)
            out.print(str1);
	    out.print(str2);
	    out.print(str3);
	    out.flush();
	    out.print(str4);
	    out.close();
        } else if (runType.equals("long nohead")) {
            // This way tests a large body with no content-length specified
	    // It will not, normally, have keepalive enabled
	    // Note that the cut-off for automatic determination of
	    // content-length is 4k bytes in JavaWebServer
            out.print(str1);
	    out.print(str2);
	    for (int i = 0; i < 100;i++) {
		out.println(str3);
	    }
	    out.print(str4);
	    out.close();
	} else if (runType.equals("short head")) {
	    // This way manually sets the content-length,
	    // keepalive should be on automatically
	    res.setContentLength(strlen1+strlen2+strlen3+strlen4);
            out.print(str1);
	    out.print(str2);
	    out.print(str3);
	    out.print(str4);
	    out.close();
	} else if (runType.equals("long head")) {
	    // This way manually sets the content-length on long output,
	    // which should cause keepalive to be enabled
	    res.setContentLength(strlen1+strlen2+(strlen3*100)+strlen4);
            out.print(str1);
	    out.print(str2);
	    for (int i = 0; i < 100;i++) {
		out.print(str3);
	    }
	    out.print(str4);
	    out.close();
	} else { //Bogus value
            out.println("<HTML><HEAD><TITLE> Keep-Alive Servlet Output </TITLE></HEAD><BODY>");
	    out.println("<h1> Keep-Alive Servlet Output </h1>");
	    out.println("<P>Bogus value set for querystring.");
	    out.println("<P>Set the runType parameter to one of:.");
	    out.println("short+nohead");
	    out.println("short+head");
	    out.println("long+nohead");
	    out.println("long+head");
	    out.println("</BODY></HTML>");
	    out.close();
	}
    }

    public String getServletInfo() {
        return "A servlet which demonstrates keep-alive programming";
    }
}
