/* -----------------------------------------------------------------
** Copyright 1997-98 IBM Corporation.  All rights reserved.
**
** -----------------------------------------------------------------
*/
/*
 * This is a demonstration of how to read in HTML form data and
 * write that same form data back to the browser page. No form
 * data processing is done in this servlet. See FormProcessingServlet
 * for an example of HTML form data processing and custom output.
 */

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.*;
import java.util.*;
import java.text.*;

/**
  * Example FormDisplayServlet-- 
  * This servlet demonstrates HTML form data handling and 
  * formatting output to the browser page as HTML.
  */

public class FormDisplayServlet extends HttpServlet
{
    /** 
      * @param req Instance of class HttpServletRequest.
      * @param res Instance of class HttpServletResponse.
      * @exception IOException When inputting form data or writing
      * the form data back to the browser.
      */

        public final String BASENAME = "samples";
        ResourceBundle rb = null;

        // ****************************************************************
        // * Initialize servlet when it is first loaded                   *
        // ****************************************************************
        public void init(ServletConfig config)
        throws ServletException
        {
           super.init(config);

           /* get the ResourceBundle for localization */
           try
           {
               rb = ResourceBundle.getBundle(BASENAME);
           }
           catch(Exception e)
           {
               System.out.println(e.getMessage());
           }
        }

        public void doPost(HttpServletRequest req, HttpServletResponse res)
                throws IOException
        {
                Enumeration params;
                String name;
                String[] values;
                MessageFormat mf = null;
                ServletOutputStream os;
                PrintWriter pw;
                String[] vars = {"", ""};

                res.setContentType("text/html;charset=iso-8859-1");
                pw = res.getWriter();
                
                pw.println("<HEAD>");
                pw.println("<TITLE>" + rb.getString("s1") + "</TITLE>");
                pw.println("<BODY><H2>" + rb.getString("s2") + "</H2>");
                pw.println("<P>" + rb.getString("s3") +"<BR><BR>");


                params = req.getParameterNames();
                while(params.hasMoreElements())
                {
                    name = (String)params.nextElement();
                    values = req.getParameterValues(name);
                    if (values != null) {
                      vars[0] = name;
                      vars[1] = values[0];
                      pw.println(mf.format(rb.getString("s4"), vars) + "<BR>");
                      pw.println(mf.format(rb.getString("s5"), vars) + "<BR>");
                    }
                }
                pw.println("</BODY>");

                // flush and close the print writer
                pw.flush();

        } // end of doGet() 
} // end of class FormDisplayServlet
