<?xml version='1.0'?>

<xsl:stylesheet
    xmlns:xsl='http://www.w3.org/XSL/Transform/1.0'
    xmlns:fo='http://www.w3.org/XSL/Format/1.0'
    result-ns='fo'>
  <xsl:template match='/'>
    <fo:display-sequence
        start-indent='4pt'
        end-indent='4pt'
        font-size='11pt'>
      <xsl:apply-templates/>
    </fo:display-sequence>
  </xsl:template>
  <xsl:template match='p'>
    <fo:block
        space-before='6pt'
        space-after='6pt'>
      <xsl:apply-templates/>
    </fo:block>
  </xsl:template>
  <xsl:template match='heading'>
    <fo:block
        font-size='18pt'
        font-weight='bold'
        space-before='18pt'
        space-after='12pt'>
      <xsl:apply-templates/>
    </fo:block>
  </xsl:template>
  <xsl:template match='bold'>
    <fo:inline-sequence font-weight='bold'>
      <xsl:apply-templates/>
    </fo:inline-sequence>
  </xsl:template>
  <xsl:template match='italic'>
    <fo:inline-sequence font-style='italic'>
      <xsl:apply-templates/>
    </fo:inline-sequence>
  </xsl:template>
  <xsl:template match='hr'>
    <fo:display-rule
        start-indent='12pt'
        end-indent='12pt'
        rule-thickness='1.5pt'
        space-before='18pt'
        space-after='18pt'>
      <xsl:apply-templates/>
    </fo:display-rule>
  </xsl:template>
  <xsl:template match='link'>
    <fo:simple-link
        external-destination='{@href}'
        color='rgb(0,0,255)'>
      <xsl:apply-templates/>
    </fo:simple-link>
  </xsl:template>
  <xsl:template match='display-graphic'>
    <fo:display-graphic
        width='{@max-width}'
        height='{@max-height}'
        href='{@image}'>
      <xsl:apply-templates/>
    </fo:display-graphic>
  </xsl:template>
  <xsl:template match='inline-graphic'>
    <fo:inline-graphic
        width='{@max-width}'
        height='{@max-height}'
        href='{@image}'>
      <xsl:apply-templates/>
    </fo:inline-graphic>
  </xsl:template>
</xsl:stylesheet>
