Implementing Enumeration:<br>
<java type="implements">Enumeration</java><br>

Extending Exception (hey, why not :):<br>
<java type="extends">Exception</java><br>

Using imports, several valid formats:<br>
<java type="import">java.util.Enumeration
import java.util.Hashtable
import java.util.Date;
</java><br>

<java type="class">
	public Object nextElement() {return new Boolean(false);}
</java>
<java type="class">
	public boolean hasMoreElements() { return false;}
</java>

Setting two variables in the class code: <br>
<java type="code">
	String test1 = "1Test";
	String test2 = "2Test";
	String foo = "(this should be used by the HelloWorld servlet)";
</java><br>

Including test 1 through backticks: `test1`<br>
Including test 1 through print: <java type="print">test1</java><br>
Including test 1 through code: <java type="code">out.println(test1);</java><br>
Now, the same for test 2, resp.:`test2` | <java type="print">test2</java> |
<java type="code">out.println(test1);</java><br>

Now, for some cached blocks.  First, more imports and some more code:<br>
<java type="import">
      com.bitmechanic.util.*
      java.util.Date
</java>
This should reload every 30 seconds.  But if you add "?foo=bar" to the URL,
it should reload immediately, and stay the same for 30 seconds or until
you change the value of foo.
<java type=cache policy=global ttl=30s fields=foo>
      Date cacheDate = new Date();
        cacheBuffer.append("Last cache update (global, 10s): " + cacheDate);
</java><br>

The following should reload every 5 seconds:
<java type="cache" policy="global" ttl=5s>
      Date cacheDate = new Date();
        cacheBuffer.append("Last cache update (global, 5s): " + cacheDate);
</java><br>

The following should initially reload every time you reload this page.
However, if you click on this link <a href="/gsp/basic_suite.gsp">here</a>
(which should be munged appropriately), it should start staying still
for 10 seconds.  The following one should last only 5 seconds.
<java type="cache" policy="session" ttl=10s>
      Date cacheDate = new Date();
        cacheBuffer.append("Last cache update (session, 10s): " + cacheDate);
</java><br>
<java type="cache" policy="session" ttl=5s>
      Date cacheDate = new Date();
        cacheBuffer.append("Last cache update (session, 5s): " + cacheDate);
</java><br>

Now, for some servlets:<br>
<servlet code="HelloWorld"><param name="foo" value="`foo` -!"></servlet><br>
and now, another servlet:<br>
<servlet code="ListServlets"><param name="bar" value="foo"></servlet><br>

A simple include: <java type="include" file="i:/os2httpd/public/htdocs/gsp/simple_include.gsp"></java><br>
Now "BAR" is set to: `BAR`<br>

And to test the timestamp, touch the file, and reload, making sure that
parseTime (`__parseTime`) changes when you do.<br>

