/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp.library;

import java.security.Principal;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.framework.XObject;
import org.apache.cocoon.processor.xsp.XSPUtil;
import org.apache.cocoon.processor.xsp.library.XSPCookieLibrary;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class XSPRequestLibrary {
    public static Element getAttribute(HttpServletRequest httpServletRequest, String string, Document document) {
        Object object = httpServletRequest.getAttribute(string);
        Element element = document.createElement("request:attribute");
        element.setAttribute("name", string);
        if (object != null) {
            if (object instanceof XObject) {
                DocumentFragment documentFragment = document.createDocumentFragment();
                ((XObject)object).toDOM(documentFragment);
                element.appendChild(documentFragment);
            } else {
                element.appendChild(document.createTextNode(object.toString()));
            }
        }
        return element;
    }

    public static String[] getAttributeNames(HttpServletRequest httpServletRequest) {
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = httpServletRequest.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            vector.addElement(httpServletRequest.getAttribute((String)enumeration.nextElement()));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Element getAttributeNames(HttpServletRequest httpServletRequest, Document document) {
        String[] stringArray = XSPRequestLibrary.getAttributeNames(httpServletRequest);
        Element element = document.createElement("request:attribute-names");
        int n = 0;
        while (n < stringArray.length) {
            Element element2 = document.createElement("request:attribute-name");
            element2.appendChild(document.createTextNode(stringArray[n]));
            element.appendChild(element2);
            ++n;
        }
        return element;
    }

    public static Element getAuthType(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:auth-type");
        element.appendChild(document.createTextNode(httpServletRequest.getAuthType()));
        return element;
    }

    public static Element getCharacterEncoding(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:character-encoding");
        element.appendChild(document.createTextNode(httpServletRequest.getCharacterEncoding()));
        return element;
    }

    public static Element getContentLength(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:content-length");
        element.appendChild(document.createTextNode(String.valueOf(httpServletRequest.getContentLength())));
        return element;
    }

    public static Element getContentType(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:content-type");
        element.appendChild(document.createTextNode(httpServletRequest.getContentType()));
        return element;
    }

    public static Element getContextPath(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:context-path");
        element.appendChild(document.createTextNode(httpServletRequest.getContextPath()));
        return element;
    }

    public static Element getCookies(HttpServletRequest httpServletRequest, Document document) {
        Cookie[] cookieArray = httpServletRequest.getCookies();
        Element element = document.createElement("request:cookies");
        if (cookieArray != null) {
            int n = 0;
            while (n < cookieArray.length) {
                element.appendChild(XSPCookieLibrary.getCookie(cookieArray[n], document));
                ++n;
            }
        }
        return element;
    }

    public static Element getDateHeader(HttpServletRequest httpServletRequest, String string, String string2, Document document) {
        if (string == null || string.length() == 0) {
            return null;
        }
        long l = httpServletRequest.getDateHeader(string);
        Element element = document.createElement("request:date-header");
        element.setAttribute("name", string);
        if (l != -1L) {
            String string3 = XSPUtil.formatDate(new Date(l), string2.trim());
            element.appendChild(document.createTextNode(string3));
        }
        return element;
    }

    public static Element getHeader(HttpServletRequest httpServletRequest, String string, Document document) {
        String string2 = httpServletRequest.getHeader(string);
        Element element = document.createElement("request:header");
        element.setAttribute("name", string);
        if (string2 != null) {
            element.appendChild(document.createTextNode(string2));
        }
        return element;
    }

    public static String[] getHeaderNames(HttpServletRequest httpServletRequest) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            vector.addElement(httpServletRequest.getHeader((String)enumeration.nextElement()));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Element getHeaderNames(HttpServletRequest httpServletRequest, Document document) {
        String[] stringArray = XSPRequestLibrary.getHeaderNames(httpServletRequest);
        Element element = document.createElement("request:header-names");
        int n = 0;
        while (n < stringArray.length) {
            Element element2 = document.createElement("request:header-name");
            element2.appendChild(document.createTextNode(stringArray[n]));
            element.appendChild(element2);
            ++n;
        }
        return element;
    }

    public static String[] getHeaders(HttpServletRequest httpServletRequest, String string) {
        Vector vector = new Vector();
        Enumeration enumeration = httpServletRequest.getHeaders(string);
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Element getHeaders(HttpServletRequest httpServletRequest, String string, Document document) {
        String[] stringArray = XSPRequestLibrary.getHeaders(httpServletRequest, string);
        Element element = document.createElement("request:headers");
        int n = 0;
        while (n < stringArray.length) {
            Element element2 = document.createElement("request:header");
            element2.appendChild(document.createTextNode(stringArray[n]));
            element.appendChild(element2);
            ++n;
        }
        return element;
    }

    public static Element getIntHeader(HttpServletRequest httpServletRequest, String string, Document document) {
        Element element = document.createElement("request:int-header");
        element.appendChild(document.createTextNode(String.valueOf(httpServletRequest.getIntHeader(string))));
        return element;
    }

    public static Element getLocale(HttpServletRequest httpServletRequest, Document document) {
        Element element = null;
        Locale locale = httpServletRequest.getLocale();
        Element element2 = document.createElement("request:locale");
        element = document.createElement("locale:language");
        element.appendChild(document.createTextNode(locale.getLanguage()));
        element2.appendChild(element);
        element = document.createElement("locale:country");
        element.appendChild(document.createTextNode(locale.getCountry()));
        element2.appendChild(element);
        element = document.createElement("locale:variant");
        element.appendChild(document.createTextNode(locale.getVariant()));
        element2.appendChild(element);
        return element2;
    }

    public static Locale[] getLocales(HttpServletRequest httpServletRequest) {
        Vector vector = new Vector();
        Enumeration enumeration = httpServletRequest.getLocales();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new Locale[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Element getLocales(HttpServletRequest httpServletRequest, Document document) {
        Enumeration enumeration = httpServletRequest.getLocales();
        Element element = document.createElement("request:locales");
        while (enumeration.hasMoreElements()) {
            element.appendChild(XSPRequestLibrary.getLocale(httpServletRequest, document));
        }
        return element;
    }

    public static Element getMethod(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:method");
        element.appendChild(document.createTextNode(httpServletRequest.getMethod()));
        return element;
    }

    public static Element getParameter(HttpServletRequest httpServletRequest, String string, Document document) {
        String string2 = httpServletRequest.getParameter(string);
        Element element = document.createElement("request:parameter");
        element.setAttribute("name", string);
        if (string2 != null) {
            element.appendChild(document.createTextNode(string2));
        }
        return element;
    }

    public static String[] getParameterNames(HttpServletRequest httpServletRequest) {
        Vector vector = new Vector();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Element getParameterNames(HttpServletRequest httpServletRequest, Document document) {
        String[] stringArray = XSPRequestLibrary.getParameterNames(httpServletRequest);
        Element element = document.createElement("request:parameter-names");
        int n = 0;
        while (n < stringArray.length) {
            Element element2 = document.createElement("request:parameter-name");
            element2.appendChild(document.createTextNode(stringArray[n]));
            element.appendChild(element2);
            ++n;
        }
        return element;
    }

    public static Element getParameterValues(HttpServletRequest httpServletRequest, String string, Document document) {
        String[] stringArray = httpServletRequest.getParameterValues(string);
        Element element = document.createElement("request:parameter-values");
        element.setAttribute("name", string);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                Element element2 = document.createElement("request:parameter-value");
                element2.appendChild(document.createTextNode(stringArray[n]));
                element.appendChild(element2);
                ++n;
            }
        }
        return element;
    }

    public static Element getPathInfo(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:path-info");
        element.appendChild(document.createTextNode(httpServletRequest.getPathInfo()));
        return element;
    }

    public static Element getPathTranslated(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:path-translated");
        element.appendChild(document.createTextNode(httpServletRequest.getPathTranslated()));
        return element;
    }

    public static Element getProtocol(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:protocol");
        element.appendChild(document.createTextNode(httpServletRequest.getProtocol()));
        return element;
    }

    public static Element getQueryString(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:query-string");
        element.appendChild(document.createTextNode(httpServletRequest.getQueryString()));
        return element;
    }

    public static Element getRemoteAddr(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:remote-address");
        element.appendChild(document.createTextNode(httpServletRequest.getRemoteAddr()));
        return element;
    }

    public static Element getRemoteHost(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:remote-host");
        element.appendChild(document.createTextNode(httpServletRequest.getRemoteHost()));
        return element;
    }

    public static Element getRemoteUser(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:remote-user");
        element.appendChild(document.createTextNode(httpServletRequest.getRemoteUser()));
        return element;
    }

    public static Element getRequestURI(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:request-uri");
        element.appendChild(document.createTextNode(httpServletRequest.getRequestURI()));
        return element;
    }

    public static Element getRequestedSessionId(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:requested-session-id");
        element.appendChild(document.createTextNode(httpServletRequest.getRequestedSessionId()));
        return element;
    }

    public static Element getScheme(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:scheme");
        element.appendChild(document.createTextNode(httpServletRequest.getScheme()));
        return element;
    }

    public static Element getServerName(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:server-name");
        element.appendChild(document.createTextNode(String.valueOf(httpServletRequest.getServerName())));
        return element;
    }

    public static Element getServerPort(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:server-port");
        element.appendChild(document.createTextNode(String.valueOf(httpServletRequest.getServerPort())));
        return element;
    }

    public static Element getServletPath(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:servlet-path");
        element.appendChild(document.createTextNode(httpServletRequest.getServletPath()));
        return element;
    }

    public static Element getUserPrincipal(HttpServletRequest httpServletRequest, Document document) {
        Principal principal = httpServletRequest.getUserPrincipal();
        Element element = document.createElement("request:user-principal");
        if (principal != null) {
            Element element2 = document.createElement("principal:name");
            element2.appendChild(document.createTextNode(principal.getName()));
            element.appendChild(element2);
        }
        return element;
    }

    public static Element isRequestedSessionIdFromCookie(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:is-requested-session-id-from-cookie");
        element.appendChild(document.createTextNode(String.valueOf(httpServletRequest.isRequestedSessionIdFromCookie())));
        return element;
    }

    public static Element isRequestedSessionIdFromURL(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:is-requested-session-id-from-url");
        element.appendChild(document.createTextNode(String.valueOf(httpServletRequest.isRequestedSessionIdFromURL())));
        return element;
    }

    public static Element isRequestedSessionIdValid(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:is-requested-session-id-valid");
        element.appendChild(document.createTextNode(String.valueOf(httpServletRequest.isRequestedSessionIdValid())));
        return element;
    }

    public static Element isSecure(HttpServletRequest httpServletRequest, Document document) {
        Element element = document.createElement("request:is-secure");
        element.appendChild(document.createTextNode(String.valueOf(httpServletRequest.isSecure())));
        return element;
    }

    public static Element isUserInRole(HttpServletRequest httpServletRequest, String string, Document document) {
        Element element = document.createElement("request:is-requested-session-id-valid");
        element.appendChild(document.createTextNode(String.valueOf(httpServletRequest.isUserInRole(string))));
        return element;
    }
}

