/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp.library;

import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.apache.cocoon.framework.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class XSPContextLibrary {
    public static Element getAttribute(ServletContext servletContext, String string, Document document) {
        Object object = servletContext.getAttribute(string);
        Element element = document.createElement("context:attribute");
        element.setAttribute("name", string);
        if (object != null) {
            if (object instanceof XObject) {
                DocumentFragment documentFragment = document.createDocumentFragment();
                ((XObject)object).toDOM(documentFragment);
                element.appendChild(documentFragment);
            } else {
                element.appendChild(document.createTextNode(object.toString()));
            }
        }
        return element;
    }

    public static String[] getAttributeNames(ServletContext servletContext) {
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = servletContext.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            vector.addElement(servletContext.getAttribute((String)enumeration.nextElement()));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Element getAttributeNames(ServletContext servletContext, Document document) {
        String[] stringArray = XSPContextLibrary.getAttributeNames(servletContext);
        Element element = document.createElement("context:attribute-names");
        int n = 0;
        while (n < stringArray.length) {
            Element element2 = document.createElement("context:attribute-name");
            element2.appendChild(document.createTextNode(stringArray[n]));
            element.appendChild(element2);
            ++n;
        }
        return element;
    }

    public static Element getInitParameter(ServletContext servletContext, String string, Document document) {
        String string2 = servletContext.getInitParameter(string);
        Element element = document.createElement("context:init-parameter");
        element.setAttribute("name", string);
        if (string2 != null) {
            element.appendChild(document.createTextNode(string2));
        }
        return element;
    }

    public static String[] getInitParameterNames(ServletContext servletContext) {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = servletContext.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            vector.addElement(servletContext.getInitParameter((String)enumeration.nextElement()));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Element getInitParameterNames(ServletContext servletContext, Document document) {
        String[] stringArray = XSPContextLibrary.getInitParameterNames(servletContext);
        Element element = document.createElement("context:attribute-names");
        int n = 0;
        while (n < stringArray.length) {
            Element element2 = document.createElement("context:attribute-name");
            element2.appendChild(document.createTextNode(stringArray[n]));
            element.appendChild(element2);
            ++n;
        }
        return element;
    }

    public static Element getMajorVersion(ServletContext servletContext, Document document) {
        Element element = document.createElement("context:major-version");
        element.appendChild(document.createTextNode(String.valueOf(servletContext.getMajorVersion())));
        return element;
    }

    public static Element getMimeType(ServletContext servletContext, String string, Document document) {
        Element element = document.createElement("context:mime-type");
        element.appendChild(document.createTextNode(servletContext.getMimeType(string)));
        return element;
    }

    public static Element getMinorVersion(ServletContext servletContext, Document document) {
        Element element = document.createElement("context:minor-version");
        element.appendChild(document.createTextNode(String.valueOf(servletContext.getMinorVersion())));
        return element;
    }

    public static Element getRealPath(ServletContext servletContext, String string, Document document) {
        Element element = document.createElement("context:real-path");
        element.appendChild(document.createTextNode(servletContext.getRealPath(string).replace('\\', '/')));
        return element;
    }

    public static Element getServerInfo(ServletContext servletContext, Document document) {
        Element element = document.createElement("context:real-server-info");
        element.appendChild(document.createTextNode(servletContext.getServerInfo()));
        return element;
    }
}

