/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp.language.java;

import java.io.File;
import java.util.Dictionary;
import org.apache.cocoon.processor.xsp.language.XSPPreprocessor;
import org.apache.cocoon.processor.xsp.language.java.XSPJavaProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XSPJavaPreprocessor
implements XSPPreprocessor {
    protected static XSPJavaProcessor javaProcessor = new XSPJavaProcessor();

    public Document preprocess(Document document, Dictionary dictionary) throws Exception {
        Element element = document.getDocumentElement();
        String string = (String)dictionary.get("filename");
        string = new File(string).getCanonicalPath();
        String string2 = XSPJavaProcessor.packageName(string);
        String string3 = XSPJavaProcessor.className(string);
        element.setAttribute("name", string3);
        element.setAttribute("package", string2);
        this.process(document);
        return document;
    }

    protected void process(Node node) {
        switch (node.getNodeType()) {
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                processingInstruction.setData(javaProcessor.stringEncode(processingInstruction.getData()));
                break;
            }
            case 3: {
                Element element = (Element)node.getParentNode();
                String string = element.getTagName();
                if (string.equals("xsp:expr") || string.equals("xsp:logic") || string.equals("xsp:structure")) {
                    return;
                }
                String string2 = javaProcessor.stringEncode(node.getNodeValue());
                Text text = node.getOwnerDocument().createTextNode(string2);
                Element element2 = node.getOwnerDocument().createElement("xsp:text");
                element2.appendChild(text);
                element.replaceChild(element2, node);
                break;
            }
            case 1: {
                ((Element)node).normalize();
            }
            default: {
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    this.process(nodeList.item(n2));
                    ++n2;
                }
                break block0;
            }
        }
    }
}

