/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.xsp;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cocoon.Utils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class XSPUtil {
    private static int count = 0;

    public static String baseName(String string) {
        return XSPUtil.baseName(string, ".");
    }

    public static String baseName(String string, String string2) {
        int n = string.lastIndexOf(string2);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static Node cloneNode(Node node, Document document) {
        switch (node.getNodeType()) {
            case 4: {
                return document.createCDATASection(node.getNodeValue());
            }
            case 5: 
            case 8: {
                return document.createEntityReference(node.getNodeValue());
            }
            case 1: {
                Object object;
                Element element = (Element)node;
                Element element2 = document.createElement(element.getTagName());
                NamedNodeMap namedNodeMap = element.getAttributes();
                int n = namedNodeMap.getLength();
                int n2 = 0;
                while (n2 < n) {
                    object = (Attr)namedNodeMap.item(n2);
                    element2.setAttribute(object.getName(), object.getValue());
                    ++n2;
                }
                object = element.getChildNodes();
                int n3 = object.getLength();
                int n4 = 0;
                while (n4 < n3) {
                    element2.appendChild(XSPUtil.cloneNode(object.item(n4), document));
                    ++n4;
                }
                return element2;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                return document.createProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
            }
            case 3: {
                return document.createTextNode(node.getNodeValue());
            }
        }
        return null;
    }

    protected static void doMarkup(Node node, StringBuffer stringBuffer) {
        switch (node.getNodeType()) {
            case 4: {
                stringBuffer.append("<![CDATA[\n");
                stringBuffer.append(node.getNodeValue());
                stringBuffer.append("]]>\n");
                break;
            }
            case 9: 
            case 11: {
                NodeList nodeList = node.getChildNodes();
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    XSPUtil.doMarkup(nodeList.item(n2), stringBuffer);
                    ++n2;
                }
                break;
            }
            case 1: {
                Object object;
                Element element = (Element)node;
                stringBuffer.append("<" + element.getTagName());
                NamedNodeMap namedNodeMap = element.getAttributes();
                int n = namedNodeMap.getLength();
                int n3 = 0;
                while (n3 < n) {
                    object = (Attr)namedNodeMap.item(n3);
                    stringBuffer.append(" ");
                    stringBuffer.append(object.getName());
                    stringBuffer.append("=\"");
                    stringBuffer.append(object.getValue());
                    stringBuffer.append("\"");
                    ++n3;
                }
                object = element.getChildNodes();
                int n4 = object.getLength();
                if (n4 == 0) {
                    stringBuffer.append("/>\n");
                    break;
                }
                stringBuffer.append(">");
                int n5 = 0;
                while (n5 < n4) {
                    XSPUtil.doMarkup(object.item(n5), stringBuffer);
                    ++n5;
                }
                stringBuffer.append("</");
                stringBuffer.append(element.getTagName());
                stringBuffer.append(">");
                break;
            }
            case 8: {
                stringBuffer.append("<!-- ");
                stringBuffer.append(node.getNodeValue());
                stringBuffer.append(" -->\n");
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                stringBuffer.append("<?");
                stringBuffer.append(processingInstruction.getTarget());
                stringBuffer.append(" ");
                stringBuffer.append(processingInstruction.getData());
                stringBuffer.append("?>\n");
                break;
            }
            case 3: {
                stringBuffer.append(XSPUtil.encodeMarkup(node.getNodeValue()));
                break;
            }
        }
    }

    public static String encodeMarkup(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            switch (cArray[n]) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                default: {
                    stringBuffer.append(cArray[n]);
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String fileComponent(String string) {
        int n = string.lastIndexOf(File.separator);
        return n >= 0 ? string.substring(n + 1) : string;
    }

    public static String formDecode(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '+': {
                    stringBuffer.append(' ');
                    break;
                }
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(n + 1, n + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    n += 2;
                    break;
                }
                default: {
                    stringBuffer.append(c);
                    break;
                }
            }
            ++n;
        }
        String string2 = stringBuffer.toString();
        byte[] byArray = string2.getBytes("8859_1");
        return new String(byArray);
    }

    public static String formEncode(String string) throws Exception {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            if (XSPUtil.isAlphaNumeric(cArray[n])) {
                stringBuffer.append(cArray[n]);
            } else if (cArray[n] == ' ') {
                stringBuffer.append('+');
            } else {
                stringBuffer.append('%');
                String string2 = Integer.toHexString((byte)cArray[n]).toUpperCase();
                if (string2.length() < 2) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String formatDate(Date date, String string) {
        if (string == null || string.length() == 0) {
            string = "yyyy/MM/dd hh:mm:ss aa";
        }
        try {
            return new SimpleDateFormat(string).format(date);
        }
        catch (Exception exception) {
            return date.toString();
        }
    }

    public static String getContents(InputStream inputStream) throws IOException {
        return XSPUtil.getContents(new InputStreamReader(inputStream));
    }

    public static String getContents(Reader reader) throws IOException {
        int n;
        char[] cArray = new char[4096];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = reader.read(cArray)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public static synchronized int getCount() {
        return ++count;
    }

    public static String getFileContents(String string) throws IOException {
        return XSPUtil.getContents(new FileReader(string));
    }

    public static synchronized int getSessionCount(HttpSession httpSession) {
        Integer n = (Integer)httpSession.getValue("util.counter");
        if (n == null) {
            n = new Integer(0);
        }
        int n2 = n + 1;
        httpSession.putValue("util.counter", (Object)new Integer(n2));
        return n2;
    }

    public static String getURLContents(String string) throws IOException {
        return XSPUtil.getContents(new URL(string).openStream());
    }

    public static boolean isAlphaNumeric(char c) {
        return c == '_' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9';
    }

    public static String normalizedBaseName(String string) {
        String[] stringArray = XSPUtil.split(string = XSPUtil.baseName(string), File.separator);
        int n = stringArray[0].length() == 0 ? 1 : 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        while (n2 < stringArray.length) {
            if (n2 > n) {
                stringBuffer.append(File.separator);
            }
            stringBuffer.append('_');
            char[] cArray = stringArray[n2].toCharArray();
            int n3 = 0;
            while (n3 < cArray.length) {
                if (XSPUtil.isAlphaNumeric(cArray[n3])) {
                    stringBuffer.append(cArray[n3]);
                } else {
                    stringBuffer.append('_');
                }
                ++n3;
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String pathComponent(String string) {
        int n = string.lastIndexOf(File.separator);
        return n >= 0 ? string.substring(0, n) : string;
    }

    public static String relativeFilename(String string, HttpServletRequest httpServletRequest) throws IOException {
        return XSPUtil.relativeFilename(string, httpServletRequest, null);
    }

    public static String relativeFilename(String string, HttpServletRequest httpServletRequest, ServletContext servletContext) throws IOException {
        File file = new File(string);
        if (file.isAbsolute()) {
            return string;
        }
        return new File(new File(Utils.getBasename(httpServletRequest, servletContext)).getParent(), string).getCanonicalPath();
    }

    public static String[] split(String string) {
        return XSPUtil.split(string, " \t\r\n");
    }

    public static String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    public static String toMarkup(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        XSPUtil.doMarkup(node, stringBuffer);
        return stringBuffer.toString();
    }
}

