/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.cocoon.processor.sql.ConnectionCreator;
import org.apache.cocoon.processor.sql.SQLProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConnectionDefs {
    protected Hashtable creators = new Hashtable();
    protected Hashtable query_props_table = new Hashtable();
    protected Properties default_query_props = master_default_query_props;
    protected static Properties master_default_query_props = new Properties();

    static {
        ((Hashtable)master_default_query_props).put("doc-element", "ROWSET");
        ((Hashtable)master_default_query_props).put("row-element", "ROW");
        ((Hashtable)master_default_query_props).put("tag-case", "preserve");
        ((Hashtable)master_default_query_props).put("null-indicator", "omit");
        ((Hashtable)master_default_query_props).put("id-attribute", "ID");
        ((Hashtable)master_default_query_props).put("id-attribute-column", "");
        ((Hashtable)master_default_query_props).put("count-attribute", "");
        ((Hashtable)master_default_query_props).put("query-attribute", "");
        ((Hashtable)master_default_query_props).put("skip-rows-attribute", "");
        ((Hashtable)master_default_query_props).put("max-rows-attribute", "");
        ((Hashtable)master_default_query_props).put("update-rows-attribute", "");
        ((Hashtable)master_default_query_props).put("variable-left-delimiter", "{@");
        ((Hashtable)master_default_query_props).put("variable-right-delimiter", "}");
        ((Hashtable)master_default_query_props).put("session-variable-left-delimiter", "{@session.");
        ((Hashtable)master_default_query_props).put("session-variable-right-delimiter", "}");
        ((Hashtable)master_default_query_props).put("error-element", "sqlerror");
        ((Hashtable)master_default_query_props).put("error-message-attribute", "message");
        ((Hashtable)master_default_query_props).put("error-message-element", "");
        ((Hashtable)master_default_query_props).put("error-stacktrace-attribute", "");
        ((Hashtable)master_default_query_props).put("error-stacktrace-element", "");
    }

    public ConnectionDefs(Document document) throws Exception {
        NodeList nodeList = document.getElementsByTagName("connectiondefs");
        Node[] nodeArray = new Node[nodeList.getLength()];
        int n = 0;
        while (n < nodeList.getLength()) {
            nodeArray[n] = nodeList.item(n);
            ++n;
        }
        int n2 = 0;
        while (n2 < nodeArray.length) {
            Node node = nodeArray[n2];
            NodeList nodeList2 = node.getChildNodes();
            int n3 = 0;
            while (n3 < nodeList2.getLength()) {
                Node node2 = nodeList2.item(n3);
                if (node2.getNodeType() == 1) {
                    Element element = (Element)node2;
                    String string = element.getNodeName();
                    if (string.equals("connection")) {
                        this.processConnectionDef(element);
                    } else if (string.equals("querydefs")) {
                        this.processQueryDef(element);
                    }
                }
                ++n3;
            }
            node.getParentNode().removeChild(node);
            ++n2;
        }
    }

    public Connection getConnection(String string) throws SQLException {
        ConnectionCreator connectionCreator = (ConnectionCreator)this.creators.get(string);
        return connectionCreator.getConnection();
    }

    public ConnectionCreator getConnectionCreator(String string) {
        return (ConnectionCreator)this.creators.get(string);
    }

    public Properties getQueryProperties() {
        return (Properties)((Hashtable)this.default_query_props).clone();
    }

    public Properties getQueryProperties(String string) {
        if (string == null || string.equals("")) {
            return this.getQueryProperties();
        }
        Properties properties = (Properties)this.query_props_table.get(string);
        if (properties != null) {
            return this.getQueryProperties();
        }
        return (Properties)((Hashtable)properties).clone();
    }

    protected void processConnectionDef(Element element) throws Exception {
        Object object;
        Object object2;
        String string = element.getAttribute("name");
        if (string == null || string.equals("querydefs")) {
            return;
        }
        Properties properties = new Properties();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            object2 = nodeList.item(n);
            object = object2.getNodeName();
            NodeList nodeList2 = object2.getChildNodes();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < nodeList2.getLength()) {
                Node node = nodeList2.item(n2);
                if (node.getNodeType() == 3) {
                    stringBuffer.append(node.getNodeValue());
                }
                ++n2;
            }
            ((Hashtable)properties).put(object, stringBuffer.toString());
            ++n;
        }
        if (!((Hashtable)properties).containsKey("dburl")) {
            return;
        }
        this.creators.put(string, new ConnectionCreator(properties));
        object2 = properties.getProperty("driver");
        object = SQLProcessor.drivers;
        if (object2 != null && !((Hashtable)object).containsKey(object2)) {
            ((Hashtable)object).put(object2, Class.forName((String)object2).newInstance());
        }
    }

    protected void processQueryDef(Element element) {
        Object object;
        String string = element.getAttribute("name");
        if (string == null) {
            return;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        Properties properties = new Properties(master_default_query_props);
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            object = namedNodeMap.item(n);
            ((Hashtable)properties).put(object.getNodeName(), object.getNodeValue());
            ++n;
        }
        this.query_props_table.put(string, properties);
        object = element.getAttribute("default");
        if (object != null && (((String)object).equals("y") || ((String)object).equals("yes"))) {
            this.default_query_props = properties;
        }
    }
}

