/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.cocoon.processor.sql.Column;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ColumnFormatter {
    protected Properties formats_by_name = new Properties();
    protected Properties formats_by_type = new Properties();

    protected ColumnFormatter(Element element) {
        NodeList nodeList = element.getElementsByTagName("column");
        Element[] elementArray = new Element[nodeList.getLength()];
        int n = 0;
        while (n < elementArray.length) {
            elementArray[n] = (Element)nodeList.item(n);
            ++n;
        }
        int n2 = 0;
        while (n2 < elementArray.length) {
            Element element2 = elementArray[n2];
            String string = element2.getAttribute("name");
            String string2 = element2.getAttribute("type");
            String string3 = element2.getAttribute("format");
            this.putFormat(string, string2, string3);
            ++n2;
        }
    }

    protected void addColumnNode(Document document, Element element, Column column, ResultSet resultSet, int n) throws SQLException {
        String string = this.getFormat(column);
        if (string != null) {
            if (column.type.equals("timestamp") || column.type.equals("time") || column.type.equals("date") || column.type.equals("datetime")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
                element.appendChild(document.createTextNode(simpleDateFormat.format(resultSet.getDate(n))));
                return;
            }
            if ((column.type.equals("varchar") || column.type.equals("text")) && string.equals("br")) {
                StringBuffer stringBuffer = new StringBuffer();
                StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(resultSet.getString(n));
                char c = stringCharacterIterator.first();
                while (c != '\uffff') {
                    if (c == '\n') {
                        if (stringBuffer.length() > 0) {
                            element.appendChild(document.createTextNode(stringBuffer.toString()));
                            stringBuffer.setLength(0);
                        }
                        element.appendChild(document.createElement("br"));
                    } else {
                        stringBuffer.append(c);
                    }
                    c = stringCharacterIterator.next();
                }
                if (stringBuffer.length() > 0) {
                    element.appendChild(document.createTextNode(stringBuffer.toString()));
                }
                return;
            }
        }
        element.appendChild(document.createTextNode(resultSet.getString(n)));
    }

    protected String getFormat(Column column) {
        String string = this.formats_by_name.getProperty(column.name);
        if (string == null) {
            string = this.formats_by_type.getProperty(column.type);
        }
        return string;
    }

    protected void putFormat(String string, String string2, String string3) {
        if (string3 == null || string3.equals("")) {
            return;
        }
        if (string == null || string.equals("") && string2 != null && !string2.equals("")) {
            ((Hashtable)this.formats_by_type).put(string2, string3);
        } else {
            ((Hashtable)this.formats_by_name).put(string, string3);
        }
    }
}

