/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.ldap;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.cocoon.framework.AbstractActor;
import org.apache.cocoon.framework.Status;
import org.apache.cocoon.processor.Processor;
import org.apache.cocoon.processor.ldap.LdapDefs;
import org.apache.cocoon.processor.ldap.LdapQueryCreator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LdapProcessor
extends AbstractActor
implements Processor,
Status {
    public String getStatus() {
        return "Ldap Processor";
    }

    public boolean hasChanged(Object object) {
        return true;
    }

    public Document process(Document document, Dictionary dictionary) throws Exception {
        LdapDefs ldapDefs = new LdapDefs(document);
        NodeList nodeList = document.getElementsByTagName("ldap-query");
        Node[] nodeArray = new Node[nodeList.getLength()];
        int n = 0;
        while (n < nodeList.getLength()) {
            nodeArray[n] = nodeList.item(n);
            ++n;
        }
        int n2 = 0;
        while (n2 < nodeArray.length) {
            Node node = nodeArray[n2];
            if (node.getNodeType() == 1) {
                Object object;
                Element element = (Element)node;
                String string = element.getAttribute("defs");
                Properties properties = ldapDefs.getQueryProperties(string);
                NamedNodeMap namedNodeMap = element.getAttributes();
                int n3 = 0;
                while (n3 < namedNodeMap.getLength()) {
                    object = namedNodeMap.item(n3);
                    ((Hashtable)properties).put(object.getNodeName(), object.getNodeValue());
                    ++n3;
                }
                object = ldapDefs.getLdapContext(properties.getProperty("server"));
                this.processQuery(document, dictionary, element, properties, (LdapContext)object);
            }
            ++n2;
        }
        return document;
    }

    protected void processQuery(Document document, Dictionary dictionary, Element element, Properties properties, LdapContext ldapContext) throws Exception {
        Object object;
        String string = properties.getProperty("doc-element");
        String string2 = properties.getProperty("row-element");
        String string3 = properties.getProperty("id-attribute");
        Element element2 = document.createElement(string);
        String string4 = properties.getProperty("ldap-searchbase");
        string4 = string4 == null ? "" : string4;
        NodeList nodeList = element.getChildNodes();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nodeList.getLength()) {
            object = nodeList.item(n);
            if (object.getNodeType() == 3) {
                stringBuffer.append(object.getNodeValue());
            }
            ++n;
        }
        try {
            object = LdapQueryCreator.getQuery(stringBuffer.toString(), properties, dictionary);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            NamingEnumeration<SearchResult> namingEnumeration = ldapContext.search(string4, (String)object, searchControls);
            Element element3 = element2;
            Element element4 = null;
            while (namingEnumeration != null && namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                element3 = element4 = document.createElement(string2);
                element4.setAttribute(string3, searchResult.getName());
                Attributes attributes = searchResult.getAttributes();
                if (attributes != null) {
                    NamingEnumeration<? extends Attribute> namingEnumeration2 = attributes.getAll();
                    while (namingEnumeration2.hasMoreElements()) {
                        Attribute attribute = namingEnumeration2.next();
                        String string5 = attribute.getID();
                        NamingEnumeration<?> namingEnumeration3 = attribute.getAll();
                        while (namingEnumeration3.hasMoreElements()) {
                            Element element5 = document.createElement(string5);
                            element5.appendChild(document.createTextNode((String)namingEnumeration3.nextElement()));
                            element3.appendChild(element5);
                        }
                    }
                }
                element2.appendChild(element3);
            }
            element.getParentNode().replaceChild(element2, element);
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
        }
    }
}

