/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.ldap;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.ldap.LdapContext;
import org.apache.cocoon.processor.ldap.LdapContextCreator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LdapDefs {
    protected Hashtable creators = new Hashtable();
    protected Hashtable query_props = new Hashtable();
    protected Properties default_query_props = master_default_query_props;
    protected static Properties master_default_query_props = new Properties();

    static {
        ((Hashtable)master_default_query_props).put("doc-element", "ldapsearch");
        ((Hashtable)master_default_query_props).put("row-element", "searchresult");
        ((Hashtable)master_default_query_props).put("id-attribute", "ID");
        ((Hashtable)master_default_query_props).put("id-attribute-column", "");
        ((Hashtable)master_default_query_props).put("variable-left-delimiter", "{@");
        ((Hashtable)master_default_query_props).put("variable-right-delimiter", "}");
        ((Hashtable)master_default_query_props).put("session-variable-left-delimiter", "{@session.");
        ((Hashtable)master_default_query_props).put("session-variable-right-delimiter", "}");
        ((Hashtable)master_default_query_props).put("error-element", "ldaperror");
        ((Hashtable)master_default_query_props).put("error-message-attribute", "message");
        ((Hashtable)master_default_query_props).put("error-message-element", "");
        ((Hashtable)master_default_query_props).put("error-stacktrace-attribute", "");
        ((Hashtable)master_default_query_props).put("error-stacktrace-element", "");
    }

    public LdapDefs(Document document) throws Exception {
        NodeList nodeList = document.getElementsByTagName("ldap-defs");
        Node[] nodeArray = new Node[nodeList.getLength()];
        int n = 0;
        while (n < nodeList.getLength()) {
            nodeArray[n] = nodeList.item(n);
            ++n;
        }
        int n2 = 0;
        while (n2 < nodeArray.length) {
            Node node = nodeArray[n2];
            NodeList nodeList2 = node.getChildNodes();
            int n3 = 0;
            while (n3 < nodeList2.getLength()) {
                Node node2 = nodeList2.item(n3);
                if (node2.getNodeType() == 1) {
                    Element element = (Element)node2;
                    String string = element.getNodeName();
                    if (string.equals("ldap-server")) {
                        this.processLdapDef(element);
                    } else if (string.equals("ldap-querydefs")) {
                        this.processQueryDef(element);
                    }
                }
                ++n3;
            }
            node.getParentNode().removeChild(node);
            ++n2;
        }
    }

    public LdapContext getLdapContext(String string) throws Exception {
        LdapContextCreator ldapContextCreator = (LdapContextCreator)this.creators.get(string);
        return ldapContextCreator.getLdapContext();
    }

    public Properties getQueryProperties(String string) throws Exception {
        if (string == null) {
            return this.default_query_props;
        }
        Properties properties = (Properties)this.query_props.get(string);
        return properties;
    }

    protected void processLdapDef(Element element) throws Exception {
        String string = element.getAttribute("name");
        if (string == null) {
            return;
        }
        Properties properties = new Properties();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string2 = node.getNodeName();
            NodeList nodeList2 = node.getChildNodes();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < nodeList2.getLength()) {
                Node node2 = nodeList2.item(n2);
                if (node2.getNodeType() == 3) {
                    stringBuffer.append(node2.getNodeValue());
                }
                ++n2;
            }
            ((Hashtable)properties).put(string2, stringBuffer.toString());
            ++n;
        }
        if (!((Hashtable)properties).containsKey("ldap-serverurl")) {
            return;
        }
        this.creators.put(string, new LdapContextCreator(properties));
    }

    protected void processQueryDef(Element element) {
        Object object;
        String string = element.getAttribute("name");
        if (string == null) {
            return;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        Properties properties = new Properties(master_default_query_props);
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            object = namedNodeMap.item(n);
            ((Hashtable)properties).put(object.getNodeName(), object.getNodeValue());
            ++n;
        }
        this.query_props.put(string, properties);
        object = element.getAttribute("default");
        if (object != null && (((String)object).equals("y") || ((String)object).equals("yes"))) {
            this.default_query_props = properties;
        }
    }
}

