/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.processor.dcp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.cocoon.framework.Director;
import org.apache.cocoon.interpreter.Instance;
import org.apache.cocoon.interpreter.Interpreter;
import org.apache.cocoon.interpreter.InterpreterFactory;
import org.apache.cocoon.interpreter.Module;
import org.apache.cocoon.processor.dcp.DCPException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DCPEngine {
    private static final String OBJECT_PI = "dcp-object";
    private static final String CONTENT_PI = "dcp-content";
    private static final String VARIABLE_PI = "dcp-var";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String LANGUAGE_ATTRIBUTE = "language";
    private static final String CODE_ATTRIBUTE = "code";
    private static final String METHOD_ATTRIBUTE = "method";
    private InterpreterFactory interpreterFactory;
    private Document document;
    private Director director;
    private Dictionary parameters;
    private Hashtable instances;
    private Hashtable globalVariables;

    public DCPEngine(Document document, InterpreterFactory interpreterFactory, Dictionary dictionary) {
        this.document = document;
        this.interpreterFactory = interpreterFactory;
        this.parameters = dictionary;
        this.instances = new Hashtable(10);
        this.globalVariables = new Hashtable(10);
    }

    private void doProcess(Node node) {
        short s = node.getNodeType();
        switch (s) {
            case 1: 
            case 9: {
                Node[] nodeArray = this.getChildren(node);
                int n = 0;
                while (n < nodeArray.length) {
                    this.doProcess(nodeArray[n]);
                    ++n;
                }
                break;
            }
            case 7: {
                Node node2 = node.getParentNode();
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                try {
                    String string = processingInstruction.getTarget();
                    if (string.equals(OBJECT_PI)) {
                        this.processObject(processingInstruction);
                        node2.removeChild(processingInstruction);
                        break;
                    }
                    if (string.equals(CONTENT_PI)) {
                        Node node3 = this.processContent(processingInstruction);
                        if (node3 == null) {
                            node2.removeChild(processingInstruction);
                            break;
                        }
                        node2.replaceChild(node3, processingInstruction);
                        break;
                    }
                    if (!string.equals(VARIABLE_PI)) break;
                    this.processVariable(processingInstruction);
                    node2.removeChild(processingInstruction);
                }
                catch (Exception exception) {
                    String string = exception.getMessage();
                    String string2 = exception.getClass().getName();
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
                    exception.printStackTrace(printWriter);
                    Text text = this.document.createTextNode("{DCP Error: " + string2 + ": " + string + "}\n" + stringWriter.toString());
                    node2.replaceChild(text, processingInstruction);
                }
                break;
            }
        }
    }

    private Node[] getChildren(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        Node[] nodeArray = new Node[n];
        int n2 = 0;
        while (n2 < n) {
            nodeArray[n2] = nodeList.item(n2);
            ++n2;
        }
        return nodeArray;
    }

    /*
     * Unable to fully structure code
     */
    private void parseAttributes(String var1_1, Hashtable var2_2) {
        var3_3 = var1_1.length();
        var4_4 = var1_1.toCharArray();
        try {
            var5_5 = 0;
            ** GOTO lbl35
            {
                ++var5_5;
                do {
                    if (var5_5 < var3_3 && var4_4[var5_5] <= ' ') continue block2;
                    var6_7 = new StringBuffer();
                    while (var5_5 < var3_3 && var4_4[var5_5] != '=' && var4_4[var5_5] > ' ') {
                        var6_7.append(var4_4[var5_5++]);
                    }
                    var7_8 = var6_7.toString();
                    while (var5_5 < var3_3 && var4_4[var5_5] <= ' ') {
                        ++var5_5;
                    }
                    if (var4_4[var5_5++] == '=') ** GOTO lbl21
                    throw new Exception("Invalid attribute name: '" + var7_8 + "'");
lbl-1000:
                    // 1 sources

                    {
                        ++var5_5;
lbl21:
                        // 2 sources

                        ** while (var5_5 < var3_3 && var4_4[var5_5] <= ' ')
                    }
lbl22:
                    // 1 sources

                    if (var4_4[var5_5++] != '\"') {
                        throw new Exception("Invalid attribute value for '" + var7_8 + "'");
                    }
                    var8_9 = new StringBuffer();
                    while (var5_5 < var3_3 && var4_4[var5_5] != '\"') {
                        var8_9.append(var4_4[var5_5++]);
                    }
                    var9_10 = var8_9.toString();
                    if (var5_5 == var3_3 || var4_4[var5_5] != '\"') {
                        throw new Exception("Unterminated string '" + var9_10 + "' in attribute '" + var7_8 + "'");
                    }
                    var2_2.put(var7_8, var9_10);
                    ++var5_5;
lbl35:
                    // 2 sources

                } while (var5_5 < var3_3);
            }
        }
        catch (Exception var5_6) {
            System.err.println(var5_6.getMessage());
        }
    }

    public void process() throws Exception {
        this.doProcess(this.document);
        Enumeration enumeration = this.instances.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Instance instance = (Instance)this.instances.get(string);
            instance.destroy();
        }
    }

    private Node processContent(ProcessingInstruction processingInstruction) throws Exception {
        Hashtable hashtable = (Hashtable)this.globalVariables.clone();
        this.parseAttributes(processingInstruction.getData(), hashtable);
        String string = (String)hashtable.get(METHOD_ATTRIBUTE);
        if (string == null) {
            throw new DCPException("Missing method name in content generation");
        }
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        try {
            string2 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DCPException("Invalid method reference: " + string);
        }
        Instance instance = (Instance)this.instances.get(string2);
        if (instance == null) {
            throw new DCPException("Undefined object: " + string2);
        }
        return instance.invoke(string3, hashtable, processingInstruction);
    }

    private void processObject(ProcessingInstruction processingInstruction) throws Exception {
        Hashtable hashtable = new Hashtable();
        this.parseAttributes(processingInstruction.getData(), hashtable);
        String string = (String)hashtable.get(NAME_ATTRIBUTE);
        if (string == null) {
            throw new DCPException("Missing name in object definition");
        }
        if (this.instances.containsKey(string)) {
            throw new DCPException("Duplicate object name: " + string);
        }
        String string2 = (String)hashtable.get(CODE_ATTRIBUTE);
        if (string2 == null) {
            throw new DCPException("Missing code location in object definition");
        }
        String string3 = (String)hashtable.get(LANGUAGE_ATTRIBUTE);
        Interpreter interpreter = this.interpreterFactory.getInterpreter(string3);
        Module module = interpreter.createModule(string2);
        Instance instance = module.createInstance(this.document, this.parameters);
        this.instances.put(string, instance);
    }

    private void processVariable(ProcessingInstruction processingInstruction) throws Exception {
        this.parseAttributes(processingInstruction.getData(), this.globalVariables);
    }
}

