/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.interpreter.ecmascript;

import FESI.jslib.JSGlobalObject;
import FESI.jslib.JSUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Dictionary;
import java.util.Vector;
import org.apache.cocoon.interpreter.Instance;
import org.apache.cocoon.interpreter.LanguageException;
import org.apache.cocoon.interpreter.Module;
import org.apache.cocoon.interpreter.ecmascript.EcmaScriptEvaluator;
import org.apache.cocoon.interpreter.ecmascript.EcmaScriptInstance;
import org.w3c.dom.Document;

public class EcmaScriptModule
implements Module {
    private static String[] extensions = new String[]{"FESI.Extensions.BasicIO", "FESI.Extensions.FileIO", "FESI.Extensions.JavaAccess", "FESI.Extensions.Database", "FESI.Extensions.OptionalRegExp"};
    private static String initScript = null;
    private static URL url = null;
    private static final String INIT_SCRIPT = "org/apache/cocoon/interpreter/ecmascript/initScript.es";
    long lastModified;
    private File scriptFile = null;
    private String scriptName;
    private String scriptText;
    private Vector evaluatorPool;
    private JSGlobalObject globalEvaluator;

    public EcmaScriptModule(String string) throws LanguageException {
        this.scriptName = string;
        try {
            if (initScript == null) {
                initScript = EcmaScriptModule.getFileContents(ClassLoader.getSystemResourceAsStream(INIT_SCRIPT));
            }
        }
        catch (Exception exception) {
            throw new LanguageException("Could not find ECMAScript initialization file. The archive is probably damaged: " + exception.toString());
        }
    }

    public Instance createInstance(Document document, Dictionary dictionary) throws LanguageException {
        try {
            Object object;
            if (this.scriptFile == null) {
                object = (String)dictionary.get("path");
                if (object != null) {
                    this.scriptName = String.valueOf(object) + this.scriptName;
                }
                this.scriptFile = new File(this.scriptName);
                this.lastModified = this.scriptFile.lastModified();
                if (!this.scriptFile.canRead()) {
                    throw new LanguageException("Can't open file " + this.scriptName);
                }
                this.loadScript();
            }
            if (this.scriptFile.lastModified() != this.lastModified) {
                this.loadScript();
                this.lastModified = this.scriptFile.lastModified();
            }
            object = null;
            int n = this.evaluatorPool.size();
            int n2 = 0;
            while (n2 < n) {
                object = (EcmaScriptEvaluator)this.evaluatorPool.elementAt(n2);
                if (((EcmaScriptEvaluator)object).acquire()) break;
                ++n2;
            }
            if (n2 == n) {
                object = new EcmaScriptEvaluator(this.globalEvaluator, extensions);
                ((EcmaScriptEvaluator)object).acquire();
                this.evaluatorPool.addElement(object);
            }
            JSGlobalObject jSGlobalObject = ((EcmaScriptEvaluator)object).getGlobalObject();
            jSGlobalObject.setMember("global", (Object)jSGlobalObject.makeObjectWrapper((Object)this.globalEvaluator));
            Object v = dictionary.get("request");
            jSGlobalObject.setMember("request", (Object)jSGlobalObject.makeObjectWrapper(v));
            jSGlobalObject.setMember("document", (Object)jSGlobalObject.makeObjectWrapper((Object)document));
            System.out.println("Ending...");
            return new EcmaScriptInstance((EcmaScriptEvaluator)object, document);
        }
        catch (Exception exception) {
            throw new LanguageException(exception.getMessage());
        }
    }

    private static String getFileContents(InputStream inputStream) throws IOException {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[4096];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = inputStreamReader.read(cArray)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    private static String getFileContents(String string) throws IOException {
        return EcmaScriptModule.getFileContents(new FileInputStream(string));
    }

    private void loadScript() throws LanguageException {
        try {
            this.globalEvaluator = JSUtil.makeEvaluator((String[])extensions);
            this.scriptText = EcmaScriptModule.getFileContents(this.scriptName);
            this.globalEvaluator.eval(initScript);
            this.globalEvaluator.eval(this.scriptText);
            this.evaluatorPool = new Vector();
            this.evaluatorPool.addElement(new EcmaScriptEvaluator(this.globalEvaluator, extensions));
        }
        catch (Exception exception) {
            throw new LanguageException("Error creating EcmaScript evaluator: " + exception.getMessage());
        }
    }
}

