/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.framework;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;

public class Monitor {
    private Hashtable table;

    public Monitor(int n) {
        this.table = new Hashtable(n);
    }

    public boolean hasChanged(Object object) {
        Object v = this.table.get(object);
        if (v != null) {
            Container container = (Container)v;
            return container.timestamp != this.timestamp(container.resource);
        }
        return true;
    }

    private long timestamp(Object object) {
        long l;
        if (object instanceof File) {
            l = ((File)object).lastModified();
        } else if (object instanceof URL) {
            try {
                l = ((URL)object).openConnection().getLastModified();
            }
            catch (IOException iOException) {
                l = 0L;
            }
        } else {
            throw new IllegalArgumentException("Resource not monitorizable.");
        }
        return l;
    }

    public void watch(Object object, Object object2) {
        this.table.put(object, new Container(object2, this.timestamp(object2)));
    }

    class Container {
        public Object resource;
        public long timestamp;

        public Container(Object object, long l) {
            this.resource = object;
            this.timestamp = l;
        }
    }
}

